/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.security.auth.context.ResultAwareLoginContext;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.CommitFuture;
import org.kaazing.gateway.transport.DefaultCommitFuture;
import org.kaazing.gateway.transport.DefaultUpgradeFuture;
import org.kaazing.gateway.transport.Direction;
import org.kaazing.gateway.transport.SslUtils;
import org.kaazing.gateway.transport.UpgradeFuture;
import org.kaazing.gateway.transport.bridge.CachingMessageEncoder;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.gateway.transport.bridge.MessageEncoder;
import org.kaazing.gateway.transport.http.DefaultResponseFuture;
import org.kaazing.gateway.transport.http.HttpAcceptProcessor;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpConnectSession;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.ResponseFuture;
import org.kaazing.gateway.transport.http.bridge.HttpHeaderNameComparator;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBuffer;
import org.kaazing.gateway.transport.http.bridge.filter.HttpProtocolCompatibilityFilter;
import org.kaazing.gateway.util.InternalSystemProperty;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.IoSessionEx;

public class DefaultHttpSession
extends AbstractBridgeSession<DefaultHttpSession, HttpBuffer>
implements HttpAcceptSession,
HttpConnectSession {
    private static final String DEFAULT_CACHE_KEY = "http";
    private static final String GZIPPED_CACHE_KEY = "http/gzipped";
    private static final String UTF_8 = "utf-8";
    private final Map<String, List<String>> writeHeaders;
    private final Set<HttpCookie> writeCookies;
    private HttpVersion version;
    private Map<String, List<String>> readHeaders;
    private Collection<HttpCookie> readCookies;
    private final boolean secure;
    private URI requestURL;
    private HttpMethod method;
    private URI requestURI;
    private Map<String, List<String>> parameters;
    private HttpStatus status;
    private String reason;
    private URI servicePath;
    private URI pathInfo;
    private IoHandler upgradeHandler;
    private final DefaultUpgradeFuture upgradeFuture;
    private final CommitFuture commitFuture;
    private final ResponseFuture responseFuture;
    private final AtomicBoolean committing;
    private final AtomicBoolean connectionClose;
    private ResultAwareLoginContext loginContext;
    private final AtomicBoolean shutdownWrite;
    private Queue<IoBufferEx> deferredReads = new ConcurrentLinkedQueue<IoBufferEx>();
    private boolean isChunked;
    private boolean isGzipped;
    private boolean httpxeSpecCompliant;
    private int redirectsAllowed;
    private ResourceAddress redirectlocalAddress;
    private ResourceAddress redirectRemoteAddress;

    private DefaultHttpSession(IoServiceEx service, IoProcessorEx<DefaultHttpSession> processor, ResourceAddress address, ResourceAddress remoteAddress, IoSessionEx parent, IoBufferAllocatorEx<HttpBuffer> allocator, Direction direction, Properties configuration) {
        super(service, processor, address, remoteAddress, parent, allocator, direction);
        this.writeHeaders = new LinkedHashMap<String, List<String>>();
        this.writeCookies = new HashSet<HttpCookie>();
        this.status = direction == Direction.READ ? HttpStatus.SUCCESS_OK : null;
        this.reason = null;
        this.secure = SslUtils.isSecure((IoSession)parent);
        this.committing = new AtomicBoolean(false);
        this.connectionClose = new AtomicBoolean(false);
        this.shutdownWrite = new AtomicBoolean(false);
        this.upgradeFuture = new DefaultUpgradeFuture((IoSession)parent);
        this.commitFuture = new DefaultCommitFuture((IoSession)this);
        this.responseFuture = direction == Direction.READ ? null : new DefaultResponseFuture((IoSession)this);
        this.httpxeSpecCompliant = configuration == null ? false : InternalSystemProperty.HTTPXE_SPECIFICATION.getBooleanProperty(configuration);
        this.redirectsAllowed = 0;
    }

    public DefaultHttpSession(IoServiceEx service, IoProcessorEx<DefaultHttpSession> processor, ResourceAddress address, ResourceAddress remoteAddress, IoSessionEx parent, IoBufferAllocatorEx<HttpBuffer> allocator, Properties configuration) {
        this(service, processor, address, remoteAddress, parent, allocator, Direction.WRITE, configuration);
        this.requestURL = remoteAddress.getResource();
        try {
            this.requestURI = new URI(null, null, null, 0, this.requestURL.getPath(), this.requestURL.getQuery(), this.requestURL.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.parameters = new HashMap<String, List<String>>();
        String query = this.requestURL.getRawQuery();
        if (query != null) {
            String[] nvPairs;
            for (String nvPair : nvPairs = query.split("&")) {
                int equalAt = nvPair.indexOf(61);
                if (equalAt != -1) {
                    String parameterName = nvPair.substring(0, equalAt);
                    String parameterValue = nvPair.substring(equalAt + 1);
                    this._addParameter(DefaultHttpSession.decodeURL(parameterName), DefaultHttpSession.decodeURL(parameterValue));
                    continue;
                }
                this._addParameter(DefaultHttpSession.decodeURL(nvPair), "");
            }
        }
        this.version = HttpVersion.HTTP_1_1;
        this.method = HttpMethod.GET;
        this.readHeaders = new TreeMap<String, List<String>>(HttpHeaderNameComparator.INSTANCE);
        this.readCookies = Collections.emptySet();
        this.servicePath = null;
        this.pathInfo = null;
        this.redirectsAllowed = 0;
    }

    public void setSubject(Subject subject) {
        super.setSubject(subject);
    }

    public CachingMessageEncoder getMessageEncoder() {
        return new CachingMessageEncoder(){

            public <T extends Message> IoBufferEx encode(MessageEncoder<T> encoder, T message, IoBufferAllocatorEx<?> allocator, int flags) {
                String cacheKey;
                String string = cacheKey = DefaultHttpSession.this.isGzipped() ? DefaultHttpSession.GZIPPED_CACHE_KEY : DefaultHttpSession.DEFAULT_CACHE_KEY;
                if (DefaultHttpSession.this.isChunked()) {
                    cacheKey = cacheKey + "/chunked";
                }
                return this.encode(cacheKey, encoder, message, allocator, flags);
            }
        };
    }

    private static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void _addParameter(String parameterName, String parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue");
        }
        List<String> parameterValues = this._getParameterValues(parameterName);
        parameterValues.add(parameterValue);
    }

    private List<String> _getParameterValues(String parameterName) {
        List<String> parameterValues = this.parameters.get(parameterName);
        if (parameterValues == null) {
            parameterValues = new ArrayList<String>();
            this.parameters.put(parameterName, parameterValues);
        }
        return parameterValues;
    }

    public DefaultHttpSession(IoServiceEx service, IoProcessorEx<DefaultHttpSession> processor, ResourceAddress address, ResourceAddress remoteAddress, IoSessionEx parent, IoBufferAllocatorEx<HttpBuffer> allocator, HttpRequestMessage request, URI serviceURI, Properties configuration) {
        this(service, processor, address, remoteAddress, parent, allocator, Direction.READ, configuration);
        HttpUtils.excludeHeaders(request, new String[]{"X-Next-Protocol"});
        this.readHeaders = request.getModifiableHeaders();
        this.readCookies = request.getCookies();
        this.version = request.getVersion();
        this.method = request.getMethod();
        this.requestURI = request.getRequestURI();
        this.parameters = request.getParameters();
        String host = request.getHeader("Host");
        this.requestURL = URI.create((this.secure ? "https" : DEFAULT_CACHE_KEY) + "://" + host + this.requestURI);
        this.servicePath = URI.create(serviceURI.getPath());
        URI relative = this.servicePath.relativize(this.requestURI);
        String relativePath = relative.getPath();
        this.pathInfo = relativePath != null && !relativePath.isEmpty() ? (relativePath.startsWith("/") ? relative : URI.create("/" + relative)) : relative;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(HttpVersion version) {
        this.version = version;
    }

    public Set<String> getReadHeaderNames() {
        return this.readHeaders.keySet();
    }

    @Override
    public String getReadHeader(String name) {
        List<String> header = this.readHeaders.get(name);
        if (header != null && header.size() > 0) {
            return header.get(0);
        }
        return null;
    }

    @Override
    public List<String> getReadHeaders(String name) {
        List<String> header = this.readHeaders.get(name);
        if (header != null && header.size() > 0) {
            return Collections.unmodifiableList(header);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getReadHeaders() {
        return Collections.unmodifiableMap(this.readHeaders);
    }

    public void setReadHeaders(Map<String, List<String>> headers) {
        this.readHeaders.clear();
        this.readHeaders.putAll(headers);
    }

    @Override
    public String getWriteHeader(String name) {
        List<String> header = this.writeHeaders.get(name);
        if (header != null && header.size() > 0) {
            return header.get(0);
        }
        return null;
    }

    @Override
    public List<String> getWriteHeaders(String name) {
        List<String> header = this.writeHeaders.get(name);
        if (header != null && header.size() > 0) {
            return header;
        }
        return null;
    }

    @Override
    public void setWriteHeader(String name, String value) {
        ArrayList<String> header = new ArrayList<String>();
        this.writeHeaders.put(name, header);
        header.add(value);
    }

    @Override
    public void setWriteHeaders(String name, List<String> value) {
        if (this.commitFuture.isCommitted()) {
            String format = "Attempted to modify http session %d write headers when the session is already committed.";
            throw new IllegalStateException(String.format(format, this.getId()));
        }
        this.writeHeaders.put(name, value);
    }

    @Override
    public void setWriteHeaders(Map<String, List<String>> headers) {
        if (this.commitFuture.isCommitted()) {
            String format = "Attempted to modify http session %d write headers when the session is already committed.";
            throw new IllegalStateException(String.format(format, this.getId()));
        }
        this.writeHeaders.clear();
        this.writeHeaders.putAll(headers);
    }

    @Override
    public void addWriteHeader(String name, String value) {
        if (this.commitFuture.isCommitted()) {
            String format = "Attempted to modify http session %d write header %s when the session is already committed.";
            throw new IllegalStateException(String.format(format, this.getId(), name));
        }
        List<String> header = this.writeHeaders.get(name);
        if (header == null) {
            header = new ArrayList<String>();
            this.writeHeaders.put(name, header);
        }
        header.add(value);
    }

    @Override
    public void clearWriteHeaders(String name) {
        if (this.commitFuture.isCommitted()) {
            String format = "Attempted to clear http session %d write headers when the session is already committed.";
            throw new IllegalStateException(String.format(format, this.getId()));
        }
        this.writeHeaders.remove(name);
    }

    @Override
    public Map<String, List<String>> getWriteHeaders() {
        return this.writeHeaders;
    }

    @Override
    public void setWriteCookies(Set<HttpCookie> cookies) {
        this.writeCookies.clear();
        this.writeCookies.addAll(cookies);
    }

    @Override
    public Collection<HttpCookie> getReadCookies() {
        return Collections.unmodifiableCollection(this.readCookies);
    }

    @Override
    public Set<HttpCookie> getWriteCookies() {
        return this.writeCookies;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public void setRequestURI(URI requestURI) {
        this.requestURI = requestURI;
    }

    @Override
    public String getParameter(String name) {
        List<String> parameter = this.parameters.get(name);
        if (parameter != null && parameter.size() > 0) {
            return parameter.get(0);
        }
        return null;
    }

    @Override
    public List<String> getParameterValues(String name) {
        List<String> parameter = this.parameters.get(name);
        if (parameter != null && parameter.size() > 0) {
            return Collections.unmodifiableList(parameter);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(HttpStatus status) {
        this.status = status;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public URI getServicePath() {
        return this.servicePath;
    }

    @Override
    public URI getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public URI getRequestURL() {
        return this.requestURL;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public final boolean isCommitting() {
        return this.committing.get() || this.commitFuture.isCommitted();
    }

    @Override
    public ResponseFuture getResponseFuture() {
        return this.responseFuture;
    }

    public IoHandler getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    public UpgradeFuture getUpgradeFuture() {
        return this.upgradeFuture;
    }

    @Override
    public UpgradeFuture upgrade(IoHandler handler) {
        this.upgradeHandler = handler;
        return this.upgradeFuture;
    }

    @Override
    public CommitFuture getCommitFuture() {
        return this.commitFuture;
    }

    @Override
    public CommitFuture commit() {
        IoProcessorEx processor;
        if (this.committing.compareAndSet(false, true) && (processor = this.getProcessor()) instanceof HttpAcceptProcessor) {
            HttpAcceptProcessor acceptProcessor = (HttpAcceptProcessor)processor;
            acceptProcessor.commit(this);
        }
        return this.commitFuture;
    }

    @Override
    public void shutdownWrite() {
        this.shutdownWrite.set(true);
    }

    public boolean isWriteShutdown() {
        return this.shutdownWrite.get();
    }

    public ResourceAddress getLocalAddress() {
        return this.redirectlocalAddress != null ? this.redirectlocalAddress : super.getLocalAddress();
    }

    public ResourceAddress getRemoteAddress() {
        return this.redirectRemoteAddress != null ? this.redirectRemoteAddress : super.getRemoteAddress();
    }

    public Queue<IoBufferEx> getDeferredReads() {
        return this.deferredReads;
    }

    public void addDeferredRead(IoBufferEx buffer) {
        this.deferredReads.add(buffer);
    }

    public boolean isConnectionClose() {
        return this.connectionClose.get();
    }

    boolean setConnectionClose() {
        return this.connectionClose.compareAndSet(false, true);
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public void setChunked(boolean isChunked) {
        this.isChunked = isChunked;
    }

    public boolean isGzipped() {
        return this.isGzipped;
    }

    public void setGzipped(boolean isGzipped) {
        this.isGzipped = isGzipped;
    }

    @Override
    public ResultAwareLoginContext getLoginContext() {
        return this.loginContext;
    }

    public void setLoginContext(ResultAwareLoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public boolean isChunkingNecessary() {
        ResourceAddress address = this.getLocalAddress().getTransport();
        return address != null && !"httpxe/1.1".equals(address.getOption(ResourceAddress.NEXT_PROTOCOL)) && !HttpProtocolCompatibilityFilter.HttpConditionalWrappedResponseFilter.conditionallyWrappedResponsesRequired((IoSessionEx)this);
    }

    public boolean isHttpxeSpecCompliant() {
        return this.httpxeSpecCompliant;
    }

    public IoSessionEx setParent(IoSessionEx newParent) {
        this.setLocalAddress((ResourceAddress)LOCAL_ADDRESS.get((IoSession)newParent));
        this.upgradeFuture.setSession((IoSession)newParent);
        if (!SslUtils.isSecure((IoSession)newParent) && this.secure) {
            throw new InvalidParameterException("Can not switch from a secure session to a non secure session");
        }
        return super.setParent(newParent);
    }

    int getAndDecrementRedirectsAllowed() {
        int result;
        if ((result = this.redirectsAllowed--) > 0) {
            // empty if block
        }
        return result;
    }

    public void setLocalAddress(ResourceAddress redirectlocalAddress) {
        this.redirectlocalAddress = redirectlocalAddress;
    }

    public void setRemoteAddress(ResourceAddress redirectRemoteAddress) {
        this.redirectRemoteAddress = redirectRemoteAddress;
    }
}

