/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import org.apache.mina.core.filterchain.IoFilter;
import org.kaazing.gateway.transport.http.HttpAcceptor;
import org.kaazing.gateway.transport.http.bridge.filter.HttpCodecFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpContentLengthAdjustmentFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpContentMessageInjectionFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpHostHeaderFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpMergeRequestFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpNextProtocolHeaderFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpOperationFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpOriginHeaderFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpOriginSecurityFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpPathMatchingFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpPersistenceFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpProtocolCompatibilityFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpProtocolFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpSessionCleanupFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpxeProtocolFilter;
import org.slf4j.LoggerFactory;

public enum HttpAcceptFilter {
    CONTENT_LENGTH_ADJUSTMENT("http#content-length", (IoFilter)new HttpContentLengthAdjustmentFilter()),
    ELEVATE_EMULATED_REQUEST("http#elevateEmulatedRequest"),
    CODEC("http#codec", (IoFilter)new HttpCodecFilter(false)),
    HTTP_SERIALIZE_REQUEST_FILTER("http#serializeRequests"),
    MERGE_REQUEST("http#merge-request", (IoFilter)new HttpMergeRequestFilter(LoggerFactory.getLogger((String)HttpAcceptor.MERGE_REQUEST_LOGGER_NAME))),
    NEXT_PROTOCOL_HEADER("http#next-protocol", (IoFilter)new HttpNextProtocolHeaderFilter()),
    ORIGIN_HEADER("http#origin", (IoFilter)new HttpOriginHeaderFilter()),
    HOST_HEADER("http#host", (IoFilter)new HttpHostHeaderFilter()),
    PROTOCOL_COMPATIBILITY("http#protocol-compatibility", (IoFilter)new HttpProtocolCompatibilityFilter()),
    CONDITIONAL_WRAPPED_RESPONSE("http#conditionalWrappedResponse", (IoFilter)new HttpProtocolCompatibilityFilter.HttpConditionalWrappedResponseFilter()),
    PROTOCOL_HTTPXE("http#protocol[httpxe/1.1]", (IoFilter)new HttpxeProtocolFilter(false)),
    CONTENT_MESSAGE_INJECTION("http#contentMessageInjection", (IoFilter)new HttpContentMessageInjectionFilter()),
    PROTOCOL_HTTP("http#protocol[http/1.1]", (IoFilter)new HttpProtocolFilter()),
    SESSION_CLEANUP("http#session-cleanup", (IoFilter)new HttpSessionCleanupFilter()),
    NEXT_ADDRESS("http#next-address"),
    PATH_MATCHING("http#path-matching", (IoFilter)new HttpPathMatchingFilter()),
    PERSISTENCE("http#persistence", (IoFilter)new HttpPersistenceFilter()),
    OPERATION("http#operation", (IoFilter)new HttpOperationFilter()),
    ORIGIN_SECURITY("http#origin-security", (IoFilter)new HttpOriginSecurityFilter()),
    SUBJECT_SECURITY("http#subject-security");

    private final String filterName;
    private final IoFilter filter;

    private HttpAcceptFilter(String filterName) {
        this(filterName, null);
    }

    private HttpAcceptFilter(String filterName, IoFilter filter) {
        this.filterName = filterName;
        this.filter = filter;
    }

    public String filterName() {
        return this.filterName;
    }

    public IoFilter filter() {
        if (this.filter == null) {
            throw new IllegalStateException(String.format("%s acceptor filter is not shared", this.filterName));
        }
        return this.filter;
    }
}

