/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.util.Queue;
import java.util.Set;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.BridgeAcceptHandler;
import org.kaazing.gateway.transport.BridgeAcceptProcessor;
import org.kaazing.gateway.transport.CommitFuture;
import org.kaazing.gateway.transport.IoSessionAdapterEx;
import org.kaazing.gateway.transport.ObjectLoggingFilter;
import org.kaazing.gateway.transport.UpgradeFuture;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.HttpAcceptor;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBuffer;
import org.kaazing.gateway.transport.http.bridge.filter.HttpCodecFilter;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAcceptProcessor
extends BridgeAcceptProcessor<DefaultHttpSession> {
    private static final IoFutureListener<CommitFuture> WRITE_RESUMER = new WriteResumer();
    private static final IoFutureListener<CommitFuture> UPGRADER = new Upgrader();

    protected void add0(DefaultHttpSession session) {
        super.add0((AbstractBridgeSession)session);
        CommitFuture commitFuture = session.getCommitFuture();
        commitFuture.addListener(UPGRADER);
    }

    protected void removeInternal(final DefaultHttpSession session) {
        CommitFuture future = session.commit();
        if (future.isCommitted()) {
            this.removeInternal0(session);
        } else {
            future.addListener((IoFutureListener)new IoFutureListener<CommitFuture>(){

                public void operationComplete(CommitFuture future) {
                    if (future.isCommitted()) {
                        HttpAcceptProcessor.this.removeInternal0(session);
                    }
                }
            });
        }
    }

    private void removeInternal0(DefaultHttpSession session) {
        IoSessionEx parent = session.getParent();
        if (parent == null || parent.isClosing()) {
            return;
        }
        boolean connectionClose = session.isConnectionClose();
        if (connectionClose) {
            parent.close(false);
        } else {
            IoBufferAllocatorEx allocator = session.getBufferAllocator();
            HttpBuffer unsharedEmpty = (HttpBuffer)allocator.wrap(allocator.allocate(0));
            HttpContentMessage completeMessage = new HttpContentMessage((IoBufferEx)unsharedEmpty, true, session.isChunked(), session.isGzipped());
            parent.write((Object)completeMessage);
        }
    }

    public void commit(DefaultHttpSession session) {
        IoSessionEx parent = session.getParent();
        if (parent == null || parent.isClosing()) {
            return;
        }
        CommitFuture commitFuture = session.getCommitFuture();
        if (commitFuture.isCommitted()) {
            return;
        }
        HttpResponseMessage httpResponse = new HttpResponseMessage();
        httpResponse.setStatus(session.getStatus());
        httpResponse.setReason(session.getReason());
        httpResponse.setVersion(session.getVersion());
        httpResponse.setHeaders(session.getWriteHeaders());
        httpResponse.setInjectableHeaders((Set)session.getLocalAddress().getOption(HttpResourceAddress.INJECTABLE_HEADERS));
        httpResponse.setCookies(session.getWriteCookies());
        httpResponse.setBlockPadding(session.getParameter(".kbp") != null);
        boolean complete = session.getCurrentWriteRequest() == null && session.getWriteRequestQueue().isEmpty((IoSession)session) && session.isClosing();
        IoBufferAllocatorEx allocator = session.getBufferAllocator();
        HttpBuffer unsharedEmpty = (HttpBuffer)allocator.wrap(allocator.allocate(0));
        httpResponse.setContent(new HttpContentMessage((IoBufferEx)unsharedEmpty, complete));
        if (session.getMethod() == HttpMethod.HEAD) {
            httpResponse.setContentExcluded(true);
        }
        switch (session.getVersion()) {
            case HTTP_1_1: {
                String contentLength;
                boolean isConnectionClose = "close".equals(session.getWriteHeader("Connection"));
                if (isConnectionClose) {
                    this.writeNonPersistentResponse(session, (IoSession)parent, commitFuture, httpResponse);
                    break;
                }
                if (!httpResponse.isComplete() && (contentLength = session.getWriteHeader("Content-Length")) == null) {
                    if (session.isClosing() || session.isWriteShutdown()) {
                        long scheduledWriteBytes = session.getScheduledWriteBytes();
                        httpResponse.setHeader("Content-Length", String.valueOf(scheduledWriteBytes));
                    } else if (!httpResponse.isContentLengthImplicit() && session.isChunkingNecessary()) {
                        httpResponse.setHeader("Transfer-Encoding", "chunked");
                        session.setChunked(true);
                    }
                }
                this.writePersistentResponse((IoSession)parent, commitFuture, httpResponse);
                break;
            }
            case HTTP_1_0: {
                this.writeNonPersistentResponse(session, (IoSession)parent, commitFuture, httpResponse);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected HTTP version: " + (Object)((Object)session.getVersion()));
            }
        }
    }

    private void writePersistentResponse(IoSession parent, final CommitFuture commitFuture, HttpResponseMessage httpResponse) {
        WriteFuture writeFuture = parent.write((Object)httpResponse);
        writeFuture.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

            public void operationComplete(WriteFuture future) {
                commitFuture.setCommited();
            }
        });
    }

    private void writeNonPersistentResponse(final DefaultHttpSession session, final IoSession parent, final CommitFuture commitFuture, final HttpResponseMessage httpResponse) {
        WriteFuture writeFuture = parent.write((Object)httpResponse);
        writeFuture.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

            public void operationComplete(WriteFuture future) {
                try {
                    IoFilterChain filterChain = parent.getFilterChain();
                    IoFilterChain.Entry codec = filterChain.getEntry(HttpCodecFilter.class);
                    IoFilterChain.Entry logging = filterChain.getEntry(ObjectLoggingFilter.class);
                    filterChain.clear();
                    boolean isChunked = HttpUtils.isChunked(httpResponse);
                    boolean isGzipped = HttpUtils.isGzipped(httpResponse);
                    if (isChunked || isGzipped) {
                        session.setChunked(isChunked);
                        session.setGzipped(isGzipped);
                        filterChain.addLast(codec.getName(), codec.getFilter());
                    }
                    if (logging != null) {
                        filterChain.addLast(logging.getName(), logging.getFilter());
                    }
                }
                catch (Exception e) {
                    parent.getFilterChain().fireExceptionCaught((Throwable)e);
                }
                session.setConnectionClose();
                commitFuture.setCommited();
            }
        });
    }

    protected void consume(DefaultHttpSession session) {
        IoBufferEx buffer;
        if (session.isReadSuspended()) {
            return;
        }
        Queue<IoBufferEx> deferredReads = session.getDeferredReads();
        while ((buffer = deferredReads.poll()) != null) {
            if (!buffer.hasRemaining()) continue;
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.fireMessageReceived((Object)buffer);
        }
    }

    protected WriteFuture flushNow(DefaultHttpSession session, IoSessionEx parent, IoBufferEx buf, IoFilterChain filterChain, WriteRequest request) {
        CommitFuture commitFuture = session.commit();
        if (!commitFuture.isCommitted()) {
            session.suspendWrite();
            commitFuture.addListener(WRITE_RESUMER);
            return null;
        }
        boolean isGzipped = session.isGzipped();
        boolean isChunked = session.isChunked();
        if (session.isConnectionClose() && !isChunked && !isGzipped) {
            return super.flushNow((AbstractBridgeSession)session, parent, buf, filterChain, request);
        }
        if (buf instanceof HttpBuffer) {
            HttpBuffer httpBuffer = (HttpBuffer)buf;
            String key = HttpBuffer.getEncodingKey(isGzipped, isChunked);
            HttpMessage httpMessage = httpBuffer.getMessage(key);
            if (httpMessage == null) {
                HttpContentMessage newHttpMessage = new HttpContentMessage(buf, false, isChunked, isGzipped);
                if (httpBuffer.isAutoCache()) {
                    newHttpMessage.initCache();
                }
                httpMessage = httpBuffer.putMessage(key, newHttpMessage);
            }
            return HttpAcceptProcessor.flushNowInternal((IoSessionEx)parent, (Object)((Object)httpMessage), (IoBufferEx)httpBuffer, (IoFilterChain)filterChain, (WriteRequest)request);
        }
        return HttpAcceptProcessor.flushNowInternal((IoSessionEx)parent, (Object)((Object)new HttpContentMessage(buf, false, isChunked, isGzipped)), (IoBufferEx)buf, (IoFilterChain)filterChain, (WriteRequest)request);
    }

    public static void setServerHeader(IoSession session, HttpResponseMessage response) {
        DefaultHttpSession httpSession = (DefaultHttpSession)HttpAcceptor.SESSION_KEY.get(session);
        HttpAcceptProcessor.setServerHeader(httpSession, response);
    }

    public static void setServerHeader(DefaultHttpSession httpSession, HttpResponseMessage httpResponse) {
        ResourceAddress address;
        boolean serverHeaderEnabled;
        if (httpSession != null && (serverHeaderEnabled = ((Boolean)(address = httpSession.getLocalAddress()).getOption((ResourceOption)HttpResourceAddress.SERVER_HEADER_ENABLED)).booleanValue()) && !httpResponse.hasHeader("Server")) {
            httpResponse.setHeader("Server", "Kaazing Gateway");
        }
    }

    private static final class Upgrader
    implements IoFutureListener<CommitFuture> {
        private final Logger logger = LoggerFactory.getLogger((String)"transport.http");

        private Upgrader() {
        }

        public void operationComplete(CommitFuture future) {
            final DefaultHttpSession session = (DefaultHttpSession)future.getSession();
            if (session.getStatus() == HttpStatus.INFO_SWITCHING_PROTOCOLS) {
                CloseFuture closeFuture = session.getCloseFuture();
                closeFuture.addListener((IoFutureListener)new IoFutureListener<CloseFuture>(){

                    public void operationComplete(CloseFuture future) {
                        IoSessionEx parent = session.getParent();
                        if (parent == null || parent.isClosing()) {
                            return;
                        }
                        UpgradeFuture upgradeFuture = session.getUpgradeFuture();
                        IoHandler upgradeHandler = session.getUpgradeHandler();
                        if (upgradeHandler != null) {
                            IoHandler oldHandler;
                            if (parent instanceof AbstractBridgeSession) {
                                AbstractBridgeSession bridgeParent = (AbstractBridgeSession)parent;
                                oldHandler = bridgeParent.getHandler();
                                bridgeParent.setHandler(upgradeHandler);
                            } else if (parent instanceof IoSessionAdapterEx) {
                                oldHandler = parent.getHandler();
                                ((IoSessionAdapterEx)parent).setHandler(upgradeHandler);
                            } else {
                                oldHandler = (IoHandler)parent.setAttribute((Object)BridgeAcceptHandler.DELEGATE_KEY, (Object)upgradeHandler);
                            }
                            try {
                                oldHandler.sessionClosed((IoSession)parent);
                                upgradeFuture.setUpgraded();
                                upgradeHandler.sessionOpened((IoSession)parent);
                            }
                            catch (Exception e) {
                                logger.error("Exception during upgrade", (Throwable)e);
                                parent.close(true);
                            }
                        }
                    }
                });
            }
        }
    }

    private static final class WriteResumer
    implements IoFutureListener<CommitFuture> {
        private WriteResumer() {
        }

        public void operationComplete(CommitFuture future) {
            IoSession session = future.getSession();
            session.resumeWrite();
        }
    }
}

