/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.security.auth.Subject;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.Protocol;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.security.auth.context.ResultAwareLoginContext;
import org.kaazing.gateway.server.ExpiringState;
import org.kaazing.gateway.transport.AbstractBridgeAcceptor;
import org.kaazing.gateway.transport.Bindings;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeServiceFactory;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.BridgeSessionInitializer;
import org.kaazing.gateway.transport.DefaultIoSessionConfigEx;
import org.kaazing.gateway.transport.DefaultTransportMetadata;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.HttpAcceptFilter;
import org.kaazing.gateway.transport.http.HttpAcceptProcessor;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpBindings;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBuffer;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBufferAllocator;
import org.kaazing.gateway.transport.http.bridge.filter.HttpNextAddressFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpProtocolDecoderException;
import org.kaazing.gateway.transport.http.bridge.filter.HttpSerializeRequestsFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpSubjectSecurityFilter;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResource;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResourceFactory;
import org.kaazing.gateway.util.InternalSystemProperty;
import org.kaazing.gateway.util.LoggingUtils;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAcceptor
extends AbstractBridgeAcceptor<DefaultHttpSession, HttpBindings.HttpBinding> {
    private static final String LOGGER_NAME = String.format("transport.%s.accept", "http");
    public static final String SECURITY_LOGGER_NAME = String.format("%s.security", LOGGER_NAME);
    public static final String MERGE_REQUEST_LOGGER_NAME = String.format("%s.mergeRequest", LOGGER_NAME);
    public static final AttributeKey SERVICE_REGISTRATION_KEY = new AttributeKey(HttpAcceptor.class, "serviceRegistration");
    public static final TypedAttributeKey<Boolean> HTTPXE_SPEC_KEY = new TypedAttributeKey(HttpAcceptor.class, "httpxeSpec");
    static final TypedAttributeKey<DefaultHttpSession> SESSION_KEY = new TypedAttributeKey(HttpAcceptor.class, "session");
    public static final AttributeKey BALANCEES_KEY = new AttributeKey(HttpAcceptor.class, "balancees");
    private final Map<String, Set<HttpAcceptFilter>> acceptFiltersByProtocol;
    private final Set<HttpAcceptFilter> allAcceptFilters;
    private BridgeServiceFactory bridgeServiceFactory;
    private ResourceAddressFactory addressFactory;
    private IoFilter httpNextAddress;
    private SchedulerProvider schedulerProvider;
    private ExpiringState expiringState;
    private Properties configuration;
    private boolean httpxeSpecCompliant;
    private final IoHandler httpResourcesHandler = new IoHandlerAdapter<HttpAcceptSession>(){
        private final HttpDynamicResourceFactory dynamicResourceFactory = HttpDynamicResourceFactory.newHttpDynamicResourceFactory();

        protected void doSessionOpened(HttpAcceptSession session) throws Exception {
            URI pathInfo = session.getPathInfo();
            String path = pathInfo.getPath();
            String resourceName = path != null && path.length() > 0 ? path.substring(1) : "";
            Collection<String> resourceNames = this.dynamicResourceFactory.getResourceNames();
            if (!resourceNames.contains(resourceName)) {
                session.setStatus(HttpStatus.CLIENT_NOT_FOUND);
                session.close(false);
            } else {
                HttpDynamicResource dynamicResource = this.dynamicResourceFactory.newHttpDynamicResource(resourceName);
                dynamicResource.writeFile(session);
                session.close(false);
            }
        }
    };
    private final IoHandler bridgeHandler = new IoHandlerAdapter<IoSessionEx>(){

        protected void doSessionOpened(IoSessionEx session) throws Exception {
        }

        protected void doSessionCreated(IoSessionEx session) throws Exception {
            HTTPXE_SPEC_KEY.set((IoSession)session, (Object)HttpAcceptor.this.httpxeSpecCompliant);
            IoFilterChain filterChain = session.getFilterChain();
            HttpAcceptor.this.addBridgeFilters(filterChain);
        }

        protected void doSessionIdle(IoSessionEx session, IdleStatus status) throws Exception {
            DefaultHttpSession httpSession = (DefaultHttpSession)SESSION_KEY.get((IoSession)session);
            if (httpSession != null) {
                IoFilterChain filterChain = httpSession.getFilterChain();
                filterChain.fireSessionIdle(status);
            }
        }

        protected void doSessionClosed(IoSessionEx session) throws Exception {
            DefaultHttpSession httpSession;
            if (!session.isClosing()) {
                IoFilterChain filterChain = session.getFilterChain();
                HttpAcceptor.this.removeBridgeFilters(filterChain);
            }
            if ((httpSession = (DefaultHttpSession)SESSION_KEY.remove((IoSession)session)) != null && !httpSession.isClosing()) {
                httpSession.reset(new IOException("Early termination of IO session").fillInStackTrace());
            }
        }

        protected void doExceptionCaught(IoSessionEx session, Throwable cause) throws Exception {
            DefaultHttpSession httpSession = (DefaultHttpSession)SESSION_KEY.get((IoSession)session);
            if (httpSession != null && !httpSession.isClosing()) {
                if (!(session.isClosing() || cause instanceof IOException || httpSession.getCommitFuture().isCommitted())) {
                    HttpResponseMessage httpResponse = new HttpResponseMessage();
                    httpResponse.setVersion(HttpVersion.HTTP_1_1);
                    httpResponse.setStatus(HttpStatus.SERVER_INTERNAL_ERROR);
                    HttpAcceptProcessor.setServerHeader(httpSession, httpResponse);
                    httpResponse.setHeader("Date", HttpUtils.formatDateHeader(System.currentTimeMillis()));
                    session.write((Object)httpResponse);
                    session.close(false);
                    String message = String.format("Unexpected HTTP exception: %s", cause);
                    LoggingUtils.log((Logger)HttpAcceptor.this.logger, (String)message, (Throwable)cause);
                }
                session.close(true);
            } else {
                if (HttpAcceptor.this.logger.isDebugEnabled()) {
                    String message = String.format("Error on HTTP connection, closing connection: %s", cause);
                    LoggingUtils.log((Logger)HttpAcceptor.this.logger, (String)message, (Throwable)cause);
                }
                if (!session.isClosing() && cause instanceof HttpProtocolDecoderException) {
                    HttpResponseMessage httpResponse = new HttpResponseMessage();
                    httpResponse.setVersion(HttpVersion.HTTP_1_1);
                    httpResponse.setStatus(((HttpProtocolDecoderException)((Object)cause)).getHttpStatus());
                    HttpAcceptProcessor.setServerHeader(httpSession, httpResponse);
                    httpResponse.setHeader("Date", HttpUtils.formatDateHeader(System.currentTimeMillis()));
                    session.write((Object)httpResponse);
                }
                session.close(false);
            }
        }

        protected void doMessageReceived(final IoSessionEx session, Object message) throws Exception {
            HttpMessage httpMessage = (HttpMessage)((Object)message);
            switch (httpMessage.getKind()) {
                case REQUEST: {
                    ResourceAddress localAddress;
                    final HttpRequestMessage httpRequest = (HttpRequestMessage)((Object)message);
                    URI requestURI = httpRequest.getRequestURI();
                    if (HttpAcceptor.this.logger.isInfoEnabled()) {
                        String host = httpRequest.getHeader("Host");
                        String userAgent = httpRequest.getHeader("User-Agent");
                        if (userAgent == null) {
                            userAgent = "-";
                        }
                        HttpAcceptor.this.logger.info(String.format("%s - [%s] \"%s %s %s \" \"%s\"", new Object[]{session.getRemoteAddress(), host, httpRequest.getMethod(), requestURI.toString(), httpRequest.getVersion(), userAgent}));
                    }
                    if ((localAddress = httpRequest.getLocalAddress()) == null && HttpAcceptor.this.logger.isDebugEnabled()) {
                        HttpAcceptor.this.logger.debug(String.format("Failed to find a binding local address for request URI %s", requestURI));
                    }
                    assert (localAddress != null);
                    ResourceAddress transportAddress = (ResourceAddress)BridgeSession.REMOTE_ADDRESS.get((IoSession)session);
                    ResourceOptions options = ResourceOptions.FACTORY.newResourceOptions();
                    options.setOption(ResourceAddress.TRANSPORT, (Object)transportAddress);
                    options.setOption(ResourceAddress.NEXT_PROTOCOL, localAddress.getOption(ResourceAddress.NEXT_PROTOCOL));
                    final ResourceAddress remoteAddress = HttpAcceptor.this.addressFactory.newResourceAddress(httpRequest.getExternalURI(), options);
                    final Subject subject = httpRequest.getSubject();
                    final ResultAwareLoginContext loginContext = httpRequest.getLoginContext();
                    DefaultHttpSession httpSession = (DefaultHttpSession)HttpAcceptor.this.newSession((IoSessionInitializer)new IoSessionInitializer<IoFuture>(){

                        public void initializeSession(IoSession httpSession, IoFuture future) {
                            ((DefaultHttpSession)httpSession).setSubject(subject);
                            ((DefaultHttpSession)httpSession).setLoginContext(loginContext);
                        }
                    }, new Callable<DefaultHttpSession>(){

                        @Override
                        public DefaultHttpSession call() {
                            IoBufferAllocatorEx parentAllocator = session.getBufferAllocator();
                            DefaultHttpSession newHttpSession = new DefaultHttpSession((IoServiceEx)HttpAcceptor.this, (IoProcessorEx<DefaultHttpSession>)HttpAcceptor.this.getProcessor(), localAddress, remoteAddress, session, (IoBufferAllocatorEx<HttpBuffer>)new HttpBufferAllocator(parentAllocator), httpRequest, localAddress.getResource(), HttpAcceptor.this.configuration);
                            IoHandler handler = HttpAcceptor.this.getHandler(newHttpSession.getLocalAddress());
                            if (handler == null && HttpAcceptor.this.logger.isTraceEnabled()) {
                                HttpAcceptor.this.logger.warn("Unable to find handler for new HTTP session with local address:\n{}\nbindings:\n{}\n", (Object)newHttpSession.getLocalAddress(), (Object)HttpAcceptor.this.bindings);
                            }
                            newHttpSession.setHandler(handler);
                            SESSION_KEY.set((IoSession)session, (Object)newHttpSession);
                            return newHttpSession;
                        }
                    });
                    HttpContentMessage httpContent = httpRequest.getContent();
                    if (httpContent == null) {
                        IoBufferAllocatorEx allocator = httpSession.getBufferAllocator();
                        httpContent = new HttpContentMessage(allocator.wrap(allocator.allocate(0)), true);
                    }
                    this.fireContentReceived(httpSession, httpContent);
                    break;
                }
                case CONTENT: {
                    DefaultHttpSession httpSession = (DefaultHttpSession)SESSION_KEY.get((IoSession)session);
                    if (httpSession != null) {
                        this.fireContentReceived(httpSession, (HttpContentMessage)((Object)message));
                        break;
                    }
                    throw new Exception("HttpSession not available for HttpContent");
                }
                default: {
                    throw new IllegalStateException("Unexpected message kind: " + (Object)((Object)httpMessage.getKind()));
                }
            }
        }

        protected void doMessageSent(IoSessionEx session, Object message) throws Exception {
            DefaultHttpSession httpSession;
            if (message == IoSessionEx.REGISTERED_EVENT && (httpSession = (DefaultHttpSession)SESSION_KEY.get((IoSession)session)) != null) {
                HttpAcceptProcessor processor = (HttpAcceptProcessor)httpSession.getProcessor();
                processor.consume(httpSession);
            }
        }

        private void fireContentReceived(DefaultHttpSession session, HttpContentMessage content) throws Exception {
            IoBufferEx buffer = content.asBuffer();
            if (buffer != null && buffer.hasRemaining()) {
                if (!session.isIoRegistered() || session.isReadSuspended()) {
                    session.addDeferredRead(buffer);
                } else {
                    IoFilterChain filterChain = session.getFilterChain();
                    filterChain.fireMessageReceived((Object)buffer);
                }
            }
        }
    };

    @Resource(name="schedulerProvider")
    public void setSchedulerProvider(SchedulerProvider provider) {
        this.schedulerProvider = provider;
    }

    @Resource(name="expiringState")
    public void setExpiringState(ExpiringState expiringState) {
        this.expiringState = expiringState;
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
        this.httpxeSpecCompliant = InternalSystemProperty.HTTPXE_SPECIFICATION.getBooleanProperty(configuration);
    }

    public HttpAcceptor() {
        super((IoSessionConfigEx)new DefaultIoSessionConfigEx());
        HashMap<String, EnumSet<Object>> acceptFiltersByProtocol = new HashMap<String, EnumSet<Object>>();
        acceptFiltersByProtocol.put("http/1.1", EnumSet.complementOf(EnumSet.of(HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT, HttpAcceptFilter.PROTOCOL_HTTPXE, HttpAcceptFilter.ELEVATE_EMULATED_REQUEST, HttpAcceptFilter.CONDITIONAL_WRAPPED_RESPONSE)));
        acceptFiltersByProtocol.put("httpxe/1.1", EnumSet.complementOf(EnumSet.of(HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT, new HttpAcceptFilter[]{HttpAcceptFilter.MERGE_REQUEST, HttpAcceptFilter.HTTP_SERIALIZE_REQUEST_FILTER, HttpAcceptFilter.PROTOCOL_HTTP, HttpAcceptFilter.HOST_HEADER, HttpAcceptFilter.ELEVATE_EMULATED_REQUEST, HttpAcceptFilter.CONDITIONAL_WRAPPED_RESPONSE})));
        acceptFiltersByProtocol.put("x-kaazing-handshake", EnumSet.complementOf(EnumSet.of(HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT, HttpAcceptFilter.PROTOCOL_HTTPXE, HttpAcceptFilter.HOST_HEADER, HttpAcceptFilter.ELEVATE_EMULATED_REQUEST, HttpAcceptFilter.CONDITIONAL_WRAPPED_RESPONSE)));
        this.acceptFiltersByProtocol = Collections.unmodifiableMap(acceptFiltersByProtocol);
        this.allAcceptFilters = EnumSet.allOf(HttpAcceptFilter.class);
    }

    protected Bindings<HttpBindings.HttpBinding> initBindings() {
        return new HttpBindings(){

            @Override
            protected HttpBindings.HttpBinding bindAdditionalAddressesIfNecessary(HttpBindings.HttpBinding newHttpBinding) {
                HttpBindings.HttpBinding httpBinding = (HttpBindings.HttpBinding)this.addBinding0(newHttpBinding);
                if (httpBinding == null) {
                    ResourceAddress resourcesAddress = this.getResourcesAddress(newHttpBinding);
                    HttpAcceptor.this.bind(resourcesAddress, HttpAcceptor.this.httpResourcesHandler, null);
                }
                return httpBinding;
            }

            @Override
            protected boolean unbindAdditionalAddressesIfNecessary(ResourceAddress address, HttpBindings.HttpBinding newHttpBinding) {
                ResourceAddress resourcesAddress = this.getResourcesAddress(newHttpBinding);
                if (newHttpBinding.size() == 1 && newHttpBinding.get(resourcesAddress.getResource().getPath()) != null) {
                    HttpAcceptor.this.unbind(resourcesAddress);
                    return true;
                }
                return false;
            }

            private ResourceAddress getResourcesAddress(HttpBindings.HttpBinding newHttpBinding) {
                ResourceAddress bindAddress = newHttpBinding.bindAddress();
                String location = bindAddress.getExternalURI();
                String resourcesURI = URIUtils.resolve((String)location, (String)"/;resource");
                ResourceOptions options = ResourceOptions.FACTORY.newResourceOptions();
                options.setOption(ResourceAddress.TRANSPORT_URI, bindAddress.getOption(ResourceAddress.TRANSPORT_URI));
                options.setOption(ResourceAddress.TRANSPORT, bindAddress.getOption(ResourceAddress.TRANSPORT));
                options.setOption(HttpResourceAddress.TEMP_DIRECTORY, bindAddress.getOption(HttpResourceAddress.TEMP_DIRECTORY));
                options.setOption(ResourceAddress.NEXT_PROTOCOL, bindAddress.getOption(ResourceAddress.NEXT_PROTOCOL));
                options.setOption(HttpResourceAddress.ORIGIN_SECURITY, bindAddress.getOption(HttpResourceAddress.ORIGIN_SECURITY));
                options.setOption(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY, bindAddress.getOption(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY));
                options.setOption(HttpResourceAddress.BALANCE_ORIGINS, bindAddress.getOption(HttpResourceAddress.BALANCE_ORIGINS));
                return HttpAcceptor.this.addressFactory.newResourceAddress(resourcesURI, options);
            }
        };
    }

    @Resource(name="bridgeServiceFactory")
    public void setBridgeServiceFactory(BridgeServiceFactory bridgeServiceFactory) {
        this.bridgeServiceFactory = bridgeServiceFactory;
    }

    @Resource(name="resourceAddressFactory")
    public void setResourceAddressFactory(ResourceAddressFactory resourceAddressFactory) {
        this.addressFactory = resourceAddressFactory;
    }

    public void init() {
        super.init();
        HttpNextAddressFilter httpNextAddress = new HttpNextAddressFilter();
        httpNextAddress.setResourceAddressFactory(this.addressFactory);
        httpNextAddress.setBindings((Bindings<HttpBindings.HttpBinding>)this.bindings);
        this.httpNextAddress = httpNextAddress;
    }

    public TransportMetadata getTransportMetadata() {
        return new DefaultTransportMetadata("http");
    }

    protected IoProcessorEx<DefaultHttpSession> initProcessor() {
        return new HttpAcceptProcessor();
    }

    protected boolean canBind(String transportName) {
        return transportName.equals("http");
    }

    protected <T extends IoFuture> void bindInternal(ResourceAddress address, IoHandler handler, BridgeSessionInitializer<T> initializer) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("binding: '%s' %s", address.getExternalURI(), address.getOption(ResourceAddress.NEXT_PROTOCOL)));
        }
        ResourceAddress transportAddress = address.getTransport();
        URI transportURI = transportAddress.getResource();
        Protocol transportProtocol = this.bridgeServiceFactory.getTransportFactory().getProtocol(transportURI.getScheme());
        BridgeSessionInitializer sessionInitializer = initializer != null ? initializer.getParentInitializer(transportProtocol) : null;
        BridgeAcceptor acceptor = this.bridgeServiceFactory.newBridgeAcceptor(transportAddress);
        acceptor.bind(transportAddress, this.bridgeHandler, sessionInitializer);
    }

    protected UnbindFuture unbindInternal(ResourceAddress address, IoHandler handler, BridgeSessionInitializer<? extends IoFuture> initializer) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("unbinding: '%s' %s", address.getExternalURI(), address.getOption(ResourceAddress.NEXT_PROTOCOL)));
        }
        ResourceAddress transport = address.getTransport();
        BridgeAcceptor acceptor = this.bridgeServiceFactory.newBridgeAcceptor(transport);
        return acceptor.unbind(transport);
    }

    public void addBridgeFilters(IoFilterChain chain) {
        ResourceAddress address;
        IoSession transport = chain.getSession();
        SocketAddress localAddress = transport.getLocalAddress();
        String nextProtocol = null;
        if (localAddress instanceof ResourceAddress && !(address = (ResourceAddress)localAddress).hasOption(ResourceAddress.QUALIFIER)) {
            nextProtocol = (String)address.getOption(ResourceAddress.NEXT_PROTOCOL);
        }
        if (nextProtocol == null) {
            nextProtocol = "http/1.1";
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Adding http accept bridge filters using nextProtocol: %s", nextProtocol));
        }
        Set<HttpAcceptFilter> acceptFilters = this.acceptFiltersByProtocol.get(nextProtocol);
        assert (acceptFilters != null && !acceptFilters.isEmpty());
        block6: for (HttpAcceptFilter acceptFilter : acceptFilters) {
            switch (acceptFilter) {
                case NEXT_ADDRESS: {
                    chain.addLast(acceptFilter.filterName(), this.httpNextAddress);
                    continue block6;
                }
                case ELEVATE_EMULATED_REQUEST: {
                    continue block6;
                }
                case HTTP_SERIALIZE_REQUEST_FILTER: {
                    chain.addLast(acceptFilter.filterName(), (IoFilter)new HttpSerializeRequestsFilter(this.logger));
                    continue block6;
                }
                case SUBJECT_SECURITY: {
                    HttpSubjectSecurityFilter filter = new HttpSubjectSecurityFilter(LoggerFactory.getLogger((String)SECURITY_LOGGER_NAME), this.expiringState);
                    filter.setSchedulerProvider(this.schedulerProvider);
                    chain.addLast(acceptFilter.filterName(), (IoFilter)filter);
                    continue block6;
                }
            }
            chain.addLast(acceptFilter.filterName(), acceptFilter.filter());
        }
    }

    public void removeBridgeFilters(IoFilterChain filterChain) {
        for (HttpAcceptFilter filter : this.allAcceptFilters) {
            this.removeFilter(filterChain, filter.filterName());
        }
    }
}

