/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.kaazing.gateway.resource.address.Comparators;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.transport.Bindings;

public class HttpBindings
extends Bindings<HttpBinding> {
    private static final Comparator<ResourceAddress> BINDINGS_COMPARATOR = Comparators.compareResourceOriginAndProtocolStack();

    public HttpBindings() {
        super(BINDINGS_COMPARATOR);
    }

    public Bindings.Binding addBinding(Bindings.Binding newBinding) {
        URI location;
        String path;
        Bindings.Binding binding;
        HttpBinding newHttpBinding;
        ResourceAddress bindAddress = newBinding.bindAddress();
        HttpBinding httpBinding = (HttpBinding)this.getBinding0(bindAddress);
        if (httpBinding == null && (httpBinding = this.bindAdditionalAddressesIfNecessary(newHttpBinding = new HttpBinding(bindAddress))) == null) {
            httpBinding = newHttpBinding;
        }
        if ((binding = httpBinding.put(path = (location = bindAddress.getResource()).getPath(), newBinding)) != null) {
            if (this.equivalent(newBinding, binding)) {
                binding.incrementReferenceCount();
                binding = null;
            }
        } else {
            newBinding.incrementReferenceCount();
        }
        return binding;
    }

    protected HttpBinding bindAdditionalAddressesIfNecessary(HttpBinding newHttpBinding) {
        return (HttpBinding)this.addBinding0(newHttpBinding);
    }

    protected boolean unbindAdditionalAddressesIfNecessary(ResourceAddress address, HttpBinding newHttpBinding) {
        return false;
    }

    public Bindings.Binding getBinding(ResourceAddress address) {
        HttpBinding httpBinding = (HttpBinding)super.getBinding0(address);
        if (httpBinding != null) {
            URI location = address.getResource();
            String path = location.getPath();
            return httpBinding.get(path);
        }
        return null;
    }

    public boolean removeBinding(ResourceAddress address, Bindings.Binding oldBinding) {
        URI location;
        String path;
        HttpBinding httpBinding = (HttpBinding)super.getBinding0(address);
        if (httpBinding != null && httpBinding.remove(path = (location = address.getResource()).getPath(), oldBinding)) {
            this.unbindAdditionalAddressesIfNecessary(address, httpBinding);
            if (httpBinding.isEmpty()) {
                return super.removeBinding0(address, (Bindings.Binding)httpBinding);
            }
        }
        return false;
    }

    public String toString() {
        Iterator<Map.Entry<ResourceAddress, HttpBinding>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        while (true) {
            Map.Entry<ResourceAddress, HttpBinding> e = i.next();
            ResourceAddress key = e.getKey();
            HttpBinding value = e.getValue();
            String location = key.getExternalURI();
            String nextProtocol = (String)key.getOption(ResourceAddress.NEXT_PROTOCOL);
            String nextProtocolStr = nextProtocol == null ? "" : " " + nextProtocol;
            sb.append("  ").append('[').append(URIUtils.resolve((String)location, (String)"/")).append(nextProtocolStr).append(']');
            sb.append('=');
            sb.append((Object)value);
            if (!i.hasNext()) {
                return sb.append("\n}").toString();
            }
            sb.append(',').append('\n');
        }
    }

    protected Set<Map.Entry<ResourceAddress, HttpBinding>> entrySet() {
        return super.entrySet();
    }

    public static class HttpBinding
    extends Bindings.Binding {
        private static final Comparator<String> PATH_ASCENDING = new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                String[] segments1 = path1.split("/");
                String[] segments2 = path2.split("/");
                int nSegments = Math.min(segments1.length, segments2.length);
                int comparison = 0;
                for (int i = 0; i < nSegments && comparison == 0; ++i) {
                    comparison = segments1[i].compareTo(segments2[i]);
                }
                if (comparison == 0) {
                    return segments1.length - segments2.length;
                }
                return comparison;
            }
        };
        private final ConcurrentNavigableMap<String, Bindings.Binding> bindingsByPath = new ConcurrentSkipListMap<String, Bindings.Binding>(PATH_ASCENDING);

        public int hashCode() {
            int hashCode = super.hashCode();
            hashCode = hashCode * 31 + this.bindingsByPath.hashCode();
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpBinding)) {
                return false;
            }
            HttpBinding that = (HttpBinding)((Object)o);
            return this.equals(that);
        }

        public String toString() {
            Iterator i = this.bindingsByPath.entrySet().iterator();
            if (!i.hasNext()) {
                return super.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(\n");
            while (true) {
                Map.Entry e = i.next();
                String key = (String)e.getKey();
                Bindings.Binding value = (Bindings.Binding)e.getValue();
                sb.append("    ").append(key);
                sb.append('=');
                sb.append(value);
                if (!i.hasNext()) {
                    return sb.append("\n    #").append(this.referenceCount()).append(")").toString();
                }
                sb.append(';').append('\n');
            }
        }

        protected final boolean equals(HttpBinding that) {
            return super.equals((Bindings.Binding)that) && this.bindingsByPath.equals(that.bindingsByPath);
        }

        HttpBinding(ResourceAddress bindAddress) {
            super(bindAddress);
        }

        boolean isEmpty() {
            return this.bindingsByPath.isEmpty();
        }

        int size() {
            return this.bindingsByPath.size();
        }

        Bindings.Binding get(String path) {
            NavigableSet<String> paths = this.bindingsByPath.navigableKeySet();
            NavigableSet<String> candidatePaths = paths.headSet(path, true);
            Iterator<String> $i = candidatePaths.descendingIterator();
            while ($i.hasNext()) {
                String candidatePath = $i.next();
                if (!path.startsWith(candidatePath)) continue;
                return (Bindings.Binding)this.bindingsByPath.get(candidatePath);
            }
            return null;
        }

        Bindings.Binding put(String path, Bindings.Binding binding) {
            return this.bindingsByPath.putIfAbsent(path, binding);
        }

        boolean remove(String path, Bindings.Binding binding) {
            if (binding == this.bindingsByPath.get(path) && binding != null && binding.decrementReferenceCount() == 0) {
                return this.bindingsByPath.remove(path, binding);
            }
            return false;
        }
    }
}

