/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import org.apache.mina.core.filterchain.IoFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpCodecFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpContentLengthAdjustmentFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpxeProtocolFilter;

public enum HttpConnectFilter {
    CONTENT_LENGTH_ADJUSTMENT("http#content-length", (IoFilter)new HttpContentLengthAdjustmentFilter()),
    CODEC("http#codec", (IoFilter)new HttpCodecFilter(true)),
    PROTOCOL_HTTPXE("http#protocol[httpxe/1.1]", (IoFilter)new HttpxeProtocolFilter(true));

    private final String filterName;
    private final IoFilter filter;

    private HttpConnectFilter(String filterName, IoFilter filter) {
        this.filterName = filterName;
        this.filter = filter;
    }

    public String filterName() {
        return this.filterName;
    }

    public IoFilter filter() {
        if (this.filter == null) {
            throw new IllegalStateException(String.format("%s connector filter is not shared", this.filterName));
        }
        return this.filter;
    }
}

