/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.BridgeConnectHandler;
import org.kaazing.gateway.transport.BridgeConnectProcessor;
import org.kaazing.gateway.transport.IoSessionAdapterEx;
import org.kaazing.gateway.transport.UpgradeFuture;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.PersistentConnectionPool;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBuffer;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.buffer.SimpleBufferAllocator;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;

public class HttpConnectProcessor
extends BridgeConnectProcessor<DefaultHttpSession> {
    public static final IoBufferEx WRITE_COMPLETE = SimpleBufferAllocator.BUFFER_ALLOCATOR.wrap(ByteBuffer.allocate(0));
    private static final String FILTER_PREFIX = "http#";
    private static final String IDLE_FILTER = "http#idle";
    private final PersistentConnectionPool persistentConnectionPool;
    private final HttpConnectIdleFilter idleFilter;

    HttpConnectProcessor(PersistentConnectionPool persistentConnectionPool, Logger logger) {
        this.persistentConnectionPool = persistentConnectionPool;
        this.idleFilter = new HttpConnectIdleFilter(logger);
    }

    protected void finishConnect(DefaultHttpSession session) {
        boolean isChunked = "chunked".equals(session.getWriteHeader("Transfer-Encoding"));
        if (isChunked) {
            session.setChunked(true);
        }
        if (session.getMethod() == HttpMethod.GET || session.getMethod() == HttpMethod.HEAD || "0".equals(session.getWriteHeader("Content-Length")) || isChunked) {
            URI resource = session.getRemoteAddress().getResource();
            HttpRequestMessage httpRequest = new HttpRequestMessage();
            httpRequest.setMethod(session.getMethod());
            httpRequest.setRequestURI(session.getRequestURI());
            httpRequest.setVersion(session.getVersion());
            Map<String, List<String>> parameters = session.getParameters();
            if (!parameters.isEmpty()) {
                httpRequest.setParameters(session.getParameters());
            }
            if (session.getWriteHeader("User-Agent") == null) {
                httpRequest.setHeader("User-Agent", "Kaazing Gateway");
            }
            httpRequest.putHeaders(session.getWriteHeaders());
            httpRequest.setCookies(session.getWriteCookies());
            httpRequest.setHeader("Host", resource.getAuthority());
            if (isChunked) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                HttpBuffer unsharedEmpty = (HttpBuffer)allocator.wrap(allocator.allocate(0));
                HttpContentMessage flush = new HttpContentMessage((IoBufferEx)unsharedEmpty, false);
                httpRequest.setContent(flush);
            }
            session.commit();
            IoSessionEx parent = session.getParent();
            parent.write((Object)httpRequest);
        }
    }

    protected void flushInternal(DefaultHttpSession session) {
        WriteRequest request;
        IoFilterChain filterChain = session.getFilterChain();
        WriteRequestQueue writeRequestQueue = session.getWriteRequestQueue();
        while ((request = writeRequestQueue.poll((IoSession)session)) != null) {
            Object message = request.getMessage();
            if (message instanceof IoBufferEx) {
                IoBufferEx buf = (IoBufferEx)message;
                try {
                    IoSessionEx parent = session.getParent();
                    if (parent.isClosing()) break;
                    int remaining = buf.remaining();
                    if (remaining == 0 && buf != WRITE_COMPLETE) {
                        throw new IllegalStateException("Unexpected empty buffer");
                    }
                    if (session.isCommitting()) {
                        HttpContentMessage content = new HttpContentMessage(buf, buf == WRITE_COMPLETE, session.isChunked(), false);
                        HttpConnectProcessor.flushNowInternal((IoSessionEx)parent, (Object)((Object)content), (IoBufferEx)buf, (IoFilterChain)filterChain, (WriteRequest)request);
                    } else {
                        HttpRequestMessage httpRequest = new HttpRequestMessage();
                        httpRequest.setMethod(session.getMethod());
                        httpRequest.setRequestURI(session.getRequestURI());
                        httpRequest.setVersion(session.getVersion());
                        httpRequest.setHeader("User-Agent", "Kaazing Gateway");
                        httpRequest.putHeaders(session.getWriteHeaders());
                        httpRequest.setHeader("Host", session.getRemoteAddress().getResource().getAuthority());
                        httpRequest.setCookies(session.getWriteCookies());
                        HttpContentMessage content = new HttpContentMessage(buf, buf == WRITE_COMPLETE);
                        httpRequest.setContent(content);
                        session.commit();
                        HttpConnectProcessor.flushNowInternal((IoSessionEx)parent, (Object)((Object)httpRequest), (IoBufferEx)buf, (IoFilterChain)filterChain, (WriteRequest)request);
                    }
                    int written = remaining;
                    session.increaseWrittenBytes(written, System.currentTimeMillis());
                }
                catch (Exception e) {
                    request.getFuture().setException((Throwable)e);
                }
                continue;
            }
            throw new IllegalStateException("Don't know how to handle message of type '" + message.getClass().getName() + "'.  Are you missing a protocol encoder?");
        }
    }

    protected void doFireSessionDestroyed(DefaultHttpSession session) {
        if (session.getStatus() != null) {
            super.doFireSessionDestroyed((AbstractBridgeSession)session);
        }
    }

    protected void removeInternal(DefaultHttpSession httpSession) {
        IoHandler upgradeHandler;
        if (httpSession.getStatus() != null) {
            httpSession.getCloseFuture().setClosed();
        }
        if ((upgradeHandler = httpSession.getUpgradeHandler()) == null) {
            this.removeInternal0(httpSession);
        } else {
            UpgradeFuture upgradeFuture = httpSession.getUpgradeFuture();
            IoSessionEx parent = httpSession.getParent();
            try {
                if (parent instanceof AbstractBridgeSession) {
                    AbstractBridgeSession bridgeSession = (AbstractBridgeSession)parent;
                    IoHandler oldHandler = bridgeSession.getHandler();
                    oldHandler.sessionClosed((IoSession)parent);
                    bridgeSession.setHandler(upgradeHandler);
                } else if (parent instanceof IoSessionAdapterEx) {
                    IoSessionAdapterEx bridgeSession = (IoSessionAdapterEx)parent;
                    IoHandler oldHandler = bridgeSession.getHandler();
                    oldHandler.sessionClosed((IoSession)parent);
                    bridgeSession.setHandler(upgradeHandler);
                } else {
                    IoHandler oldHandler = (IoHandler)parent.getAttribute((Object)BridgeConnectHandler.DELEGATE_KEY);
                    oldHandler.sessionClosed((IoSession)parent);
                    parent.setAttribute((Object)BridgeConnectHandler.DELEGATE_KEY, (Object)upgradeHandler);
                }
                upgradeFuture.setUpgraded();
                upgradeHandler.sessionOpened((IoSession)parent);
            }
            catch (Exception e) {
                throw new RuntimeException("Error during http connector upgrade.", e);
            }
        }
    }

    private void removeInternal0(DefaultHttpSession session) {
        boolean upgrade;
        IoSessionEx parent = session.getParent();
        if (parent == null || parent.isClosing()) {
            return;
        }
        Integer keepAliveTimeout = (Integer)session.getRemoteAddress().getOption(HttpResourceAddress.KEEP_ALIVE_TIMEOUT);
        assert (keepAliveTimeout != null);
        boolean http10 = session.getVersion() == HttpVersion.HTTP_1_0;
        boolean gatewayToClose = HttpUtils.hasCloseHeader(session.getWriteHeaders("Connection"));
        boolean serverToClose = HttpUtils.hasCloseHeader(session.getReadHeaders("Connection"));
        boolean bl = upgrade = session.getStatus() == HttpStatus.INFO_SWITCHING_PROTOCOLS;
        if (http10 || gatewayToClose) {
            super.removeInternal((AbstractBridgeSession)session);
        } else if (serverToClose) {
            parent.getConfig().setBothIdleTime(keepAliveTimeout.intValue());
            parent.getFilterChain().addLast(IDLE_FILTER, (IoFilter)this.idleFilter);
        } else if (!upgrade) {
            if ("chunked".equals(session.getWriteHeader("Transfer-Encoding"))) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                HttpBuffer unsharedEmpty = (HttpBuffer)allocator.wrap(allocator.allocate(0));
                HttpContentMessage completeMessage = new HttpContentMessage((IoBufferEx)unsharedEmpty, true, session.isChunked(), session.isGzipped());
                parent.write((Object)completeMessage);
            }
            session.getCloseFuture().addListener((IoFutureListener)new IoFutureListener<CloseFuture>((IoSession)parent, session){
                final /* synthetic */ IoSession val$parent;
                final /* synthetic */ DefaultHttpSession val$session;
                {
                    this.val$parent = ioSession;
                    this.val$session = defaultHttpSession;
                }

                public void operationComplete(CloseFuture future) {
                    IoFilterChain filterChain = this.val$parent.getFilterChain();
                    List filterList = filterChain.getAll();
                    for (IoFilterChain.Entry e : filterList) {
                        if (!e.getName().startsWith(HttpConnectProcessor.FILTER_PREFIX)) continue;
                        filterChain.remove(e.getName());
                    }
                    if (!HttpConnectProcessor.this.persistentConnectionPool.recycle(this.val$session)) {
                        HttpConnectProcessor.super.removeInternal(this.val$session);
                    }
                }
            });
            if (!session.getCloseFuture().isClosed()) {
                parent.getConfig().setBothIdleTime(keepAliveTimeout.intValue());
                parent.getFilterChain().addLast(IDLE_FILTER, (IoFilter)this.idleFilter);
            }
        }
    }

    private static class HttpConnectIdleFilter
    extends HttpFilterAdapter<IoSessionEx> {
        private final Logger logger;

        HttpConnectIdleFilter(Logger logger) {
            this.logger = logger;
        }

        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Server didn't close the connection or respond to an http request within idle timeout. Closing %s", session));
            }
            session.close(false);
            super.sessionIdle(nextFilter, session, status);
        }
    }
}

