/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.DefaultConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeConnector;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.gateway.transport.BridgeServiceFactory;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.DefaultIoSessionConfigEx;
import org.kaazing.gateway.transport.DefaultTransportMetadata;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.LoggingFilter;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.HttpConnectFilter;
import org.kaazing.gateway.transport.http.HttpConnectProcessor;
import org.kaazing.gateway.transport.http.HttpConnectSessionFactory;
import org.kaazing.gateway.transport.http.HttpRetryConnectSessionFactory;
import org.kaazing.gateway.transport.http.HttpSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.PersistentConnectionPool;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBuffer;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBufferAllocator;
import org.kaazing.gateway.transport.http.security.auth.WWWAuthChallenge;
import org.kaazing.gateway.transport.http.security.auth.WWWAuthenticateHeaderUtils;
import org.kaazing.gateway.util.feature.EarlyAccessFeatures;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.AbstractIoSessionEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.session.IoSessionEx;

public class HttpConnector
extends AbstractBridgeConnector<DefaultHttpSession> {
    private static final TypedAttributeKey<HttpConnectSessionFactory> HTTP_SESSION_FACTORY_KEY = new TypedAttributeKey(HttpConnector.class, "httpSessionFactory");
    public static final TypedAttributeKey<DefaultHttpSession> HTTP_SESSION_KEY = new TypedAttributeKey(HttpConnector.class, "httpSession");
    private static final TypedAttributeKey<ConnectFuture> HTTP_CONNECT_FUTURE_KEY = new TypedAttributeKey(HttpConnector.class, "httpConnectFuture");
    private Properties configuration;
    private final Map<String, Set<HttpConnectFilter>> connectFiltersByProtocol;
    private final Set<HttpConnectFilter> allConnectFilters;
    private BridgeServiceFactory bridgeServiceFactory;
    ResourceAddressFactory addressFactory;
    private final PersistentConnectionPool persistentConnectionsStore;
    private IoHandler bridgeHandler = new IoHandlerAdapter<IoSessionEx>(){

        protected void doSessionOpened(IoSessionEx session) throws Exception {
            IoFilterChain filterChain = session.getFilterChain();
            HttpConnector.this.addBridgeFilters(filterChain);
            HttpConnectSessionFactory sessionFactory = (HttpConnectSessionFactory)HTTP_SESSION_FACTORY_KEY.remove((IoSession)session);
            DefaultHttpSession httpSession = sessionFactory.get((IoSession)session);
            HTTP_SESSION_KEY.set((IoSession)session, (Object)httpSession);
            DefaultConnectFuture connectFuture = (DefaultConnectFuture)HTTP_CONNECT_FUTURE_KEY.remove((IoSession)session);
            if (!connectFuture.isDone()) {
                connectFuture.setValue((Object)httpSession);
            }
        }

        protected void doSessionClosed(IoSessionEx session) throws Exception {
            DefaultHttpSession httpSession = (DefaultHttpSession)HTTP_SESSION_KEY.remove((IoSession)session);
            if (httpSession != null) {
                boolean connectionClose = HttpUtils.hasCloseHeader(httpSession.getReadHeaders("Connection"));
                if (!httpSession.isClosing() && !connectionClose) {
                    httpSession.setStatus(HttpStatus.SERVER_GATEWAY_TIMEOUT);
                    httpSession.reset(new IOException("Early termination of IO session").fillInStackTrace());
                    return;
                }
                if (connectionClose && !httpSession.isClosing()) {
                    httpSession.getProcessor().remove((IoSession)httpSession);
                }
                if (!session.isClosing()) {
                    IoFilterChain filterChain = session.getFilterChain();
                    HttpConnector.this.removeBridgeFilters(filterChain);
                }
            }
        }

        protected void doExceptionCaught(IoSessionEx session, Throwable cause) throws Exception {
            if (HttpConnector.this.logger.isDebugEnabled()) {
                String message = String.format("Error on HTTP connection attempt: %s", cause);
                if (HttpConnector.this.logger.isTraceEnabled()) {
                    HttpConnector.this.logger.debug(message, cause);
                } else {
                    HttpConnector.this.logger.debug(message);
                }
            }
            session.close(true);
            ConnectFuture httpConnectFuture = (ConnectFuture)HTTP_CONNECT_FUTURE_KEY.remove((IoSession)session);
            if (httpConnectFuture != null) {
                httpConnectFuture.setException(cause);
            }
        }

        protected void doSessionIdle(IoSessionEx session, IdleStatus status) throws Exception {
            super.doSessionIdle((IoSession)session, status);
        }

        protected void doMessageReceived(IoSessionEx session, Object message) throws Exception {
            DefaultHttpSession httpSession = (DefaultHttpSession)HTTP_SESSION_KEY.get((IoSession)session);
            HttpMessage httpMessage = (HttpMessage)((Object)message);
            block0 : switch (httpMessage.getKind()) {
                case RESPONSE: {
                    HttpResponseMessage httpResponse = (HttpResponseMessage)httpMessage;
                    HttpStatus httpStatus = httpResponse.getStatus();
                    httpSession.setStatus(httpStatus);
                    httpSession.setReason(httpResponse.getReason());
                    httpSession.setVersion(httpResponse.getVersion());
                    httpSession.setReadHeaders(httpResponse.getHeaders());
                    httpSession.getResponseFuture().setReady();
                    block4 : switch (httpStatus) {
                        case INFO_SWITCHING_PROTOCOLS: {
                            httpSession.close(false);
                            break;
                        }
                        case SUCCESS_OK: {
                            switch (httpSession.getMethod()) {
                                case HEAD: {
                                    httpSession.close(false);
                                    break block4;
                                }
                            }
                            HttpContentMessage httpContent = httpResponse.getContent();
                            if (httpContent == null) {
                                IoBufferAllocatorEx allocator = httpSession.getBufferAllocator();
                                httpContent = new HttpContentMessage(allocator.wrap(allocator.allocate(0)), true);
                            }
                            this.fireContentReceived(httpSession, httpContent);
                            break;
                        }
                        case REDIRECT_MOVED_PERMANENTLY: 
                        case REDIRECT_FOUND: {
                            if (this.shouldFollowRedirects(httpSession)) {
                                if (!httpResponse.isComplete()) break block0;
                                this.followRedirect(httpSession, session);
                                break;
                            }
                        }
                        case SUCCESS_NO_CONTENT: 
                        case REDIRECT_NOT_MODIFIED: {
                            httpSession.close(false);
                            break;
                        }
                        case CLIENT_UNAUTHORIZED: {
                            String authenticate = this.getAuthentication(httpSession, (HttpResponseMessage)httpMessage, Authenticator.RequestorType.SERVER);
                            if (authenticate != null) {
                                this.authenticate(httpSession, session, authenticate, Authenticator.RequestorType.SERVER);
                                break;
                            }
                            HttpContentMessage httpContent = httpResponse.getContent();
                            if (httpContent == null) {
                                IoBufferAllocatorEx allocator = httpSession.getBufferAllocator();
                                httpContent = new HttpContentMessage(allocator.wrap(allocator.allocate(0)), true);
                            }
                            this.fireContentReceived(httpSession, httpContent);
                            break;
                        }
                        default: {
                            HttpContentMessage httpContent = httpResponse.getContent();
                            if (httpContent == null) {
                                IoBufferAllocatorEx allocator = httpSession.getBufferAllocator();
                                httpContent = new HttpContentMessage(allocator.wrap(allocator.allocate(0)), true);
                            }
                            this.fireContentReceived(httpSession, httpContent);
                            break;
                        }
                    }
                    break;
                }
                case CONTENT: {
                    HttpContentMessage httpContent = (HttpContentMessage)httpMessage;
                    switch (httpSession.getStatus()) {
                        case REDIRECT_MOVED_PERMANENTLY: 
                        case REDIRECT_FOUND: {
                            if (!this.shouldFollowRedirects(httpSession) || !httpContent.isComplete()) break block0;
                            this.followRedirect(httpSession, session);
                            break;
                        }
                        default: {
                            this.fireContentReceived(httpSession, httpContent);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected HTTP message: " + (Object)((Object)httpMessage.getKind()));
                }
            }
        }

        private boolean shouldFollowRedirects(DefaultHttpSession httpSession) {
            Integer redirctBehavior = (Integer)httpSession.getRemoteAddress().getOption(HttpResourceAddress.MAXIMUM_REDIRECTS);
            return redirctBehavior != null && redirctBehavior > 0;
        }

        String getAuthentication(DefaultHttpSession httpSession, HttpResponseMessage httpMessage, Authenticator.RequestorType requestorType) {
            String result;
            block4: {
                Integer maxAthenticates = new Integer((Integer)httpSession.getRemoteAddress().getOption(HttpResourceAddress.MAX_AUTHENTICATION_ATTEMPTS));
                result = null;
                if (maxAthenticates > 0 && EarlyAccessFeatures.HTTP_AUTHENTICATOR.isEnabled(HttpConnector.this.configuration)) {
                    try {
                        PasswordAuthentication credentials;
                        WWWAuthChallenge challenge;
                        String scheme;
                        ResourceAddress remoteAddress = httpSession.getRemoteAddress();
                        URI remoteURI = remoteAddress.getResource();
                        List<WWWAuthChallenge> challenges = WWWAuthenticateHeaderUtils.getChallenges(httpMessage.getHeader("WWW-Authenticate"));
                        Iterator<WWWAuthChallenge> iterator = challenges.iterator();
                        while (iterator.hasNext() && (result = WWWAuthChallenge.encodeAuthorizationHeader(scheme = (challenge = iterator.next()).getScheme(), credentials = Authenticator.requestPasswordAuthentication(remoteURI.getHost(), InetAddress.getByName(remoteURI.getHost()), remoteURI.getPort(), "HTTP", challenge.getChallenge().replaceFirst(scheme + " ", ""), scheme, remoteURI.toURL(), requestorType))) == null) {
                        }
                    }
                    catch (Exception e) {
                        if (!HttpConnector.this.logger.isWarnEnabled()) break block4;
                        HttpConnector.this.logger.warn("Failed to get a valid response from Authenticator due to exception ", (Throwable)e);
                    }
                }
            }
            return result;
        }

        private DefaultConnectFuture authenticate(DefaultHttpSession httpSession, IoSessionEx session, String authorizationValue, Authenticator.RequestorType requestorType) {
            String location = httpSession.getRemoteAddress().getExternalURI();
            HashMap overrides = new HashMap();
            Integer maxAthenticates = new Integer((Integer)httpSession.getRemoteAddress().getOption(HttpResourceAddress.MAX_AUTHENTICATION_ATTEMPTS) - 1);
            overrides.put(HttpResourceAddress.MAX_AUTHENTICATION_ATTEMPTS, maxAthenticates);
            ResourceAddress newConnectAddress = HttpConnector.this.addressFactory.newResourceAddress(location.replaceFirst("ws", "http"), (ResourceOptions)new WrappedResourceOptionsForConnectionRetry(httpSession, overrides));
            if (Authenticator.RequestorType.SERVER.equals((Object)requestorType)) {
                httpSession.setWriteHeader("Authorization", authorizationValue);
            } else {
                httpSession.setWriteHeader("Proxy-Authorization", authorizationValue);
            }
            String challengeIdentity = httpSession.getReadHeader("Sec-Challenge-Identity");
            if (challengeIdentity != null) {
                httpSession.setWriteHeader("Sec-Challenge-Identity", challengeIdentity);
            }
            return this.retryConnect(httpSession, session, newConnectAddress);
        }

        private DefaultConnectFuture followRedirect(DefaultHttpSession httpSession, IoSessionEx session) {
            HashMap overrides = new HashMap();
            String location = httpSession.getReadHeader("location");
            Integer maxRedirects = new Integer((Integer)httpSession.getRemoteAddress().getOption(HttpResourceAddress.MAXIMUM_REDIRECTS) - 1);
            overrides.put(HttpResourceAddress.MAXIMUM_REDIRECTS, maxRedirects);
            ResourceAddress newConnectAddress = HttpConnector.this.addressFactory.newResourceAddress(location.replaceFirst("ws", "http"), (ResourceOptions)new WrappedResourceOptionsForConnectionRetry(httpSession, overrides));
            return this.retryConnect(httpSession, session, newConnectAddress);
        }

        private DefaultConnectFuture retryConnect(DefaultHttpSession httpSession, IoSessionEx session, ResourceAddress newConnectAddress) {
            DefaultConnectFuture connectFuture = new DefaultConnectFuture();
            HTTP_SESSION_KEY.remove((IoSession)session);
            connectFuture.addListener(future -> session.close(false));
            httpSession.setRemoteAddress(newConnectAddress);
            HttpRetryConnectSessionFactory httpSessionFactory = new HttpRetryConnectSessionFactory(httpSession);
            HttpConnector.this.connectInternal0((ConnectFuture)connectFuture, newConnectAddress, httpSessionFactory);
            return connectFuture;
        }

        private void fireContentReceived(HttpSession session, HttpContentMessage content) {
            IoBufferEx buffer = content.asBuffer();
            if (buffer != null && buffer.hasRemaining()) {
                IoFilterChain filterChain = session.getFilterChain();
                filterChain.fireMessageReceived((Object)buffer);
            }
            if (content.isComplete()) {
                session.close(false);
            }
        }
    };

    public HttpConnector() {
        super((IoSessionConfigEx)new DefaultIoSessionConfigEx());
        HashMap<String, EnumSet<HttpConnectFilter>> connectFiltersByProtocol = new HashMap<String, EnumSet<HttpConnectFilter>>();
        connectFiltersByProtocol.put("http/1.1", EnumSet.complementOf(EnumSet.of(HttpConnectFilter.CONTENT_LENGTH_ADJUSTMENT, HttpConnectFilter.PROTOCOL_HTTPXE)));
        connectFiltersByProtocol.put("httpxe/1.1", EnumSet.complementOf(EnumSet.of(HttpConnectFilter.CONTENT_LENGTH_ADJUSTMENT)));
        this.connectFiltersByProtocol = Collections.unmodifiableMap(connectFiltersByProtocol);
        this.allConnectFilters = EnumSet.allOf(HttpConnectFilter.class);
        this.persistentConnectionsStore = new PersistentConnectionPool(this.logger);
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    @Resource(name="bridgeServiceFactory")
    public void setBridgeServiceFactory(BridgeServiceFactory bridgeServiceFactory) {
        this.bridgeServiceFactory = bridgeServiceFactory;
    }

    @Resource(name="resourceAddressFactory")
    public void setResourceAddressFactory(ResourceAddressFactory resourceAddressFactory) {
        this.addressFactory = resourceAddressFactory;
    }

    protected IoProcessorEx<DefaultHttpSession> initProcessor() {
        return new HttpConnectProcessor(this.persistentConnectionsStore, this.logger);
    }

    public TransportMetadata getTransportMetadata() {
        return new DefaultTransportMetadata("http");
    }

    protected boolean canConnect(String transportName) {
        return transportName.equals("http");
    }

    protected <T extends ConnectFuture> ConnectFuture connectInternal(ResourceAddress address, IoHandler handler, IoSessionInitializer<T> initializer) {
        DefaultConnectFuture connectFuture = new DefaultConnectFuture();
        ResourceAddress transportAddress = address.getTransport();
        IoSessionInitializer<T> httpSessionInitializer = this.createHttpSessionInitializer(handler, initializer);
        DefaultHttpConnectSessionFactory httpSessionFactory = new DefaultHttpConnectSessionFactory(this, address, httpSessionInitializer, (ConnectFuture)connectFuture);
        if (transportAddress != null) {
            Executor ioExecutor = (Executor)AbstractIoSessionEx.CURRENT_WORKER.get();
            if (ioExecutor == null) {
                this.connectInternal0((ConnectFuture)connectFuture, address, httpSessionFactory);
            } else {
                ioExecutor.execute(() -> this.lambda$connectInternal$0((ConnectFuture)connectFuture, address, httpSessionFactory));
            }
        }
        return connectFuture;
    }

    private <T extends ConnectFuture> void connectInternal0(ConnectFuture connectFuture, ResourceAddress address, HttpConnectSessionFactory httpSessionFactory) {
        IoSession transportSession = this.persistentConnectionsStore.take((HttpResourceAddress)address);
        if (transportSession != null) {
            this.connectUsingExistingTransport(connectFuture, transportSession, httpSessionFactory);
        } else {
            this.connectUsingNewTransport(connectFuture, address, httpSessionFactory);
        }
    }

    protected <T extends ConnectFuture> void connectUsingExistingTransport(ConnectFuture connectFuture, IoSession transportSession, HttpConnectSessionFactory httpSessionFactory) {
        HTTP_SESSION_FACTORY_KEY.set(transportSession, (Object)httpSessionFactory);
        HTTP_CONNECT_FUTURE_KEY.set(transportSession, (Object)connectFuture);
        try {
            this.bridgeHandler.sessionOpened(transportSession);
        }
        catch (Exception e) {
            connectFuture.setException((Throwable)e);
        }
    }

    private <T extends ConnectFuture> void connectUsingNewTransport(ConnectFuture connectFuture, ResourceAddress address, HttpConnectSessionFactory httpSessionFactory) {
        IoFutureListener parentConnectListener = future -> {
            if (!future.isConnected()) {
                connectFuture.setException(future.getException());
            }
        };
        ResourceAddress transportAddress = address.getTransport();
        BridgeConnector connector = this.bridgeServiceFactory.newBridgeConnector(transportAddress);
        IoSessionInitializer<ConnectFuture> parentInitializer = this.createParentInitializer(address, connectFuture, httpSessionFactory);
        connector.connect(transportAddress, this.bridgeHandler, parentInitializer).addListener(parentConnectListener);
    }

    public void addBridgeFilters(IoFilterChain chain) {
        ResourceAddress address;
        IoSession transport = chain.getSession();
        SocketAddress localAddress = transport.getLocalAddress();
        String nextProtocol = "http/1.1";
        if (localAddress instanceof ResourceAddress && !(address = (ResourceAddress)localAddress).hasOption(ResourceAddress.QUALIFIER)) {
            nextProtocol = (String)address.getOption(ResourceAddress.NEXT_PROTOCOL);
        }
        assert (nextProtocol != null);
        Set<HttpConnectFilter> connectFilters = this.connectFiltersByProtocol.get(nextProtocol);
        assert (connectFilters != null && !connectFilters.isEmpty());
        for (HttpConnectFilter connectFilter : connectFilters) {
            chain.addLast(connectFilter.filterName(), connectFilter.filter());
        }
        LoggingFilter.moveAfterCodec((IoSession)transport);
    }

    public void removeBridgeFilters(IoFilterChain filterChain) {
        block3: for (HttpConnectFilter filter : this.allConnectFilters) {
            switch (filter) {
                case CODEC: {
                    continue block3;
                }
            }
            this.removeFilter(filterChain, filter.filterName());
        }
    }

    protected void finishSessionInitialization0(IoSession session, IoFuture future) {
        DefaultHttpSession httpSession = (DefaultHttpSession)session;
        HttpConnectProcessor processor = (HttpConnectProcessor)httpSession.getProcessor();
        processor.finishConnect(httpSession);
    }

    private <T extends ConnectFuture> IoSessionInitializer<ConnectFuture> createParentInitializer(ResourceAddress connectAddress, ConnectFuture httpConnectFuture, HttpConnectSessionFactory httpSessionFactory) {
        return (parent, future) -> {
            HTTP_SESSION_FACTORY_KEY.set(parent, (Object)httpSessionFactory);
            HTTP_CONNECT_FUTURE_KEY.set(parent, (Object)httpConnectFuture);
        };
    }

    private <T extends ConnectFuture> IoSessionInitializer<T> createHttpSessionInitializer(IoHandler handler, IoSessionInitializer<T> initializer) {
        return (session, future) -> {
            DefaultHttpSession httpSession = (DefaultHttpSession)session;
            httpSession.setHandler(handler);
            if (initializer != null) {
                initializer.initializeSession(session, future);
            }
        };
    }

    private /* synthetic */ void lambda$connectInternal$0(ConnectFuture connectFuture, ResourceAddress address, HttpConnectSessionFactory httpSessionFactory) {
        this.connectInternal0(connectFuture, address, httpSessionFactory);
    }

    class DefaultHttpConnectSessionFactory
    implements HttpConnectSessionFactory {
        private final HttpConnector httpConnector;
        private final ResourceAddress connectAddress;
        private final IoSessionInitializer<? extends IoFuture> httpSessionInitializer;
        private final IoFuture connectFuture;

        public DefaultHttpConnectSessionFactory(HttpConnector httpConnector, ResourceAddress connectAddress, IoSessionInitializer<? extends IoFuture> httpSessionInitializer, ConnectFuture connectFuture) {
            this.httpConnector = httpConnector;
            this.connectAddress = connectAddress;
            this.httpSessionInitializer = httpSessionInitializer;
            this.connectFuture = connectFuture;
        }

        @Override
        public DefaultHttpSession get(IoSession parent) throws Exception {
            ResourceAddress transportAddress = (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get(parent);
            ResourceAddress localAddress = this.httpConnector.addressFactory.newResourceAddress(this.connectAddress, transportAddress);
            Callable<DefaultHttpSession> httpSessionFactory = () -> {
                IoSessionEx parentEx = (IoSessionEx)parent;
                IoBufferAllocatorEx parentAllocator = parentEx.getBufferAllocator();
                DefaultHttpSession httpSession = new DefaultHttpSession((IoServiceEx)this.httpConnector, (IoProcessorEx<DefaultHttpSession>)this.httpConnector.getProcessor(), localAddress, this.connectAddress, parentEx, (IoBufferAllocatorEx<HttpBuffer>)new HttpBufferAllocator(parentAllocator), this.httpConnector.configuration);
                parent.setAttribute(HTTP_SESSION_KEY, (Object)httpSession);
                return httpSession;
            };
            return (DefaultHttpSession)this.httpConnector.newSession(this.httpSessionInitializer, this.connectFuture, httpSessionFactory);
        }
    }

    private final class WrappedResourceOptionsForConnectionRetry
    implements ResourceOptions {
        private final DefaultHttpSession httpSession;
        private final Map<ResourceOption<?>, Object> optionOverrides;

        public WrappedResourceOptionsForConnectionRetry(DefaultHttpSession httpSession, HashMap<ResourceOption<?>, Object> overrides) {
            this.httpSession = httpSession;
            this.optionOverrides = overrides;
        }

        public <T> T setOption(ResourceOption<T> key, T value) {
            return (T)this.httpSession.getRemoteAddress().setOption(key, value);
        }

        public <T> boolean hasOption(ResourceOption<T> key) {
            if (ResourceAddress.TRANSPORT_URI.equals(key) || ResourceAddress.TRANSPORT.equals(key) || ResourceAddress.TRANSPORTED_URI.equals(key)) {
                return false;
            }
            return this.httpSession.getRemoteAddress().hasOption(key);
        }

        public <T> T getOption(ResourceOption<T> key) {
            if (ResourceAddress.TRANSPORT_URI.equals(key) || ResourceAddress.TRANSPORT.equals(key) || ResourceAddress.TRANSPORTED_URI.equals(key)) {
                return null;
            }
            Object override = this.optionOverrides.get(key);
            return (T)(override != null ? override : this.httpSession.getRemoteAddress().getOption(key));
        }
    }
}

