/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.ProtocolCodecFilter;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpAcceptor;
import org.kaazing.gateway.transport.http.HttpSession;
import org.kaazing.mina.core.buffer.IoBufferEx;

public class HttpProtocolCodecFilter
extends ProtocolCodecFilter {
    public HttpProtocolCodecFilter(ProtocolCodecFactory factory) {
        super(factory);
    }

    public HttpProtocolCodecFilter(ProtocolEncoder encoder, ProtocolDecoder decoder) {
        super(encoder, decoder);
    }

    public HttpProtocolCodecFilter(Class<? extends ProtocolEncoder> encoderClass, Class<? extends ProtocolDecoder> decoderClass) {
        super(encoderClass, decoderClass);
    }

    public void filterWrite(final IoFilter.NextFilter nextFilter, final IoSession session, final WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() instanceof Message) {
            IoBufferEx cachedProtocolBuffer;
            Message message = (Message)writeRequest.getMessage();
            String nextProtocol = (String)((ResourceAddress)BridgeSession.LOCAL_ADDRESS.get(session)).getOption(ResourceAddress.NEXT_PROTOCOL);
            if (message.hasCache() && (cachedProtocolBuffer = (IoBufferEx)message.getCache().get(nextProtocol)) != null && cachedProtocolBuffer.capacity() == 0) {
                HttpSession child = (HttpSession)HttpAcceptor.SESSION_KEY.get(session);
                if (session instanceof HttpAcceptSession && child != null && child.isCommitting() && !child.isClosing()) {
                    ((HttpAcceptSession)session).commit().addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                        public void operationComplete(IoFuture future) {
                            writeRequest.getFuture().setWritten();
                            nextFilter.messageSent(session, writeRequest);
                        }
                    });
                } else {
                    writeRequest.getFuture().setWritten();
                    nextFilter.messageSent(session, writeRequest);
                }
                return;
            }
        }
        super.filterWrite(nextFilter, session, writeRequest);
    }
}

