/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kaazing.gateway.transport.dispatch.ProtocolDispatcher;
import org.kaazing.gateway.transport.http.HttpMethod;

class HttpProtocolDispatcher
implements ProtocolDispatcher {
    private static final String HTTP_PROTOCOL = "http/1.1";
    private static final Collection<byte[]> HTTP_DISCRIMINATORS;

    HttpProtocolDispatcher() {
    }

    public int compareTo(ProtocolDispatcher pd) {
        return protocolDispatchComparator.compare(this, pd);
    }

    public String getProtocolName() {
        return HTTP_PROTOCOL;
    }

    public Collection<byte[]> getDiscriminators() {
        return HTTP_DISCRIMINATORS;
    }

    static {
        HttpMethod[] httpMethods = HttpMethod.values();
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(httpMethods.length * 2);
        for (HttpMethod httpMethod : httpMethods) {
            String methodName = httpMethod.name();
            char initialChar = methodName.charAt(0);
            char initialCharUppercase = Character.toUpperCase(initialChar);
            char initialCharLowercase = Character.toLowerCase(initialChar);
            byteArrays.add(new byte[]{(byte)initialCharUppercase});
            byteArrays.add(new byte[]{(byte)initialCharLowercase});
        }
        HTTP_DISCRIMINATORS = Collections.unmodifiableList(byteArrays);
    }
}

