/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.net.URI;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.ProxyHandler;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpCodecFilter;

public class HttpProxyHandler
extends ProxyHandler {
    private final HttpCodecFilter httpCodec = new HttpCodecFilter(true);

    public void sessionOpened(IoSession session) throws Exception {
        ResourceAddress remoteAddress = (ResourceAddress)session.getAttribute((Object)REMOTE_ADDRESS_KEY);
        URI resource = remoteAddress.getResource();
        int remotePort = resource.getPort();
        String remoteHostName = resource.getHost();
        HttpRequestMessage httpRequest = new HttpRequestMessage();
        httpRequest.setMethod(HttpMethod.CONNECT);
        httpRequest.setRequestURI(new URI(null, null, remoteHostName, remotePort, null, null, null));
        httpRequest.setVersion(HttpVersion.HTTP_1_1);
        session.getFilterChain().addFirst("http", (IoFilter)this.httpCodec);
        session.write((Object)httpRequest);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        session.getFilterChain().remove("http");
        HttpResponseMessage httpResponse = (HttpResponseMessage)((Object)message);
        switch (httpResponse.getStatus()) {
            case SUCCESS_OK: {
                this.newProxySession(session);
                break;
            }
            default: {
                this.failProxySession(session);
            }
        }
    }
}

