/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.transport.SslUtils;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final String PROXY_BUFFERING_HEADER = "X-Kaazing-Proxy-Buffering";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Random SESSION_SEQUENCE = new SecureRandom();
    private static final char[] BASE_62_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final int BASE_62_CHARS_LENGTH = BASE_62_CHARS.length;
    private static final DateFormat[] RFC822_PARSE_PATTERNS = new DateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH), new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z", Locale.ENGLISH), new SimpleDateFormat("EEE, d MMM yy HH:mm z", Locale.ENGLISH), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH), new SimpleDateFormat("EEE, d MMM yyyy HH:mm z", Locale.ENGLISH), new SimpleDateFormat("d MMM yy HH:mm z", Locale.ENGLISH), new SimpleDateFormat("d MMM yy HH:mm:ss z", Locale.ENGLISH), new SimpleDateFormat("d MMM yyyy HH:mm z", Locale.ENGLISH), new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.ENGLISH)};
    private static final DateFormat RFC822_FORMAT_PATTERN = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
    private static final String[] FORBIDDEN_HEADERS;
    public static Map<String, List<String>> EMPTY_HEADERS;

    public static String getHostDomain(HttpRequestMessage httpRequest) {
        String host = httpRequest.getHeader("Host");
        int index = host.indexOf(58);
        if (index != -1) {
            host = host.substring(0, index);
        }
        return host;
    }

    public static String getHostAndPort(HttpRequestMessage httpRequest, boolean secure) {
        String authority = httpRequest.getHeader("Host");
        return HttpUtils.getHostAndPort(authority, secure);
    }

    public static String getHostAndPort(String authority, boolean secure) {
        if (authority != null && authority.indexOf(58) == -1) {
            int port = secure ? 443 : 80;
            authority = authority + ":" + port;
        }
        return authority;
    }

    public static long parseDateHeader(String header) {
        if (header != null && header.length() > 0) {
            for (DateFormat rfc822Format : RFC822_PARSE_PATTERNS) {
                try {
                    Date headerDate = rfc822Format.parse(header);
                    return headerDate.getTime();
                }
                catch (NumberFormatException e) {
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Unable to parse date header: " + header);
    }

    public static String formatDateHeader(long millis) {
        return RFC822_FORMAT_PATTERN.format(millis);
    }

    public static void fileRequested(IoBufferAllocatorEx<?> allocator, HttpRequestMessage httpRequest, HttpResponseMessage httpResponse, File requestFile) throws IOException {
        if (requestFile.isFile() && requestFile.exists()) {
            String ifModifiedSince;
            String ifNoneMatch;
            String etag = HttpUtils.getETagHeaderValue(requestFile);
            if (!HttpUtils.hasBeenModified(requestFile, etag, ifNoneMatch = httpRequest.getHeader("If-None-Match"), ifModifiedSince = httpRequest.getHeader("If-Modified-Since"))) {
                httpResponse.setHeader("ETag", etag);
                httpResponse.setStatus(HttpStatus.REDIRECT_NOT_MODIFIED);
            } else {
                int length;
                FileInputStream in = new FileInputStream(requestFile);
                byte[] buf = new byte[8192];
                IoBufferEx out = allocator.wrap(allocator.allocate(in.available())).setAutoExpander(allocator);
                while ((length = in.read(buf)) > 0) {
                    out.put(buf, 0, length);
                }
                out.flip();
                in.close();
                httpResponse.setHeader("ETag", etag);
                httpResponse.setHeader("Last-Modified", RFC822_FORMAT_PATTERN.format(requestFile.lastModified()));
                httpResponse.setHeader("Expires", RFC822_FORMAT_PATTERN.format(System.currentTimeMillis()));
                httpResponse.setContent(new HttpContentMessage(out, true));
            }
        } else {
            httpResponse.setStatus(HttpStatus.CLIENT_NOT_FOUND);
        }
    }

    public static void writeIfModified(HttpAcceptSession httpSession, File requestFile) throws IOException {
        if (requestFile.isFile() && requestFile.exists()) {
            String ifModifiedSince;
            String ifNoneMatch;
            String etag = HttpUtils.getETagHeaderValue(requestFile);
            if (!HttpUtils.hasBeenModified(requestFile, etag, ifNoneMatch = httpSession.getReadHeader("If-None-Match"), ifModifiedSince = httpSession.getReadHeader("If-Modified-Since"))) {
                httpSession.setWriteHeader("ETag", etag);
                httpSession.setStatus(HttpStatus.REDIRECT_NOT_MODIFIED);
            } else {
                int length;
                FileInputStream in = new FileInputStream(requestFile);
                byte[] buf = new byte[8192];
                IoBufferAllocatorEx allocator = httpSession.getBufferAllocator();
                IoBufferEx out = allocator.wrap(allocator.allocate(in.available())).setAutoExpander(allocator);
                while ((length = in.read(buf)) > 0) {
                    out.put(buf, 0, length);
                }
                out.flip();
                in.close();
                httpSession.setWriteHeader("ETag", etag);
                httpSession.setWriteHeader("Last-Modified", RFC822_FORMAT_PATTERN.format(requestFile.lastModified()));
                httpSession.setWriteHeader("Expires", RFC822_FORMAT_PATTERN.format(System.currentTimeMillis()));
                httpSession.suspendWrite();
                httpSession.write(out);
                httpSession.shutdownWrite();
                httpSession.resumeWrite();
            }
        } else {
            httpSession.setStatus(HttpStatus.CLIENT_NOT_FOUND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IoBufferEx getBufferForFile(IoBufferAllocatorEx<?> allocator, File requestFile) throws IOException {
        FileInputStream in = new FileInputStream(requestFile);
        IoBufferEx out = allocator.wrap(allocator.allocate(in.available())).setAutoExpander(allocator);
        try {
            int length;
            int pos = out.position();
            byte[] buf = new byte[8192];
            while ((length = in.read(buf)) > 0) {
                out.put(buf, 0, length);
            }
            out.position(pos);
        }
        finally {
            in.close();
        }
        return out;
    }

    public static boolean hasBeenModified(HttpSession session, String etag, File requestFile) {
        String ifNoneMatch = session.getReadHeader("If-None-Match");
        String ifModifiedSince = session.getReadHeader("If-Modified-Since");
        return HttpUtils.hasBeenModified(requestFile, etag, ifNoneMatch, ifModifiedSince);
    }

    private static boolean hasBeenModified(File requestFile, String eTag, String ifNoneMatch, String ifModifiedSince) {
        if (ifNoneMatch != null && !"*".equals(ifNoneMatch)) {
            String[] candidateETags;
            for (String candidateETag : candidateETags = ifNoneMatch.split(",\\s?")) {
                if (!candidateETag.equals(eTag)) continue;
                return false;
            }
            return true;
        }
        if (ifModifiedSince == null || ifModifiedSince.length() == 0) {
            return true;
        }
        long lastModified = requestFile.lastModified();
        Date ifModifiedSinceDate = null;
        for (DateFormat rfc822Format : RFC822_PARSE_PATTERNS) {
            try {
                ifModifiedSinceDate = rfc822Format.parse(ifModifiedSince);
                break;
            }
            catch (NumberFormatException e) {
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (ifModifiedSinceDate == null) {
            return true;
        }
        double time_difference = Math.floor(Math.abs(lastModified - ifModifiedSinceDate.getTime()) / 1000L);
        return time_difference > 0.0;
    }

    public static void addLastModifiedHeader(HttpSession session, File requestFile) {
        long lastModified = requestFile.lastModified();
        session.setWriteHeader("Last-Modified", RFC822_FORMAT_PATTERN.format(lastModified));
    }

    public static String getETagHeaderValue(File requestFile) {
        long lastModified = requestFile.lastModified();
        String absolutePath = requestFile.getAbsolutePath();
        ByteBuffer buf = ByteBuffer.allocate(16);
        MessageDigest algorithm = HttpUtils.getMD5();
        algorithm.reset();
        algorithm.update(absolutePath.getBytes(UTF_8));
        buf.putLong(lastModified).flip();
        algorithm.update(buf);
        byte[] digest = algorithm.digest();
        buf.position(0);
        buf.limit(buf.capacity());
        buf.put(digest);
        buf.flip();
        StringBuilder builder = new StringBuilder();
        builder.append("W/\"");
        builder.append(Long.toHexString(buf.getLong()));
        builder.append(Long.toHexString(buf.getLong()));
        builder.append('\"');
        String headerValue = builder.toString();
        return headerValue;
    }

    public static void supplyScriptAsHtml(File xdBridgeFile, long startTime, String resourcePath) throws IOException {
        String bridgeFileName = xdBridgeFile.getName();
        String heading = bridgeFileName.substring(0, bridgeFileName.lastIndexOf(46));
        String preamble = "<html><head></head><body><script>";
        String postamble = "</script><h3>" + heading + "</h3></body></html>";
        HttpUtils.supplyBridgeFile(xdBridgeFile, startTime, resourcePath, preamble, postamble);
    }

    public static void supplyFile(File bridgeFile, long startTime, String resourcePath) throws IOException {
        HttpUtils.supplyBridgeFile(bridgeFile, startTime, resourcePath, null, null);
    }

    private static void supplyBridgeFile(File xdBridgeFile, long startTime, String resourcePath, String preamble, String postamble) throws IOException {
        if (!xdBridgeFile.exists() || xdBridgeFile.lastModified() < startTime) {
            ClassLoader loader = HttpUtils.class.getClassLoader();
            URL resource = loader.getResource(resourcePath);
            if (resource == null) {
                LOGGER.error("Unable to find resource on classpath: " + resourcePath);
            } else {
                int len;
                xdBridgeFile.getParentFile().mkdirs();
                InputStream in = resource.openStream();
                FileOutputStream fos = new FileOutputStream(xdBridgeFile);
                if (preamble != null) {
                    fos.write(preamble.getBytes());
                }
                byte[] buf = new byte[8192];
                while ((len = in.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                if (postamble != null) {
                    fos.write(postamble.getBytes());
                }
                in.close();
                fos.close();
                xdBridgeFile.getParentFile().mkdirs();
            }
        }
    }

    public static boolean canStream(HttpSession session) {
        if ("p".equals(session.getParameter(".ki"))) {
            return false;
        }
        String responseMode = session.getReadHeader(PROXY_BUFFERING_HEADER);
        if (responseMode != null) {
            assert (responseMode.equals("on") || responseMode.equals("off"));
            return responseMode.equals("off");
        }
        return true;
    }

    public static String newSessionId() {
        int size = 32;
        StringBuilder sessionId = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            int randomInt = Math.abs(SESSION_SEQUENCE.nextInt());
            sessionId.append(BASE_62_CHARS[randomInt % BASE_62_CHARS_LENGTH]);
        }
        return sessionId.toString();
    }

    public static URI getRequestURI(HttpRequestMessage request, IoSession session) {
        URI requestURI = request.getRequestURI();
        String host = request.getHeader("Host");
        return HttpUtils.getRequestURI(requestURI, host, session);
    }

    public static URI getRequestURI(URI requestURI, String hostHeader, IoSession session) {
        boolean secure = SslUtils.isSecure((IoSession)session);
        String authority = HttpUtils.getHostAndPort(hostHeader, secure);
        URI uri = URI.create("//" + authority + requestURI.getRawPath());
        return uri;
    }

    public static boolean hasCloseHeader(List<String> connectionValues) {
        if (connectionValues == null) {
            return false;
        }
        return connectionValues.stream().anyMatch(v -> v.equalsIgnoreCase("close"));
    }

    public static URI getTransportURI(HttpRequestMessage request, IoSession session) {
        URI requestURI = request.getRequestURI();
        String hostHeader = request.getHeader("Host");
        boolean secure = SslUtils.isSecure((IoSession)session);
        String authority = HttpUtils.getHostAndPort(hostHeader, secure);
        return URI.create("http://" + authority + requestURI.getRawPath());
    }

    public static boolean isChunked(String transferEncoding) {
        if (transferEncoding != null) {
            int semicolonAt = transferEncoding.indexOf(59);
            if (semicolonAt != -1) {
                transferEncoding = transferEncoding.substring(0, semicolonAt);
            }
            if ("chunked".equalsIgnoreCase(transferEncoding)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChunked(HttpResponseMessage response) {
        String transferEncoding = response.getHeader("Transfer-Encoding");
        return HttpUtils.isChunked(transferEncoding) && HttpVersion.HTTP_1_1.equals((Object)response.getVersion());
    }

    public static boolean isGzipped(HttpResponseMessage response) {
        return response.isBlockPadding();
    }

    public static URI getCanonicalURI(URI uri, boolean canonicalizePath) {
        URI canonicalURI = uri;
        if (uri != null) {
            String newPath;
            boolean trailingSlashWithPathlessScheme;
            String host = uri.getHost();
            String path = uri.getPath();
            boolean emptyPath = "".equals(path);
            boolean noPathToCanonicalize = canonicalizePath && (path == null || emptyPath);
            boolean trailingSlashPath = "/".equals(path);
            boolean pathlessScheme = "ssl".equals(uri.getScheme()) || "tcp".equals(uri.getScheme()) || "pipe".equals(uri.getScheme()) || "udp".equals(uri.getScheme());
            boolean bl = trailingSlashWithPathlessScheme = trailingSlashPath && pathlessScheme;
            Object object = trailingSlashWithPathlessScheme ? "" : (noPathToCanonicalize ? (pathlessScheme ? null : "/") : (newPath = null));
            if (host != null && !host.equals(host.toLowerCase()) || newPath != null) {
                path = newPath == null ? path : newPath;
                try {
                    canonicalURI = new URI(uri.getScheme(), uri.getUserInfo(), host == null ? null : host.toLowerCase(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Invalid URI: " + uri + " in Gateway configuration file", ex);
                }
            }
        }
        return canonicalURI;
    }

    public static URI getCanonicalURI(String uriString, boolean canonicalizePath) {
        if (uriString != null && !"".equals(uriString)) {
            return HttpUtils.getCanonicalURI(URI.create(uriString), canonicalizePath);
        }
        return null;
    }

    private static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getPathComponents(URI uri) {
        if (uri == null || uri.getPath() == null) {
            return new String[0];
        }
        return uri.getPath().split("/");
    }

    public static String getAuthenticationTokenFromPath(URI uri) {
        String urlEncodedToken = null;
        String[] pathComponents = HttpUtils.getPathComponents(uri);
        if (pathComponents != null && pathComponents.length >= 3 && (pathComponents[pathComponents.length - 3].equals(";e") && pathComponents[pathComponents.length - 2].startsWith("u") || pathComponents[pathComponents.length - 2].startsWith("d"))) {
            urlEncodedToken = pathComponents[pathComponents.length - 1];
        }
        return urlEncodedToken;
    }

    public static boolean containsForbiddenHeaders(HttpRequestMessage request, String[] allowedHeaders) {
        if (request == null) {
            throw new IllegalArgumentException("Request is null.");
        }
        Map<String, List<String>> headers = request.getHeaders();
        if (headers == null || headers.size() == 0) {
            return false;
        }
        boolean allowedHeadersEmpty = allowedHeaders == null || allowedHeaders.length == 0;
        for (String header : headers.keySet()) {
            boolean headerIsForbidden = HttpUtils.isForbiddenHeader(header);
            boolean headerIsAllowed = false;
            if (headerIsForbidden && !allowedHeadersEmpty) {
                for (String allowedHeader : allowedHeaders) {
                    if (!allowedHeader.equalsIgnoreCase(header)) continue;
                    headerIsAllowed = true;
                    break;
                }
            }
            if (!headerIsForbidden || headerIsAllowed) continue;
            return true;
        }
        return false;
    }

    public static boolean isForbiddenHeader(String header) {
        if (header == null || header.length() == 0) {
            throw new IllegalArgumentException("Invalid header in the HTTP request");
        }
        String lowerCaseHeader = header.toLowerCase();
        if (lowerCaseHeader.startsWith("proxy-") || lowerCaseHeader.startsWith("sec-")) {
            return true;
        }
        for (String prohibited : FORBIDDEN_HEADERS) {
            if (!header.equalsIgnoreCase(prohibited)) continue;
            return true;
        }
        return false;
    }

    public static void excludeHeaders(HttpRequestMessage request, String[] exclusions) {
        if (request == null) {
            throw new IllegalArgumentException("Request is null.");
        }
        if (exclusions == null || exclusions.length == 0) {
            return;
        }
        Map<String, List<String>> headers = request.getHeaders();
        if (headers == null || headers.size() == 0) {
            return;
        }
        headers = new HashMap<String, List<String>>(headers);
        HashSet<String> headerNames = new HashSet<String>(headers.keySet());
        for (String header : headerNames) {
            if (header == null || header.length() == 0) {
                throw new IllegalArgumentException("Invalid header in the HTTP request");
            }
            boolean ok = true;
            for (String excludedHeaderName : exclusions) {
                if (!header.equalsIgnoreCase(excludedHeaderName)) continue;
                ok = false;
                break;
            }
            if (ok) continue;
            headers.remove(header);
        }
        request.setHeaders(headers);
    }

    public static void restrictHeaders(HttpRequestMessage request, String[] restrictions) {
        if (request == null) {
            throw new IllegalArgumentException("Request is null.");
        }
        if (restrictions == null || restrictions.length == 0) {
            request.setHeaders(EMPTY_HEADERS);
            return;
        }
        Map<String, List<String>> headers = request.getHeaders();
        if (headers == null || headers.size() == 0) {
            return;
        }
        headers = new HashMap<String, List<String>>(headers);
        HashSet<String> headerNames = new HashSet<String>(headers.keySet());
        for (String header : headerNames) {
            if (header == null || header.length() == 0) {
                throw new IllegalArgumentException("Invalid header in the HTTP request");
            }
            boolean ok = false;
            for (String restrictedHeaderName : restrictions) {
                if (!header.equalsIgnoreCase(restrictedHeaderName)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            headers.remove(header);
        }
        request.setHeaders(headers);
    }

    public static void mergeHeaders(HttpRequestMessage from, HttpRequestMessage to, String[] ignoreHeaders) {
        Map<String, List<String>> fromHeaders;
        if (from == null || to == null) {
            throw new IllegalArgumentException("Request is null.");
        }
        if (ignoreHeaders == null) {
            ignoreHeaders = new String[]{};
        }
        if ((fromHeaders = from.getHeaders()) == null || fromHeaders.isEmpty()) {
            return;
        }
        if (to.getHeaders() == null) {
            to.setHeaders(new HashMap<String, List<String>>(fromHeaders.size()));
        }
        fromHeaders = new HashMap<String, List<String>>(fromHeaders);
        HashMap<String, List<String>> toHeaders = new HashMap<String, List<String>>(to.getHeaders());
        for (String ignoreHeader : ignoreHeaders) {
            fromHeaders.remove(ignoreHeader);
        }
        for (String fromHeader : fromHeaders.keySet()) {
            if (!toHeaders.containsKey(fromHeader)) {
                toHeaders.put(fromHeader, fromHeaders.get(fromHeader));
                continue;
            }
            List<String> fromValues = fromHeaders.get(fromHeader);
            List toValues = (List)toHeaders.get(fromHeader);
            if (fromValues == null || toValues == null) {
                throw new IllegalArgumentException("Illegal null header values from header: " + fromHeader);
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>(fromValues);
            result.addAll(toValues);
            toHeaders.put(fromHeader, new ArrayList<String>(result));
        }
        to.setHeaders(toHeaders);
    }

    public static void removeValueFromHeaders(HttpRequestMessage request, String[] headerNames, String valueToRemove) {
        if (request == null) {
            throw new IllegalArgumentException("Request is null.");
        }
        if (headerNames == null || headerNames.length == 0) {
            return;
        }
        if (valueToRemove == null || valueToRemove.length() == 0) {
            return;
        }
        Map<String, List<String>> requestHeaders = request.getHeaders();
        if (requestHeaders == null || requestHeaders.size() == 0) {
            return;
        }
        requestHeaders = new HashMap<String, List<String>>(requestHeaders);
        for (String header : headerNames) {
            List<String> values = requestHeaders.get(header);
            if (values == null || values.size() == 0) continue;
            values = new ArrayList<String>(values);
            values.remove(valueToRemove);
            requestHeaders.put(header, values);
        }
        request.setHeaders(requestHeaders);
    }

    public static void mergeParameters(HttpRequestMessage from, HttpRequestMessage to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Request is null.");
        }
        Map<String, List<String>> fromParameters = from.getParameters();
        if (fromParameters == null || fromParameters.isEmpty()) {
            return;
        }
        if (to.getParameters() == null) {
            to.setParameters(new HashMap<String, List<String>>(fromParameters.size()));
        }
        fromParameters = new HashMap<String, List<String>>(fromParameters);
        HashMap<String, List<String>> toParameters = new HashMap<String, List<String>>(to.getParameters());
        for (String fromParameter : fromParameters.keySet()) {
            if (!toParameters.containsKey(fromParameter)) {
                toParameters.put(fromParameter, fromParameters.get(fromParameter));
                continue;
            }
            List<String> fromValues = fromParameters.get(fromParameter);
            ArrayList toValues = (ArrayList)toParameters.get(fromParameter);
            if (fromValues == null) {
                fromValues = new ArrayList<String>();
            }
            if (toValues == null) {
                toValues = new ArrayList();
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>(fromValues);
            result.addAll(toValues);
            toParameters.put(fromParameter, new ArrayList<String>(result));
        }
        to.setParameters(toParameters);
    }

    public static void mergeCookies(HttpRequestMessage from, HttpRequestMessage to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Request is null.");
        }
        Set<HttpCookie> fromCookies = from.getCookies();
        if (fromCookies == null || fromCookies.isEmpty()) {
            return;
        }
        if (to.getCookies() == null) {
            HashSet<HttpCookie> cookies = new HashSet<HttpCookie>(fromCookies);
            to.setCookies(cookies);
        } else {
            HashSet<HttpCookie> toCookies = new HashSet<HttpCookie>(to.getCookies());
            toCookies.addAll(fromCookies);
            to.setCookies(toCookies);
        }
    }

    public static String mergeQueryParameters(URI from, String into) throws URISyntaxException {
        String query;
        if (into == null) {
            throw new URISyntaxException("<null>", "Cannot merge into a null URI");
        }
        if (from == null) {
            return into;
        }
        String fromQuery = from.getQuery();
        String intoQuery = URIUtils.getQuery((String)into);
        if (intoQuery == null) {
            query = from.getQuery();
        } else if (fromQuery == null) {
            query = intoQuery;
        } else {
            query = intoQuery;
            if (fromQuery.length() > 0) {
                query = query + '&' + fromQuery;
            }
        }
        return URIUtils.buildURIAsString((String)URIUtils.getScheme((String)into), (String)URIUtils.getAuthority((String)into), (String)URIUtils.getPath((String)into), (String)query, (String)URIUtils.getFragment((String)into));
    }

    public static boolean hasStreamingScheme(URI uri) {
        if (uri == null || uri.getScheme() == null) {
            return false;
        }
        String scheme = uri.getScheme();
        return "tcp".equalsIgnoreCase(scheme) || "ssl".equalsIgnoreCase(scheme);
    }

    public static boolean hasStreamingScheme(String uri) {
        if (uri == null || URIUtils.getScheme((String)uri) == null) {
            return false;
        }
        String scheme = URIUtils.getScheme((String)uri);
        return "tcp".equalsIgnoreCase(scheme) || "ssl".equalsIgnoreCase(scheme);
    }

    static {
        RFC822_FORMAT_PATTERN.setTimeZone(TimeZone.getTimeZone("GMT"));
        FORBIDDEN_HEADERS = new String[]{"Accept-Charset", "Accept-Encoding", "Connection", "Content-Length", "Content-Transfer-Encoding", "Date", "Expect", "Host", "Keep-Alive", "Referer", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "Via"};
        EMPTY_HEADERS = new HashMap<String, List<String>>(0);
    }
}

