/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;
import org.slf4j.Logger;

class PersistentConnectionPool {
    private static final String IDLE_FILTER = "http#idle";
    private static final TypedAttributeKey<HttpResourceAddress> SERVER_ADDRESS = new TypedAttributeKey(PersistentConnectionPool.class, "address");
    private final ThreadLocal<ServerConnections> connections = new VicariousThreadLocal<ServerConnections>(){

        protected ServerConnections initialValue() {
            return new ServerConnections();
        }
    };
    private final Logger logger;
    private final HttpConnectIdleFilter idleFilter;
    private final CloseListener closeListener;

    PersistentConnectionPool(Logger logger) {
        this.logger = logger;
        this.idleFilter = new HttpConnectIdleFilter(logger);
        this.closeListener = new CloseListener(this);
    }

    boolean recycle(DefaultHttpSession httpSession) {
        if (!this.add(httpSession)) {
            return false;
        }
        HttpResourceAddress serverAddress = (HttpResourceAddress)httpSession.getRemoteAddress();
        IoSessionEx transportSession = httpSession.getParent();
        SERVER_ADDRESS.set((IoSession)transportSession, (Object)serverAddress);
        CloseFuture closeFuture = transportSession.getCloseFuture();
        closeFuture.addListener((IoFutureListener)this.closeListener);
        transportSession.getFilterChain().addLast(IDLE_FILTER, (IoFilter)this.idleFilter);
        int keepAliveTimeout = (Integer)serverAddress.getOption(HttpResourceAddress.KEEP_ALIVE_TIMEOUT);
        transportSession.getConfig().setBothIdleTime(keepAliveTimeout);
        return true;
    }

    IoSession take(HttpResourceAddress serverAddress) {
        IoSession transportSession = this.removeThreadAligned(serverAddress);
        if (transportSession != null) {
            transportSession.getConfig().setBothIdleTime(0);
            IoFilterChain filterChain = transportSession.getFilterChain();
            if (filterChain.contains(IDLE_FILTER)) {
                filterChain.remove(IDLE_FILTER);
            }
            CloseFuture closeFuture = transportSession.getCloseFuture();
            closeFuture.removeListener((IoFutureListener)this.closeListener);
            SERVER_ADDRESS.remove(transportSession);
        }
        return transportSession;
    }

    private boolean add(DefaultHttpSession httpSession) {
        HttpResourceAddress serverAddress = (HttpResourceAddress)httpSession.getRemoteAddress();
        IoSessionEx transportSession = httpSession.getParent();
        ServerConnections serverConnections = this.connections.get();
        boolean cached = serverConnections.add(serverAddress, (IoSession)transportSession);
        if (cached) {
            if (this.logger.isDebugEnabled()) {
                int cachedConnections = serverConnections.cachedConnections(serverAddress);
                this.logger.debug(String.format("Caching persistent connection: server = %s session = %s pool = %d", serverAddress.getResource(), transportSession, cachedConnections));
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            int cachedConnections = serverConnections.cachedConnections(serverAddress);
            this.logger.debug(String.format("NOT caching persistent connection: server = %s session = %s pool = %d", serverAddress.getResource(), transportSession, cachedConnections));
        }
        return false;
    }

    private void remove(HttpResourceAddress serverAddress, IoSession session) {
        ServerConnections serverConnections = this.connections.get();
        boolean removed = serverConnections.remove(serverAddress, session);
        if (removed && this.logger.isDebugEnabled()) {
            int cachedConnections = serverConnections.cachedConnections(serverAddress);
            this.logger.debug(String.format("Removing cached persistent connection: server = %s session = %s pool = %d", serverAddress.getResource(), session, cachedConnections));
        }
    }

    private IoSession removeThreadAligned(HttpResourceAddress serverAddress) {
        ServerConnections serverConnections = this.connections.get();
        IoSession session = serverConnections.removeAny(serverAddress);
        if (session != null) {
            if (this.logger.isDebugEnabled()) {
                int count = serverConnections.cachedConnections(serverAddress);
                this.logger.debug(String.format("Reusing cached persistent connection: server = %s  session = %s pool = %d", serverAddress.getResource(), session, count));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Cache miss - NO cached persistent connection: server = %s", serverAddress.getResource()));
        }
        return session;
    }

    private static class ServerConnections {
        private final Map<HttpResourceAddress, IoSession[]> addressToConnections = new HashMap<HttpResourceAddress, IoSession[]>();

        private ServerConnections() {
        }

        private boolean add(HttpResourceAddress serverAddress, IoSession session) {
            int maxConnections = (Integer)serverAddress.getOption(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS);
            IoSession[] connections = this.addressToConnections.get(serverAddress);
            if (connections == null) {
                connections = new IoSession[maxConnections];
                this.addressToConnections.put(serverAddress, connections);
            }
            assert (maxConnections == connections.length);
            for (int i = 0; i < connections.length; ++i) {
                if (connections[i] != null) continue;
                connections[i] = session;
                return true;
            }
            return false;
        }

        private boolean remove(HttpResourceAddress serverAddress, IoSession session) {
            IoSession[] connections = this.addressToConnections.get(serverAddress);
            if (connections != null) {
                for (int i = 0; i < connections.length; ++i) {
                    if (connections[i] != session) continue;
                    connections[i] = null;
                    return true;
                }
            }
            return false;
        }

        private IoSession removeAny(HttpResourceAddress serverAddress) {
            IoSession[] connections = this.addressToConnections.get(serverAddress);
            if (connections != null) {
                for (int i = 0; i < connections.length; ++i) {
                    if (connections[i] == null) continue;
                    IoSession session = connections[i];
                    connections[i] = null;
                    return session;
                }
            }
            return null;
        }

        private int cachedConnections(HttpResourceAddress serverAddress) {
            IoSession[] connections = this.addressToConnections.get(serverAddress);
            if (connections != null) {
                return (int)Arrays.stream(connections).filter(Objects::nonNull).count();
            }
            return 0;
        }
    }

    private static class HttpConnectIdleFilter
    extends HttpFilterAdapter<IoSessionEx> {
        private final Logger logger;

        HttpConnectIdleFilter(Logger logger) {
            this.logger = logger;
        }

        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Idle cached persistent connection: session=%s", session));
            }
            session.close(false);
        }
    }

    private static class CloseListener
    implements IoFutureListener<CloseFuture> {
        private final PersistentConnectionPool store;

        CloseListener(PersistentConnectionPool store) {
            this.store = store;
        }

        public void operationComplete(CloseFuture future) {
            IoSessionEx session = (IoSessionEx)future.getSession();
            HttpResourceAddress serverAddress = (HttpResourceAddress)SERVER_ADDRESS.get((IoSession)session);
            this.store.remove(serverAddress, (IoSession)session);
        }
    }
}

