/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.WsProtocol13HandshakeValidator;
import org.kaazing.gateway.transport.http.WsProtocol8HandshakeValidator;
import org.kaazing.gateway.transport.http.WsProtocolHixie75HandshakeValidator;
import org.kaazing.gateway.transport.http.WsProtocolHixie76HandshakeValidator;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.util.ws.WebSocketWireProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsHandshakeValidator {
    public static final String SEC_WEB_SOCKET_KEY = "Sec-WebSocket-Key";
    public static final String SEC_WEB_SOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String SEC_WEB_SOCKET_KEY1 = "Sec-WebSocket-Key1";
    public static final String SEC_WEB_SOCKET_KEY2 = "Sec-WebSocket-Key2";
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final Logger logger = LoggerFactory.getLogger((String)"websocket.handshake.validator");
    public static Map<WebSocketWireProtocol, WsHandshakeValidator> handshakeValidatorsByWireProtocolVersion = new ConcurrentHashMap<WebSocketWireProtocol, WsHandshakeValidator>(10);
    private static boolean initialized;

    public boolean validate(HttpRequestMessage request) {
        return this.validate(request, true);
    }

    public boolean validate(HttpRequestMessage request, boolean isPostMethodAllowed) {
        WebSocketWireProtocol wireProtocolVersion = WsHandshakeValidator.guessWireProtocolVersion(request);
        if (wireProtocolVersion == null) {
            return false;
        }
        WsHandshakeValidator validator = handshakeValidatorsByWireProtocolVersion.get(wireProtocolVersion);
        return validator != null && validator.doValidate(request, isPostMethodAllowed);
    }

    public static WebSocketWireProtocol guessWireProtocolVersion(HttpRequestMessage httpRequest) {
        String httpRequestVersionHeader = httpRequest.getHeader(SEC_WEB_SOCKET_VERSION);
        if (httpRequestVersionHeader == null || httpRequestVersionHeader.length() == 0) {
            if (httpRequest.getHeader(SEC_WEB_SOCKET_KEY1) != null && httpRequest.getHeader(SEC_WEB_SOCKET_KEY2) != null) {
                return WebSocketWireProtocol.HIXIE_76;
            }
            return WebSocketWireProtocol.HIXIE_75;
        }
        try {
            return WebSocketWireProtocol.valueOf((int)Integer.parseInt(httpRequestVersionHeader));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected boolean doValidate(HttpRequestMessage request, boolean isPostMethodAllowed) {
        if (!isPostMethodAllowed ? request.getMethod() != HttpMethod.GET : request.getMethod() != HttpMethod.GET || request.getMethod() == HttpMethod.POST) {
            return false;
        }
        if (request.getVersion() != HttpVersion.HTTP_1_1) {
            return false;
        }
        if (request.getRequestURI() == null) {
            return false;
        }
        boolean ok = this.requireHeader(request, "Connection", "Upgrade");
        if (!ok) {
            return false;
        }
        ok = this.requireHeader(request, "Upgrade", "WebSocket");
        if (!ok) {
            return false;
        }
        ok = this.requireHeader(request, "Host");
        return ok;
    }

    public boolean requireHeader(HttpRequestMessage request, String name) {
        if (request == null || name == null) {
            return false;
        }
        List<String> headers = request.getHeaderValues(name, false);
        if (headers != null) {
            boolean found = false;
            for (String header : headers) {
                if (header == null || header.trim().length() <= 0) continue;
                found = true;
            }
            return found;
        }
        return false;
    }

    public boolean requireHeader(HttpRequestMessage request, String name, String value) {
        if (request == null || name == null || value == null) {
            return false;
        }
        List<String> headers = request.getHeaderValues(name, false);
        if (headers != null) {
            boolean found = false;
            for (String header : headers) {
                if (header == null || !header.trim().equalsIgnoreCase(value)) continue;
                found = true;
            }
            return found;
        }
        return false;
    }

    private void register(WebSocketWireProtocol wireProtocolVersion, WsHandshakeValidator validator) {
        if (wireProtocolVersion == null) {
            throw new NullPointerException("wireProtocolVersion");
        }
        if (validator == null) {
            throw new NullPointerException("validator");
        }
        WsHandshakeValidator existingValidator = handshakeValidatorsByWireProtocolVersion.put(wireProtocolVersion, validator);
        this.logger.trace("Class " + validator.getClass().getName() + " registered to support websocket handshake for protocol " + wireProtocolVersion);
        if (existingValidator != null) {
            this.logger.trace("Multiple handshake validators have registered to support wire protocol " + wireProtocolVersion + ". Using class " + this.getClass().getName() + '.');
        }
    }

    public boolean isInitialized() {
        return initialized;
    }

    public synchronized void init() {
        if (!initialized) {
            this.register(WebSocketWireProtocol.HIXIE_75, new WsProtocolHixie75HandshakeValidator());
            this.register(WebSocketWireProtocol.HIXIE_76, new WsProtocolHixie76HandshakeValidator());
            this.register(WebSocketWireProtocol.HYBI_8, new WsProtocol8HandshakeValidator());
            this.register(WebSocketWireProtocol.HYBI_13, new WsProtocol13HandshakeValidator());
            this.register(WebSocketWireProtocol.RFC_6455, new WsProtocol13HandshakeValidator());
            initialized = true;
        }
    }
}

