/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import org.apache.mina.util.Base64;
import org.kaazing.gateway.transport.http.WsHandshakeValidator;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;

public class WsProtocol8HandshakeValidator
extends WsHandshakeValidator {
    @Override
    protected boolean doValidate(HttpRequestMessage request, boolean isPostMethodAllowed) {
        boolean ok = super.doValidate(request, isPostMethodAllowed);
        if (!ok) {
            return false;
        }
        ok = this.requireHeader(request, "Sec-WebSocket-Version", this.getExpectedWebSocketVersion());
        if (!ok) {
            return false;
        }
        ok = this.requireHeader(request, "Sec-WebSocket-Key");
        return ok && this.validateWebSocketKey(request.getHeader("Sec-WebSocket-Key"));
    }

    protected String getExpectedWebSocketVersion() {
        return "8";
    }

    public boolean validateWebSocketKey(String key) {
        if (key == null) {
            return false;
        }
        byte[] bytes = key.getBytes(UTF_8);
        byte[] decodedKey = Base64.decodeBase64((byte[])bytes);
        return decodedKey.length == 16;
    }
}

