/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.EnumSet;
import java.util.Set;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBufferAllocator;
import org.kaazing.gateway.transport.http.bridge.filter.HttpEncoding;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.buffer.SimpleBufferAllocator;

public class HttpContentMessage
extends HttpMessage {
    private static final EnumSet<HttpContentInfo> CONTENT_INFO_NONE = EnumSet.noneOf(HttpContentInfo.class);
    private static final EnumSet<HttpContentInfo> CONTENT_INFO_COMPLETE = EnumSet.of(HttpContentInfo.COMPLETE);
    private static final EnumSet<HttpEncoding> ENCODING_NONE = EnumSet.noneOf(HttpEncoding.class);
    private static final EnumSet<HttpEncoding> ENCODING_GZIPPED_ONLY = EnumSet.of(HttpEncoding.GZIPPED);
    private static final EnumSet<HttpEncoding> ENCODING_CHUNKED_ONLY = EnumSet.of(HttpEncoding.CHUNKED);
    private static final EnumSet<HttpEncoding> ENCODING_CHUNKED_AND_GZIPPED = EnumSet.of(HttpEncoding.CHUNKED, HttpEncoding.GZIPPED);
    private static HttpBufferAllocator httpAllocator = new HttpBufferAllocator((IoBufferAllocatorEx<?>)SimpleBufferAllocator.BUFFER_ALLOCATOR);
    public static final HttpContentMessage EMPTY = new HttpContentMessage((IoBufferEx)httpAllocator.wrap(httpAllocator.allocate(0)), true);
    public static final HttpContentMessage FLUSH = new HttpContentMessage((IoBufferEx)httpAllocator.wrap(httpAllocator.allocate(0)), true);
    private final IoBufferEx data;
    private final Set<HttpEncoding> encodings;
    private final Set<HttpContentInfo> contentInfos;

    public HttpContentMessage(IoBufferEx data, boolean complete) {
        this(data, HttpContentMessage.asContentInfos(complete), ENCODING_NONE);
    }

    public HttpContentMessage(IoBufferEx data, boolean complete, boolean chunked, boolean gzipped) {
        this(data, HttpContentMessage.asContentInfos(complete), HttpContentMessage.asEncodings(chunked, gzipped));
    }

    private HttpContentMessage(IoBufferEx data, Set<HttpContentInfo> contentInfos, Set<HttpEncoding> encodings) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
        if (contentInfos == null) {
            throw new NullPointerException("contentInfos");
        }
        if (encodings == null) {
            throw new NullPointerException("encodings");
        }
        this.contentInfos = contentInfos;
        this.encodings = encodings;
    }

    @Override
    public HttpMessage.Kind getKind() {
        return HttpMessage.Kind.CONTENT;
    }

    public IoBufferEx asBuffer() {
        return this.data;
    }

    @Deprecated
    public String asText(CharsetDecoder decoder) throws CharacterCodingException {
        return this.data.slice().getString(decoder);
    }

    public int length() {
        return this.data.remaining();
    }

    @Override
    public boolean isComplete() {
        return this.contentInfos.contains((Object)HttpContentInfo.COMPLETE);
    }

    public boolean isInjected() {
        return this.contentInfos.contains((Object)HttpContentInfo.INJECTED);
    }

    public final boolean isChunked() {
        return this.encodings.contains((Object)HttpEncoding.CHUNKED);
    }

    public final boolean isGzipped() {
        return this.encodings.contains((Object)HttpEncoding.GZIPPED);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof HttpContentMessage)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        HttpContentMessage that = (HttpContentMessage)((Object)o);
        return that.data.equals(this.data) && that.contentInfos.equals(this.contentInfos) && that.encodings.equals(this.encodings);
    }

    public int hashCode() {
        int result = 17;
        result <<= 8;
        result ^= this.data.hashCode();
        result <<= 8;
        result ^= this.contentInfos.hashCode();
        result <<= 8;
        return result ^= this.encodings.hashCode();
    }

    public String toString() {
        return String.format("%s: %s %s%s%s", new Object[]{this.getKind(), this.data, this.isChunked() ? "[CHUNKED]" : "", this.isGzipped() ? "[GZIPPED]" : "", this.isComplete() ? "" : "[...]"});
    }

    private static Set<HttpContentInfo> asContentInfos(boolean complete) {
        if (complete) {
            return CONTENT_INFO_COMPLETE;
        }
        return CONTENT_INFO_NONE;
    }

    private static Set<HttpEncoding> asEncodings(boolean chunked, boolean gzipped) {
        if (chunked && gzipped) {
            return ENCODING_CHUNKED_AND_GZIPPED;
        }
        if (chunked) {
            return ENCODING_CHUNKED_ONLY;
        }
        if (gzipped) {
            return ENCODING_GZIPPED_ONLY;
        }
        return ENCODING_NONE;
    }

    private static enum HttpContentInfo {
        INJECTED,
        COMPLETE;

    }
}

