/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.security.auth.context.ResultAwareLoginContext;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.bridge.HttpHeaderNameComparator;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpStartMessage;

public class HttpRequestMessage
extends HttpStartMessage {
    private static final Map<String, List<String>> EMPTY_PARAMETERS = Collections.emptyMap();
    private boolean secure;
    private Map<String, List<String>> parameters;
    private URI requestURI;
    private HttpMethod method;
    private ResourceAddress localAddress;
    private Subject subject;
    private ResultAwareLoginContext loginContext;
    private String externalURI;
    private QueryUpdate queryUpdate;

    @Override
    public HttpMessage.Kind getKind() {
        return HttpMessage.Kind.REQUEST;
    }

    public ResultAwareLoginContext getLoginContext() {
        return this.loginContext;
    }

    public void setLoginContext(ResultAwareLoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public void setLocalAddress(ResourceAddress localAddress) {
        this.localAddress = localAddress;
    }

    public ResourceAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setExternalURI(String externalURI) {
        this.externalURI = externalURI;
    }

    public String getExternalURI() {
        return this.externalURI;
    }

    public String getParameter(String parameterName) {
        List<String> parameterValues = this.getParameterValues(parameterName, false);
        if (parameterValues == null || parameterValues.isEmpty()) {
            return null;
        }
        return parameterValues.get(0);
    }

    public List<String> getParameterValues(String parameterName) {
        return this.getParameterValues(parameterName, false);
    }

    public void addParameter(String parameterName, String parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue");
        }
        List<String> parameterValues = this.getParameterValues(parameterName, true);
        parameterValues.add(parameterValue);
    }

    public void clearParameters() {
        Map<String, List<String>> parameters = this.getParameters(false);
        if (parameters != null) {
            parameters.clear();
            this.queryUpdate = QueryUpdate.ENCODE;
        }
    }

    public String removeParameter(String parameterName) {
        List<String> parameterValues;
        Map<String, List<String>> parameters = this.getParameters(false);
        if (parameters != null && (parameterValues = parameters.remove(parameterName)) != null && !parameterValues.isEmpty()) {
            this.queryUpdate = QueryUpdate.ENCODE;
            return parameterValues.get(0);
        }
        return null;
    }

    public void setParameter(String parameterName, String parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue");
        }
        List<String> parameterValues = this.getParameterValues(parameterName, true);
        parameterValues.clear();
        parameterValues.add(parameterValue);
    }

    public void setParameters(Map<String, List<String>> newParameters) {
        Map<String, List<String>> parameters = this.getParameters(true);
        parameters.clear();
        parameters.putAll(newParameters);
    }

    public Map<String, List<String>> getParameters() {
        Map<String, List<String>> parameters = this.getParameters(false);
        return parameters != null && !parameters.isEmpty() ? Collections.unmodifiableMap(parameters) : EMPTY_PARAMETERS;
    }

    public void setRequestURI(URI requestURI) {
        this.requestURI = requestURI;
        Map<String, List<String>> parameters = this.getParameters(false);
        if (parameters != null) {
            parameters.clear();
        }
        if (requestURI != null && requestURI.getQuery() != null) {
            this.queryUpdate = QueryUpdate.DECODE;
        }
    }

    public URI getRequestURI() {
        if (this.queryUpdate == QueryUpdate.ENCODE) {
            this.queryUpdate = null;
            Map<String, List<String>> parameters = this.getParameters(false);
            if (parameters != null && !parameters.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                if (this.requestURI != null) {
                    sb.append(this.requestURI.getPath());
                }
                sb.append('?');
                int baseSize = sb.length();
                for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                    String parameterName = entry.getKey();
                    List<String> parameterValues = entry.getValue();
                    if (parameterValues == null) continue;
                    for (String parameterValue : parameterValues) {
                        if (sb.length() > baseSize) {
                            sb.append('&');
                        }
                        sb.append(URLEncoder.encode(parameterName));
                        sb.append('=');
                        if (parameterValue == null) continue;
                        sb.append(URLEncoder.encode(parameterValue));
                    }
                }
                if (sb.length() > 1) {
                    URI relativeURI = URI.create(sb.toString());
                    this.requestURI = this.requestURI != null ? this.requestURI.resolve(relativeURI) : relativeURI;
                }
            } else {
                this.requestURI = this.requestURI.resolve(this.requestURI.getPath());
            }
        }
        return this.requestURI;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        return String.format("%s: %s %s %s %s %s", new Object[]{this.getKind(), this.getVersion(), this.getMethod(), this.getRequestURI(), this.getContent(), this.isComplete() ? "" : " [...]"});
    }

    public String toVerboseString() {
        return String.format("%s: %s %s %s HEADERS: %s %s %s", new Object[]{this.getKind(), this.getVersion(), this.getMethod(), this.getRequestURI(), this.getHeaders(), this.getContent(), this.isComplete() ? "" : " [...]"});
    }

    @Override
    public int hashCode() {
        if (this.queryUpdate != null) {
            this.getRequestURI();
            this.getParameters();
        }
        int hashCode = super.hashCode();
        if (this.secure) {
            hashCode ^= Boolean.valueOf(this.secure).hashCode();
        }
        if (this.parameters != null) {
            hashCode ^= this.parameters.hashCode();
        }
        if (this.requestURI != null) {
            hashCode ^= this.requestURI.hashCode();
        }
        if (this.method != null) {
            hashCode ^= this.method.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpRequestMessage)) {
            return false;
        }
        return this.equals((HttpRequestMessage)((Object)o));
    }

    protected boolean equals(HttpRequestMessage that) {
        if (this.queryUpdate != null) {
            this.getRequestURI();
            this.getParameters();
        }
        if (that.queryUpdate != null) {
            that.getRequestURI();
            that.getParameters();
        }
        return super.equals(that) && this.secure == that.secure && HttpRequestMessage.sameOrEquals((Object)this.method, (Object)that.method) && HttpRequestMessage.sameOrEquals(this.requestURI, that.requestURI) && HttpRequestMessage.sameOrEquals(this.parameters, that.parameters);
    }

    @Override
    protected Map<String, List<String>> createHeaders() {
        return new TreeMap<String, List<String>>(HttpHeaderNameComparator.INSTANCE);
    }

    private Map<String, List<String>> getParameters(boolean createIfNull) {
        if (this.parameters == null && (createIfNull || this.queryUpdate == QueryUpdate.DECODE)) {
            this.parameters = new LinkedHashMap<String, List<String>>();
        }
        if (this.queryUpdate == QueryUpdate.DECODE) {
            this.queryUpdate = null;
            String query = this.requestURI.getRawQuery();
            if (query != null) {
                String[] nvPairs;
                for (String nvPair : nvPairs = query.split("&")) {
                    int equalAt = nvPair.indexOf(61);
                    if (equalAt != -1) {
                        String parameterName = nvPair.substring(0, equalAt);
                        String parameterValue = nvPair.substring(equalAt + 1);
                        this.addParameter(URLDecoder.decode(parameterName), URLDecoder.decode(parameterValue));
                        continue;
                    }
                    this.addParameter(URLDecoder.decode(nvPair), "");
                }
            }
            this.queryUpdate = null;
        }
        if (createIfNull) {
            this.queryUpdate = QueryUpdate.ENCODE;
        }
        return this.parameters;
    }

    private List<String> getParameterValues(String parameterName, boolean createIfNull) {
        Map<String, List<String>> parameters = this.getParameters(createIfNull);
        if (parameters == null) {
            return null;
        }
        List<String> parameterValues = parameters.get(parameterName);
        if (parameterValues == null && createIfNull) {
            parameterValues = new ArrayList<String>();
            parameters.put(parameterName, parameterValues);
        }
        return parameterValues;
    }

    private static enum QueryUpdate {
        DECODE,
        ENCODE;

    }
}

