/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kaazing.gateway.resource.address.http.HttpInjectableHeader;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpStartMessage;

public class HttpResponseMessage
extends HttpStartMessage {
    private static final Set<HttpInjectableHeader> EMPTY_INJECTABLE_HEADERS = Collections.emptySet();
    private HttpStatus status;
    private String reason;
    private String bodyReason;
    private Set<HttpInjectableHeader> injectableHeaders = EMPTY_INJECTABLE_HEADERS;
    private boolean contentExcluded;
    private boolean blockPadding;
    private static Comparator<String> COMPARE_IGNORE_CASE = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };

    @Override
    public HttpMessage.Kind getKind() {
        return HttpMessage.Kind.RESPONSE;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getReason() {
        return this.reason == null && this.status != null ? this.status.reason() : this.reason;
    }

    public String getBodyReason() {
        return this.bodyReason == null ? this.getReason() : this.bodyReason;
    }

    public boolean isContentExcluded() {
        return this.contentExcluded;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Set<HttpInjectableHeader> getInjectableHeaders() {
        return this.injectableHeaders;
    }

    public void setInjectableHeaders(Set<HttpInjectableHeader> injectableHeaders) {
        if (injectableHeaders == null) {
            throw new NullPointerException("injectableHeaders");
        }
        this.injectableHeaders = injectableHeaders;
    }

    public void setBodyReason(String bodyReason) {
        this.bodyReason = bodyReason;
    }

    public void setStatus(HttpStatus status) {
        this.status = status;
    }

    public void setContentExcluded(boolean value) {
        this.contentExcluded = value;
    }

    public void setBlockPadding(boolean blockPadding) {
        this.blockPadding = blockPadding;
    }

    public boolean isBlockPadding() {
        return this.blockPadding;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.status != null) {
            hashCode ^= this.status.hashCode();
        }
        if (this.reason != null) {
            hashCode ^= this.reason.hashCode();
        }
        if (this.bodyReason != null) {
            hashCode ^= this.bodyReason.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpResponseMessage)) {
            return false;
        }
        return this.equals((HttpResponseMessage)((Object)o));
    }

    protected boolean equals(HttpResponseMessage that) {
        return super.equals(that) && this.contentExcluded == that.contentExcluded && HttpResponseMessage.sameOrEquals(this.bodyReason, that.bodyReason) && HttpResponseMessage.sameOrEquals(this.reason, that.reason) && HttpResponseMessage.sameOrEquals((Object)this.status, (Object)that.status);
    }

    public String toString() {
        return String.format("%s: %s %s %s %s %s", new Object[]{this.getKind(), this.getStatus(), this.getReason(), this.getVersion(), this.getContent(), this.isComplete() ? "" : " [...]"});
    }

    public String toVerboseString() {
        return String.format("%s: %s %s %s HEADERS: %s %s %s", new Object[]{this.getKind(), this.getStatus(), this.getReason(), this.getVersion(), this.getHeaders(), this.getContent(), this.isComplete() ? "" : " [...]"});
    }

    @Override
    protected Map<String, List<String>> createHeaders() {
        return new TreeMap<String, List<String>>(COMPARE_IGNORE_CASE);
    }
}

