/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpCookieComparator;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;

public abstract class HttpStartMessage
extends HttpMessage {
    private static final Map<String, List<String>> EMPTY_HEADERS = Collections.emptyMap();
    private static final Set<String> EMPTY_HEADER_NAMES = Collections.emptySet();
    private static final List<String> EMPTY_HEADER = Collections.emptyList();
    private static final Set<HttpCookie> EMPTY_COOKIES = Collections.emptySet();
    private Set<HttpCookie> cookies;
    private Map<String, List<String>> headers;
    private HttpVersion version;
    private HttpContentMessage content = null;
    private boolean contentLengthImplicit;

    @Override
    public boolean isComplete() {
        return this.content == null || this.content.isComplete();
    }

    public boolean isContentLengthImplicit() {
        return this.contentLengthImplicit;
    }

    public void setContentLengthImplicit(boolean contentLengthImplicit) {
        this.contentLengthImplicit = contentLengthImplicit;
    }

    public boolean hasCookies() {
        return this.cookies != null && !this.cookies.isEmpty();
    }

    public Iterator<HttpCookie> iterateCookies() {
        return this.cookies != null ? this.cookies.iterator() : EMPTY_COOKIES.iterator();
    }

    public Set<HttpCookie> getCookies() {
        Set<HttpCookie> cookies = this.getCookies(false);
        return cookies != null && !cookies.isEmpty() ? Collections.unmodifiableSet(cookies) : EMPTY_COOKIES;
    }

    public void addCookie(HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        Set<HttpCookie> cookies = this.getCookies(true);
        cookies.add(cookie);
    }

    public void removeCookie(HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        Set<HttpCookie> cookies = this.getCookies(false);
        if (cookies != null) {
            cookies.remove(cookie);
        }
    }

    public void clearCookies() {
        Set<HttpCookie> cookies = this.getCookies(false);
        if (cookies != null) {
            cookies.clear();
        }
    }

    public void setCookies(Collection<HttpCookie> newCookies) {
        Set<HttpCookie> cookies = this.getCookies(true);
        cookies.clear();
        cookies.addAll(newCookies);
    }

    public void setHeader(String headerName, String headerValue) {
        if (headerName == null) {
            throw new NullPointerException("headerName");
        }
        if (headerValue == null) {
            throw new NullPointerException("headerValue");
        }
        List<String> headerValues = this.getHeaderValues(headerName, true);
        headerValues.clear();
        headerValues.add(headerValue);
    }

    public void addHeader(String headerName, String headerValue) {
        if (headerName == null) {
            throw new NullPointerException("headerName");
        }
        if (headerValue == null) {
            throw new NullPointerException("headerValue");
        }
        List<String> headerValues = this.getHeaderValues(headerName, true);
        headerValues.add(headerValue);
    }

    public List<String> removeHeader(String headerName) {
        Map<String, List<String>> headers = this.getHeaders(false);
        if (headers != null) {
            return headers.remove(headerName);
        }
        return EMPTY_HEADER;
    }

    public void clearHeaders() {
        Map<String, List<String>> headers = this.getHeaders(false);
        if (headers != null) {
            headers.clear();
        }
    }

    public void setHeaders(Map<String, List<String>> newHeaders) {
        Map<String, List<String>> headers = this.getHeaders(true);
        headers.clear();
        headers.putAll(newHeaders);
    }

    public void putHeaders(Map<String, List<String>> newHeaders) {
        Map<String, List<String>> headers = this.getHeaders(true);
        headers.putAll(newHeaders);
    }

    public Iterator<String> iterateHeaderNames() {
        return this.headers != null && !this.headers.isEmpty() ? this.headers.keySet().iterator() : EMPTY_HEADER_NAMES.iterator();
    }

    public Set<String> getHeaderNames() {
        Map<String, List<String>> headers = this.getHeaders(false);
        return headers != null && !headers.isEmpty() ? Collections.unmodifiableSet(headers.keySet()) : EMPTY_HEADER_NAMES;
    }

    public Map<String, List<String>> getHeaders() {
        Map<String, List<String>> headers = this.getHeaders(false);
        return headers != null && !headers.isEmpty() ? Collections.unmodifiableMap(headers) : EMPTY_HEADERS;
    }

    public Map<String, List<String>> getModifiableHeaders() {
        Map<String, List<String>> headers = this.getHeaders(false);
        return headers != null && !headers.isEmpty() ? headers : EMPTY_HEADERS;
    }

    public List<String> getHeaderValues(String headerName) {
        return this.getHeaderValues(headerName, true);
    }

    public String getHeader(String headerName) {
        List<String> headerValues = this.getHeaderValues(headerName, false);
        if (headerValues == null) {
            return null;
        }
        return headerValues.isEmpty() ? null : headerValues.get(0);
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public boolean hasHeader(String headerName) {
        return this.headers != null && this.headers.containsKey(headerName);
    }

    public void setVersion(HttpVersion version) {
        this.version = version;
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public void setContent(HttpContentMessage content) {
        this.content = content;
    }

    public HttpContentMessage getContent() {
        return this.content;
    }

    private Set<HttpCookie> getCookies(boolean createIfNull) {
        if (this.cookies == null && createIfNull) {
            this.cookies = new TreeSet<HttpCookie>(HttpCookieComparator.INSTANCE);
        }
        return this.cookies;
    }

    private Map<String, List<String>> getHeaders(boolean createIfNull) {
        if (this.headers == null && createIfNull) {
            this.headers = this.createHeaders();
        }
        return this.headers;
    }

    protected abstract Map<String, List<String>> createHeaders();

    public List<String> getHeaderValues(String headerName, boolean createIfNull) {
        Map<String, List<String>> headers = this.getHeaders(createIfNull);
        if (headers == null) {
            return null;
        }
        List<String> headerValues = headers.get(headerName);
        if (headerValues == null && createIfNull) {
            headerValues = new LinkedList<String>();
            headers.put(headerName, headerValues);
        }
        return headerValues;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.version != null) {
            hashCode ^= this.version.hashCode();
        }
        if (this.headers != null) {
            hashCode ^= this.headers.hashCode();
        }
        if (this.cookies != null) {
            hashCode ^= this.cookies.hashCode();
        }
        if (this.content != null) {
            hashCode ^= this.content.hashCode();
        }
        return hashCode;
    }

    protected boolean equals(HttpStartMessage that) {
        return HttpStartMessage.sameOrEquals((Object)this.version, (Object)that.version) && HttpStartMessage.sameOrEquals(this.headers, that.headers) && HttpStartMessage.sameOrEquals(this.cookies, that.cookies) && HttpStartMessage.sameOrEquals((Object)this.content, (Object)that.content);
    }

    static boolean sameOrEquals(Object this_, Object that) {
        return this_ == that || this_ != null && this_.equals(that);
    }

    public static <K, V> boolean sameOrEquals(Map<K, V> this_, Map<K, V> that) {
        return this_ == that || this_ == null && that.isEmpty() || that == null && this_.isEmpty() || this_ != null && this_.equals(that);
    }

    static <T> boolean sameOrEquals(Collection<T> this_, Collection<T> that) {
        return this_ == that || this_ == null && that.isEmpty() || that == null && this_.isEmpty() || this_ != null && this_.equals(that);
    }
}

