/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.transport.SuspendableIoFilterAdapter;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.slf4j.Logger;

public abstract class HttpBaseSecurityFilter
extends SuspendableIoFilterAdapter {
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    protected static final Subject SUBJECT_FORBIDDEN = new Subject();
    public static final String AUTHORIZATION_MODE_CHALLENGE = "challenge";
    protected final Logger logger;
    public static final String AUTH_SCHEME_BASIC = "Basic";
    public static final String AUTH_SCHEME_NEGOTIATE = "Negotiate";
    public static final String AUTH_SCHEME_APPLICATION_TOKEN = "Application Token";

    public HttpBaseSecurityFilter() {
        this(null);
    }

    public HttpBaseSecurityFilter(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void writeResponse(HttpStatus httpStatus, String httpBodyReason, IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest) {
        HttpResponseMessage httpResponse = new HttpResponseMessage();
        httpResponse.setVersion(httpRequest.getVersion());
        httpResponse.setStatus(httpStatus);
        if (httpBodyReason != null) {
            httpResponse.setBodyReason(httpBodyReason);
        }
        nextFilter.filterWrite(session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx(session)));
    }

    protected void writeResponse(HttpStatus httpStatus, IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest) {
        this.writeResponse(httpStatus, null, nextFilter, session, httpRequest);
    }

    protected void writeChallenge(HttpResponseMessage httpResponse, IoFilter.NextFilter nextFilter, IoSession session, String httpChallengeScheme) {
        if (this.logger != null && this.logger.isTraceEnabled()) {
            this.logger.trace("Sending HTTP challenge for auth scheme {}", (Object)httpChallengeScheme);
        }
        nextFilter.filterWrite(session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx(session)));
    }

    protected Collection<String> getAuthorizedRoles(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        HashSet<String> authorizedRoles = new HashSet<String>();
        for (Principal principal : principals) {
            authorizedRoles.add(principal.getName());
        }
        return authorizedRoles;
    }

    protected boolean loggerEnabled() {
        return this.logger != null && this.logger.isTraceEnabled();
    }

    protected boolean httpRequestMessageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (HttpMessage.Kind.REQUEST != ((HttpMessage)((Object)message)).getKind()) {
            super.doMessageReceived(nextFilter, session, message);
            return false;
        }
        assert (HttpMessage.Kind.REQUEST == ((HttpMessage)((Object)message)).getKind());
        return true;
    }
}

