/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kaazing.gateway.transport.bridge.MessageBuffer;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;

public abstract class HttpBuffer
extends MessageBuffer<HttpMessage> {
    private final ConcurrentMap<String, HttpMessage> messages = new ConcurrentHashMap<String, HttpMessage>();

    HttpBuffer(MessageBuffer<HttpMessage> parent, ByteBuffer buf) {
        super(parent, buf);
    }

    HttpBuffer(ByteBuffer buf) {
        super(buf);
    }

    HttpBuffer(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public final HttpMessage getMessage() {
        throw new Error("Use keyed getMessage()");
    }

    public final boolean setMessage(HttpMessage newMessage) {
        throw new Error("Use keyed setMessage()");
    }

    public HttpMessage getMessage(String key) {
        return (HttpMessage)((Object)this.messages.get(key));
    }

    public HttpMessage putMessage(String key, HttpMessage newMessage) {
        HttpMessage oldMessage = this.messages.putIfAbsent(key, newMessage);
        return oldMessage != null ? oldMessage : newMessage;
    }

    public static String getEncodingKey(boolean isGzipped, boolean isChunked) {
        return isChunked ? (isGzipped ? "CHUNKED_GZIPPED" : "CHUNKED") : (isGzipped ? "GZIPPED" : "NONE");
    }

    static final class HttpUnsharedBuffer
    extends HttpBuffer {
        HttpUnsharedBuffer(ByteBuffer buf) {
            super(buf);
        }

        HttpUnsharedBuffer(MessageBuffer<HttpMessage> parent, ByteBuffer buf) {
            super(parent, buf);
        }

        public int flags() {
            return 0;
        }

        protected HttpSharedBuffer asSharedBuffer0() {
            return new HttpSharedBuffer(this.buf());
        }

        protected HttpUnsharedBuffer asUnsharedBuffer0() {
            return this;
        }

        protected HttpBuffer create0(MessageBuffer<HttpMessage> parent, ByteBuffer buf) {
            return new HttpUnsharedBuffer(parent, buf);
        }
    }

    static final class HttpSharedBuffer
    extends HttpBuffer {
        HttpSharedBuffer(ByteBuffer buf) {
            super(buf);
        }

        HttpSharedBuffer(MessageBuffer<HttpMessage> parent, ByteBuffer buf) {
            super(parent, buf);
        }

        public int flags() {
            return 2;
        }

        protected HttpSharedBuffer asSharedBuffer0() {
            return this;
        }

        protected HttpUnsharedBuffer asUnsharedBuffer0() {
            return new HttpUnsharedBuffer(this.buf());
        }

        protected HttpBuffer create0(MessageBuffer<HttpMessage> parent, ByteBuffer buf) {
            return new HttpSharedBuffer(parent, buf);
        }
    }
}

