/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.ByteBuffer;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBuffer;
import org.kaazing.mina.core.buffer.AbstractIoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;

public final class HttpBufferAllocator
extends AbstractIoBufferAllocatorEx<HttpBuffer> {
    private final IoBufferAllocatorEx<?> parent;

    public HttpBufferAllocator(IoBufferAllocatorEx<?> parent) {
        this.parent = parent;
    }

    public ByteBuffer allocate(int capacity, int flags) {
        boolean offset;
        boolean bl = offset = (flags & 8) != 0;
        if (offset) {
            int frameOffset = 15;
            int framePadding = 7;
            ByteBuffer buf = this.parent.allocate(frameOffset + capacity + framePadding, flags);
            buf.position(buf.position() + frameOffset);
            buf.limit(buf.position() + capacity);
            assert (buf.remaining() == capacity);
            return buf;
        }
        return this.parent.allocate(capacity, flags);
    }

    public HttpBuffer wrap(ByteBuffer nioBuffer, int flags) {
        boolean shared = (flags & 2) != 0;
        return shared ? new HttpBuffer.HttpSharedBuffer(nioBuffer) : new HttpBuffer.HttpUnsharedBuffer(nioBuffer);
    }
}

