/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.CrLfDecodingState;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.apache.mina.filter.codec.statemachine.SkippingState;
import org.kaazing.gateway.transport.DecodingStateMachine;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.filter.codec.statemachine.ConsumeToCrLfDecodingState;
import org.kaazing.mina.filter.codec.statemachine.FixedLengthDecodingState;

public abstract class HttpChunkDecodingState
extends DecodingStateMachine {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final CharsetDecoder asciiDecoder = US_ASCII.newDecoder();
    private final DecodingState READ_CHUNK_LENGTH = new ConsumeToCrLfDecodingState(this.allocator){

        protected DecodingState finishDecode(IoBuffer product, ProtocolDecoderOutput out) throws Exception {
            int chunkLength;
            if (!product.hasRemaining()) {
                throw new ProtocolDecoderException("Expected a chunk length");
            }
            String length = product.getString(HttpChunkDecodingState.this.asciiDecoder);
            int semiAt = length.indexOf(59);
            if (semiAt != -1) {
                length = length.substring(0, semiAt);
            }
            if ((chunkLength = Integer.parseInt(length, 16)) <= 0) {
                IoBufferEx unsharedEmpty = HttpChunkDecodingState.this.allocator.wrap(HttpChunkDecodingState.this.allocator.allocate(0));
                out.write((Object)unsharedEmpty);
                return HttpChunkDecodingState.this.FIND_END_OF_TRAILER;
            }
            return new FixedLengthDecodingState(HttpChunkDecodingState.this.allocator, chunkLength){

                protected DecodingState finishDecode(IoBuffer readData, ProtocolDecoderOutput out) throws Exception {
                    out.write((Object)readData);
                    return HttpChunkDecodingState.this.AFTER_CHUNK_DATA;
                }
            };
        }
    };
    private final DecodingState AFTER_CHUNK_DATA = new CrLfDecodingState(){

        protected DecodingState finishDecode(boolean foundCRLF, ProtocolDecoderOutput out) throws Exception {
            if (!foundCRLF) {
                throw new ProtocolDecoderException("Expected CRLF after a chunk data");
            }
            return null;
        }
    };
    private final DecodingState FIND_END_OF_TRAILER = new CrLfDecodingState(){

        protected DecodingState finishDecode(boolean foundCRLF, ProtocolDecoderOutput out) throws Exception {
            if (foundCRLF) {
                return null;
            }
            return HttpChunkDecodingState.this.SKIP_ENTITY_HEADER;
        }
    };
    private final DecodingState SKIP_ENTITY_HEADER = new SkippingState(){

        protected boolean canSkip(byte b) {
            return b != 13;
        }

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            return HttpChunkDecodingState.this.AFTER_SKIP_ENTITY_HEADER;
        }
    };
    private final DecodingState AFTER_SKIP_ENTITY_HEADER = new CrLfDecodingState(){

        protected DecodingState finishDecode(boolean foundCRLF, ProtocolDecoderOutput out) throws Exception {
            return HttpChunkDecodingState.this.FIND_END_OF_TRAILER;
        }
    };

    HttpChunkDecodingState(IoBufferAllocatorEx<?> allocator) {
        super(allocator);
    }

    protected void destroy() throws Exception {
    }

    protected DecodingState init() throws Exception {
        return this.READ_CHUNK_LENGTH;
    }
}

