/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.ByteBuffer;
import org.kaazing.gateway.transport.http.bridge.filter.HttpContentWriter;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

public class HttpChunkedEncoder
implements HttpContentWriter {
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();
    public static final int CHUNKED_MAX_PREFIX_SIZE = 12;

    @Override
    public IoBufferEx write(IoBufferEx source, IoBufferAllocatorEx<?> allocator) {
        return HttpChunkedEncoder.writeChunked(source, allocator);
    }

    public int requiredPrefix(IoBufferEx buffer) {
        int remaining = buffer.remaining();
        String hexRemaining = Integer.toHexString(remaining);
        return hexRemaining.length() + 2;
    }

    private static IoBufferEx writeChunked(IoBufferEx buffer, IoBufferAllocatorEx<?> allocator) {
        int remaining = buffer.remaining();
        byte[] hexRemaining = Integer.toHexString(remaining).getBytes();
        int frameOffset = hexRemaining.length + 2;
        int framePadding = 2;
        if (buffer.position() >= frameOffset && buffer.capacity() - buffer.limit() >= framePadding) {
            buffer.skip(-frameOffset);
            buffer.limit(buffer.limit() + framePadding);
            int pos = buffer.position();
            if (remaining > 0) {
                buffer.put(hexRemaining);
                buffer.put(CRLF_BYTES);
                buffer.skip(remaining);
                buffer.put(CRLF_BYTES);
            }
            buffer.position(pos);
            return buffer;
        }
        int capacity = hexRemaining.length + 2 + remaining + 2;
        ByteBuffer newBuffer = allocator.allocate(capacity);
        int position = newBuffer.position();
        if (remaining > 0) {
            newBuffer.put(hexRemaining);
            newBuffer.put(CRLF_BYTES);
            newBuffer.put(buffer.buf());
            newBuffer.put(CRLF_BYTES);
        }
        newBuffer.flip();
        newBuffer.position(position);
        return allocator.wrap(newBuffer);
    }
}

