/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.http.HttpProtocolCodecFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpRequestDecoder;
import org.kaazing.gateway.transport.http.bridge.filter.HttpRequestEncoder;
import org.kaazing.gateway.transport.http.bridge.filter.HttpResponseDecoder;
import org.kaazing.gateway.transport.http.bridge.filter.HttpResponseEncoder;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.session.IoSessionEx;

public class HttpCodecFilter
extends HttpProtocolCodecFilter {
    public HttpCodecFilter(boolean client) {
        super((ProtocolCodecFactory)(client ? new HttpClientCodecFactory() : new HttpServerCodecFactory()));
    }

    private static class HttpServerCodecFactory
    implements ProtocolCodecFactory {
        private HttpServerCodecFactory() {
        }

        public ProtocolEncoder getEncoder(IoSession session) {
            IoSessionEx sessionEx = (IoSessionEx)session;
            IoBufferAllocatorEx allocator = sessionEx.getBufferAllocator();
            if (session instanceof BridgeSession) {
                BridgeSession bridgeSession = (BridgeSession)session;
                return new HttpResponseEncoder(bridgeSession.getMessageEncoder(), allocator);
            }
            return new HttpResponseEncoder(allocator);
        }

        public ProtocolDecoder getDecoder(IoSession session) {
            return new HttpRequestDecoder();
        }
    }

    private static class HttpClientCodecFactory
    implements ProtocolCodecFactory {
        private HttpClientCodecFactory() {
        }

        public ProtocolEncoder getEncoder(IoSession session) {
            IoSessionEx sessionEx = (IoSessionEx)session;
            IoBufferAllocatorEx allocator = sessionEx.getBufferAllocator();
            if (session instanceof BridgeSession) {
                BridgeSession bridgeSession = (BridgeSession)session;
                return new HttpRequestEncoder(bridgeSession.getMessageEncoder(), allocator);
            }
            return new HttpRequestEncoder(allocator);
        }

        public ProtocolDecoder getDecoder(IoSession session) {
            return new HttpResponseDecoder();
        }
    }
}

