/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.transport.IoFilterAdapter;
import org.kaazing.gateway.transport.http.HttpSession;

public class HttpContentLengthAdjustmentFilter
extends IoFilterAdapter<HttpSession> {
    protected void doFilterWrite(IoFilter.NextFilter nextFilter, HttpSession session, WriteRequest writeRequest) throws Exception {
        String contentLengthHeader = session.getWriteHeader("Content-Length");
        int contentLength = contentLengthHeader != null ? Integer.parseInt(contentLengthHeader) : 0;
        Object message = writeRequest.getMessage();
        IoBuffer buf = (IoBuffer)message;
        int remaining = buf.remaining();
        int newContentLength = contentLength + remaining;
        session.setWriteHeader("Content-Length", String.valueOf(newContentLength));
        IoFilterChain filterChain = session.getFilterChain();
        filterChain.remove((IoFilter)this);
        super.doFilterWrite(nextFilter, (IoSession)session, writeRequest);
    }
}

