/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.mina.filter.util.WriteRequestFilterEx;

public class HttpFilterAdapter<S extends IoSession>
extends WriteRequestFilterEx {
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        HttpMessage httpMessage = (HttpMessage)((Object)message);
        IoSession sessionEx = session;
        switch (httpMessage.getKind()) {
            case REQUEST: {
                HttpRequestMessage httpRequest = (HttpRequestMessage)httpMessage;
                this.httpRequestReceived(nextFilter, sessionEx, httpRequest);
                break;
            }
            case RESPONSE: {
                HttpResponseMessage httpResponse = (HttpResponseMessage)httpMessage;
                this.httpResponseReceived(nextFilter, sessionEx, httpResponse);
                break;
            }
            case CONTENT: {
                HttpContentMessage httpContent = (HttpContentMessage)httpMessage;
                this.httpContentReceived(nextFilter, sessionEx, httpContent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HTTP message kind: " + (Object)((Object)httpMessage.getKind()));
            }
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        HttpMessage httpMessage = (HttpMessage)((Object)message);
        switch (httpMessage.getKind()) {
            case REQUEST: {
                HttpRequestMessage httpRequest = (HttpRequestMessage)httpMessage;
                this.filterWriteHttpRequest(nextFilter, session, writeRequest, httpRequest);
                break;
            }
            case RESPONSE: {
                HttpResponseMessage httpResponse = (HttpResponseMessage)httpMessage;
                this.filterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
                break;
            }
            case CONTENT: {
                HttpContentMessage httpContent = (HttpContentMessage)httpMessage;
                this.filterWriteHttpContent(nextFilter, session, writeRequest, httpContent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HTTP message kind: " + (Object)((Object)httpMessage.getKind()));
            }
        }
    }

    protected void filterWriteHttpRequest(IoFilter.NextFilter nextFilter, S session, WriteRequest writeRequest, HttpRequestMessage httpRequest) throws Exception {
        super.filterWrite(nextFilter, session, writeRequest);
    }

    protected void filterWriteHttpResponse(IoFilter.NextFilter nextFilter, S session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
        super.filterWrite(nextFilter, session, writeRequest);
    }

    protected void filterWriteHttpContent(IoFilter.NextFilter nextFilter, S session, WriteRequest writeRequest, HttpContentMessage httpContent) throws Exception {
        super.filterWrite(nextFilter, session, writeRequest);
    }

    protected Object doFilterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest, Object message) throws Exception {
        HttpMessage httpMessage = (HttpMessage)((Object)message);
        IoSession sessionEx = session;
        switch (httpMessage.getKind()) {
            case REQUEST: {
                HttpRequestMessage httpRequest = (HttpRequestMessage)httpMessage;
                return this.doFilterWriteHttpRequest(nextFilter, sessionEx, writeRequest, httpRequest);
            }
            case RESPONSE: {
                HttpResponseMessage httpResponse = (HttpResponseMessage)httpMessage;
                return this.doFilterWriteHttpResponse(nextFilter, sessionEx, writeRequest, httpResponse);
            }
            case CONTENT: {
                HttpContentMessage httpContent = (HttpContentMessage)httpMessage;
                return this.doFilterWriteHttpContent(nextFilter, sessionEx, writeRequest, httpContent);
            }
        }
        throw new IllegalArgumentException("Unrecognized HTTP message kind: " + (Object)((Object)httpMessage.getKind()));
    }

    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, S session, HttpRequestMessage httpRequest) throws Exception {
        super.messageReceived(nextFilter, session, (Object)httpRequest);
    }

    protected void httpResponseReceived(IoFilter.NextFilter nextFilter, S session, HttpResponseMessage httpResponse) throws Exception {
        super.messageReceived(nextFilter, session, (Object)httpResponse);
    }

    protected void httpContentReceived(IoFilter.NextFilter nextFilter, S session, HttpContentMessage httpContent) throws Exception {
        super.messageReceived(nextFilter, session, (Object)httpContent);
    }

    protected Object doFilterWriteHttpRequest(IoFilter.NextFilter nextFilter, S session, WriteRequest writeRequest, HttpRequestMessage httpRequest) throws Exception {
        return null;
    }

    protected Object doFilterWriteHttpResponse(IoFilter.NextFilter nextFilter, S session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
        return null;
    }

    protected Object doFilterWriteHttpContent(IoFilter.NextFilter nextFilter, S session, WriteRequest writeRequest, HttpContentMessage httpContent) throws Exception {
        return null;
    }
}

