/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.kaazing.gateway.transport.http.bridge.filter.HttpContentWriter;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

public class HttpGzipEncoder
implements HttpContentWriter {
    public static final int GZIP_PREFIX_SIZE = 5;
    public static final byte[] GZIP_START_OF_FRAME_BYTES = new byte[]{31, -117, 8, 0, -16, 106, 64, 78, 2, -1};
    private static final byte[] GZIPPED_SSE_4K_PADDING_BYTES = new byte[]{-20, -64, 65, 9, 0, 0, 8, 3, -64, -65, 96, 7, 115, -40, 63, -40, 122, -116, -69, 63, 0, 0, 0, -96, -38, 78, 0, 0, 0, -1, -1};
    public static final byte[] SSE_4K_PADDING_BYTES;
    private static final byte[] GZIPPED_WSEB_4K_PADDING_BYTES;
    public static final byte[] WSEB_4K_PADDING_BYTES;

    @Override
    public IoBufferEx write(IoBufferEx source, IoBufferAllocatorEx<?> allocator) {
        return HttpGzipEncoder.writeGzipped(source, allocator);
    }

    private static IoBufferEx writeGzipped(IoBufferEx sourceIoBuf, IoBufferAllocatorEx<?> allocator) {
        ByteBuffer source = sourceIoBuf.buf();
        int position = source.position();
        int remaining = source.remaining();
        if (remaining == 0) {
            return sourceIoBuf;
        }
        if (source.hasArray() && source.array() == SSE_4K_PADDING_BYTES) {
            return allocator.wrap(ByteBuffer.wrap(GZIPPED_SSE_4K_PADDING_BYTES));
        }
        if (source.hasArray() && source.array() == WSEB_4K_PADDING_BYTES) {
            return allocator.wrap(ByteBuffer.wrap(GZIPPED_WSEB_4K_PADDING_BYTES));
        }
        if (position >= 5) {
            ByteBuffer newSource = source.duplicate();
            newSource.position(position - 5);
            int start = newSource.position();
            newSource.put((byte)0);
            byte loByte = (byte)(remaining & 0xFF);
            byte hiByte = (byte)(remaining >> 8 & 0xFF);
            newSource.put(loByte);
            newSource.put(hiByte);
            newSource.put(~loByte);
            newSource.put(~hiByte);
            newSource.position(start);
            return allocator.wrap(newSource, sourceIoBuf.flags());
        }
        ByteBuffer newSource = allocator.allocate(5 + remaining);
        int offset = newSource.position();
        newSource.put((byte)0);
        byte loByte = (byte)(remaining & 0xFF);
        byte hiByte = (byte)(remaining >> 8 & 0xFF);
        newSource.put(loByte);
        newSource.put(hiByte);
        newSource.put(~loByte);
        newSource.put(~hiByte);
        if (sourceIoBuf.isShared()) {
            newSource.put(source.duplicate());
        } else {
            int sourcePos = source.position();
            newSource.put(source);
            source.position(sourcePos);
        }
        newSource.flip();
        newSource.position(offset);
        return allocator.wrap(newSource, sourceIoBuf.flags());
    }

    static {
        int len = 4096;
        byte[] bytes = new byte[len];
        bytes[0] = 58;
        Arrays.fill(bytes, 1, len - 2, (byte)32);
        bytes[len - 2] = 10;
        bytes[len - 1] = 10;
        SSE_4K_PADDING_BYTES = bytes;
        GZIPPED_WSEB_4K_PADDING_BYTES = new byte[]{-20, -64, 1, 13, 0, 0, 8, 2, -80, -39, -56, -2, -27, -96, 7, -5, -17, 1, 0, 0, -128, 113, 41, 0, 0, 0, -1, -1};
        len = 4096;
        bytes = new byte[len];
        bytes[0] = 1;
        Arrays.fill(bytes, 1, len - 1, (byte)48);
        bytes[len - 1] = -1;
        WSEB_4K_PADDING_BYTES = bytes;
    }
}

