/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.CrLfDecodingState;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.apache.mina.filter.codec.statemachine.LinearWhitespaceSkippingState;
import org.kaazing.gateway.transport.DecodingStateMachine;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.bridge.HttpHeaderNameComparator;
import org.kaazing.gateway.transport.http.bridge.filter.HttpProtocolDecoderException;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.filter.codec.statemachine.ConsumeToCrLfDecodingState;
import org.kaazing.mina.filter.codec.statemachine.ConsumeToTerminatorDecodingState;

public abstract class HttpHeaderDecodingState
extends DecodingStateMachine {
    private static final Set<String> COMMA_SEPARATED_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final String HEADER_WEBSOCKET_KEY_PREFIX = "Sec-WebSocket-Key";
    private static final Charset US_ASCII;
    private static final Charset UTF_8;
    private final CharsetDecoder asciiDecoder = US_ASCII.newDecoder();
    private final CharsetDecoder utf8Decoder = UTF_8.newDecoder();
    private Map<String, List<String>> headers;
    private String lastHeaderName;
    private final DecodingState FIND_EMPTY_LINE = new CrLfDecodingState(){

        protected DecodingState finishDecode(boolean foundCRLF, ProtocolDecoderOutput out) throws Exception {
            if (foundCRLF) {
                out.write((Object)HttpHeaderDecodingState.this.headers);
                HttpHeaderDecodingState.this.initHeaders();
                return null;
            }
            return HttpHeaderDecodingState.this.READ_HEADER_NAME;
        }
    };
    private final DecodingState READ_HEADER_NAME = new ConsumeToTerminatorDecodingState(this.allocator, 58){

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            if (buffer == null || !buffer.hasRemaining()) {
                throw new ProtocolDecoderException("Invalid header name in the request");
            }
            HttpHeaderDecodingState.this.lastHeaderName = buffer.getString(HttpHeaderDecodingState.this.asciiDecoder);
            if (!HttpHeaderDecodingState.this.lastHeaderName.trim().equals(HttpHeaderDecodingState.this.lastHeaderName)) {
                throw new HttpProtocolDecoderException(HttpStatus.CLIENT_BAD_REQUEST);
            }
            return HttpHeaderDecodingState.this.AFTER_READ_HEADER_NAME;
        }
    };
    private final DecodingState AFTER_READ_HEADER_NAME = new LinearWhitespaceSkippingState(){

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            return HttpHeaderDecodingState.this.READ_HEADER_VALUE;
        }
    };
    private final DecodingState READ_HEADER_VALUE = new ConsumeToCrLfDecodingState(this.allocator){

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            String value = buffer.getString(HttpHeaderDecodingState.this.utf8Decoder);
            ArrayList<String> values = (ArrayList<String>)HttpHeaderDecodingState.this.headers.get(HttpHeaderDecodingState.this.lastHeaderName);
            if (values == null) {
                values = new ArrayList<String>();
                HttpHeaderDecodingState.this.headers.put(HttpHeaderDecodingState.this.lastHeaderName, values);
            }
            if (COMMA_SEPARATED_HEADERS.contains(HttpHeaderDecodingState.this.lastHeaderName)) {
                String[] separatedValues;
                for (String separatedValue : separatedValues = value.split(",")) {
                    values.add(separatedValue.trim());
                }
            } else {
                values.add(value);
            }
            return HttpHeaderDecodingState.this.AFTER_READ_HEADER_VALUE;
        }
    };
    private final DecodingState AFTER_READ_HEADER_VALUE = new LinearWhitespaceSkippingState(){

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            if (skippedBytes == 0) {
                return HttpHeaderDecodingState.this.FIND_EMPTY_LINE;
            }
            return HttpHeaderDecodingState.this.READ_HEADER_VALUE;
        }
    };

    public HttpHeaderDecodingState(IoBufferAllocatorEx<?> allocator) {
        super(allocator);
    }

    protected DecodingState init() throws Exception {
        this.initHeaders();
        return this.FIND_EMPTY_LINE;
    }

    protected void destroy() throws Exception {
    }

    private void initHeaders() {
        this.headers = new TreeMap<String, List<String>>(HttpHeaderNameComparator.INSTANCE);
    }

    static {
        COMMA_SEPARATED_HEADERS.add("Accept-Ranges");
        COMMA_SEPARATED_HEADERS.add("Accept");
        COMMA_SEPARATED_HEADERS.add("Accept-Charset");
        COMMA_SEPARATED_HEADERS.add("Accept-Encoding");
        COMMA_SEPARATED_HEADERS.add("Accept-Language");
        COMMA_SEPARATED_HEADERS.add("Allow");
        COMMA_SEPARATED_HEADERS.add("Connection");
        COMMA_SEPARATED_HEADERS.add("Content-Encoding");
        COMMA_SEPARATED_HEADERS.add("Content-Language");
        COMMA_SEPARATED_HEADERS.add("If-Match");
        COMMA_SEPARATED_HEADERS.add("If-None-Match");
        COMMA_SEPARATED_HEADERS.add("Cache-Control");
        COMMA_SEPARATED_HEADERS.add("Pragma");
        COMMA_SEPARATED_HEADERS.add("Proxy-Authenticate");
        COMMA_SEPARATED_HEADERS.add("Sec-WebSocket-Protocol");
        COMMA_SEPARATED_HEADERS.add("Sec-WebSocket-Extensions");
        COMMA_SEPARATED_HEADERS.add("Sec-WebSocket-Version");
        COMMA_SEPARATED_HEADERS.add("X-WebSocket-Protocol");
        COMMA_SEPARATED_HEADERS.add("X-WebSocket-Extensions");
        COMMA_SEPARATED_HEADERS.add("TE");
        COMMA_SEPARATED_HEADERS.add("Transfer-Encoding");
        COMMA_SEPARATED_HEADERS.add("Upgrade");
        COMMA_SEPARATED_HEADERS.add("Vary");
        COMMA_SEPARATED_HEADERS.add("Via");
        COMMA_SEPARATED_HEADERS.add("Warning");
        COMMA_SEPARATED_HEADERS.add("WWW-Authenticate");
        COMMA_SEPARATED_HEADERS.add("Forwarded");
        COMMA_SEPARATED_HEADERS.add("X-Forwarded-For");
        COMMA_SEPARATED_HEADERS.add("X-Forwarded-Server");
        COMMA_SEPARATED_HEADERS.add("X-Forwarded-Proto");
        COMMA_SEPARATED_HEADERS.add("X-Forwarded-Host");
        US_ASCII = Charset.forName("US-ASCII");
        UTF_8 = Charset.forName("UTF-8");
    }
}

