/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.util.List;
import java.util.Map;
import org.apache.mina.core.filterchain.IoFilter;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpProtocolDecoderException;
import org.kaazing.mina.core.session.IoSessionEx;

public class HttpHostHeaderFilter
extends HttpFilterAdapter<IoSessionEx> {
    public static final String HEADER_HOST = "Host";

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        Map<String, List<String>> headers = httpRequest.getHeaders();
        List<String> hostHeaderValues = headers.get(HEADER_HOST);
        if (hostHeaderValues == null || hostHeaderValues.size() != 1 || hostHeaderValues.get(0).isEmpty()) {
            throw new HttpProtocolDecoderException(HttpStatus.CLIENT_BAD_REQUEST);
        }
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }
}

