/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpRealmInfo;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.security.LoginContextFactory;
import org.kaazing.gateway.security.TypedCallbackHandlerMap;
import org.kaazing.gateway.security.auth.AuthenticationTokenCallbackHandler;
import org.kaazing.gateway.security.auth.DefaultLoginResult;
import org.kaazing.gateway.security.auth.InetAddressCallbackHandler;
import org.kaazing.gateway.security.auth.YesLoginModule;
import org.kaazing.gateway.security.auth.context.ResultAwareLoginContext;
import org.kaazing.gateway.server.ExpiringState;
import org.kaazing.gateway.server.spi.security.AuthenticationToken;
import org.kaazing.gateway.server.spi.security.AuthenticationTokenCallback;
import org.kaazing.gateway.server.spi.security.InetAddressCallback;
import org.kaazing.gateway.server.spi.security.LoginResult;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpBaseSecurityFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpMergeRequestFilter;
import org.kaazing.gateway.transport.http.security.auth.challenge.HttpChallengeFactories;
import org.kaazing.gateway.transport.http.security.auth.challenge.HttpChallengeFactory;
import org.slf4j.Logger;

public abstract class HttpLoginSecurityFilter
extends HttpBaseSecurityFilter {
    protected static final String AUTH_SCHEME_APPLICATION_PREFIX = "Application ";
    private static final DefaultLoginResult LOGIN_RESULT_OK = new DefaultLoginResult();
    private static final Pattern PATTERN_HEADER_FORWARDED = Pattern.compile(".*for\\s*=\\s*(.*?)(?:\\s*;.*)?$");
    private static final String FORWARDED_URI = "scheme://%s";
    private static final String HEADER_FORWARDED_UNKNOWN_VALUE = "unknown";
    private final ExpiringState expiringState;
    static final ResultAwareLoginContext LOGIN_CONTEXT_OK;
    private HttpChallengeFactory challengeFactory = HttpChallengeFactories.create();

    public HttpLoginSecurityFilter() {
        this.expiringState = null;
    }

    public HttpLoginSecurityFilter(Logger logger, ExpiringState expiringState) {
        super(logger);
        this.expiringState = expiringState;
    }

    protected boolean alreadyLoggedIn(HttpRequestMessage httpRequest) {
        ResourceAddress localAddress = httpRequest.getLocalAddress();
        Subject subject = httpRequest.getSubject();
        List<Object> requiredRoles = Arrays.asList((Object[])localAddress.getOption(HttpResourceAddress.REQUIRED_ROLES));
        if (requiredRoles == null || requiredRoles.size() == 0) {
            return true;
        }
        if (subject != null) {
            Collection<String> authorizedRoles = this.getAuthorizedRoles(subject);
            return authorizedRoles.containsAll(requiredRoles);
        }
        return false;
    }

    private boolean loginMissingToken(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest, AuthenticationToken authToken, TypedCallbackHandlerMap additionalCallbacks, HttpRealmInfo[] realms, int realmIndex, LoginContext[] loginContexts) {
        ResourceAddress localAddress;
        String nextProtocol;
        HttpRealmInfo realm = realms[realmIndex];
        ResultAwareLoginContext loginContext = null;
        try {
            LoginContextFactory loginContextFactory = realm.getLoginContextFactory();
            TypedCallbackHandlerMap callbackHandlerMap = new TypedCallbackHandlerMap();
            this.registerCallbacks(session, httpRequest, authToken, callbackHandlerMap);
            callbackHandlerMap.putAll(additionalCallbacks);
            loginContext = (ResultAwareLoginContext)loginContextFactory.createLoginContext(callbackHandlerMap);
            if (loginContext == null) {
                throw new LoginException("Login failed; cannot create a login context for authentication token '" + authToken + "'.");
            }
            if (this.loggerEnabled()) {
                this.log("Login module login required; [%s].", authToken);
            }
            loginContext.login();
        }
        catch (LoginException le) {
            if (this.loggerEnabled() && !le.getMessage().contains("all modules ignored")) {
                this.log("Login failed: " + le.getMessage(), le);
            }
            if (loginContext == null) {
                this.writeResponse(HttpStatus.CLIENT_FORBIDDEN, nextFilter, session, httpRequest);
                return false;
            }
        }
        catch (Exception e) {
            if (this.loggerEnabled()) {
                this.log("Login failed.", e);
            }
            this.writeResponse(HttpStatus.CLIENT_FORBIDDEN, nextFilter, session, httpRequest);
            return false;
        }
        DefaultLoginResult loginResult = loginContext.getLoginResult();
        String challenge = this.sendChallengeResponse(nextFilter, session, httpRequest, loginResult, realms, realmIndex, loginContexts);
        if (this.loggerEnabled()) {
            this.log(String.format("No authentication token was provided.  Issuing an authentication challenge '%s'.", challenge), new Object[0]);
        }
        if ("http/1.1".equals(nextProtocol = (String)(localAddress = (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get(session)).getOption(ResourceAddress.NEXT_PROTOCOL))) {
            HttpMergeRequestFilter.INITIAL_HTTP_REQUEST_KEY.remove(session);
        }
        return false;
    }

    protected TypedCallbackHandlerMap makeAuthenticationTokenCallback(AuthenticationToken authToken) {
        AuthenticationTokenCallbackHandler authenticationTokenCallbackHandler = new AuthenticationTokenCallbackHandler(authToken);
        TypedCallbackHandlerMap map = new TypedCallbackHandlerMap();
        map.put(AuthenticationTokenCallback.class, (CallbackHandler)authenticationTokenCallbackHandler);
        return map;
    }

    protected String getBaseAuthScheme(String authScheme) {
        if (authScheme != null && authScheme.startsWith(AUTH_SCHEME_APPLICATION_PREFIX)) {
            authScheme = authScheme.replaceFirst(AUTH_SCHEME_APPLICATION_PREFIX, "");
        }
        return authScheme;
    }

    protected boolean login(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest, AuthenticationToken authToken, TypedCallbackHandlerMap additionalCallbacks, HttpRealmInfo[] realms, int realmIndex, LoginContext[] loginContexts) {
        HttpRealmInfo realm = realms[realmIndex];
        ResourceAddress address = httpRequest.getLocalAddress();
        String[] requiredRolesArray = (String[])address.getOption(HttpResourceAddress.REQUIRED_ROLES);
        boolean loginOK = true;
        Subject subject = httpRequest.getSubject();
        List<String> requireRoles = Arrays.asList(requiredRolesArray);
        Collection<Object> authorizedRoles = Collections.emptySet();
        boolean rolesAreSufficient = authorizedRoles.containsAll(requireRoles);
        if (this.loggerEnabled()) {
            this.log("Login starting; [token='%s',rolesAreSufficient=%s].", authToken == null ? "N/A" : authToken, rolesAreSufficient);
        }
        if (this.authTokenIsMissing(authToken) && !rolesAreSufficient) {
            return this.loginMissingToken(nextFilter, session, httpRequest, authToken, additionalCallbacks, realms, realmIndex, loginContexts);
        }
        DefaultLoginResult loginResult = null;
        ResultAwareLoginContext loginContext = null;
        if (rolesAreSufficient) {
            if (this.loggerEnabled()) {
                this.log("Login not required - subject has sufficient required roles; [%s].", authToken);
            }
            loginResult = LOGIN_RESULT_OK;
            loginContext = LOGIN_CONTEXT_OK;
            loginOK = true;
        }
        if (!rolesAreSufficient) {
            LoginContextFactory loginContextFactory = realm.getLoginContextFactory();
            try {
                TypedCallbackHandlerMap callbackHandlerMap = new TypedCallbackHandlerMap();
                this.registerCallbacks(session, httpRequest, authToken, callbackHandlerMap);
                callbackHandlerMap.putAll(additionalCallbacks);
                loginContext = (ResultAwareLoginContext)loginContextFactory.createLoginContext(callbackHandlerMap);
                if (loginContext == null) {
                    throw new LoginException("Login failed; cannot create a login context for authentication token '" + authToken + "'.");
                }
                if (this.loggerEnabled()) {
                    this.log("Login module login required; [%s].", authToken);
                }
                loginContext.login();
                loginResult = loginContext.getLoginResult();
                LoginResult.Type resultType = loginResult.getType();
                if (resultType == LoginResult.Type.FAILURE) {
                    if (loginResult.getLoginException() != null) {
                        throw loginResult.getLoginException();
                    }
                    throw new LoginException("Login Result Indicates Failure");
                }
                subject = loginContext.getSubject();
                authorizedRoles = this.getAuthorizedRoles(subject);
                boolean subjectAutomaticallyAuthorized = this.isSubjectAutomaticallyAuthorized(subject, requireRoles);
                rolesAreSufficient = authorizedRoles.containsAll(requireRoles);
                if (resultType == LoginResult.Type.CHALLENGE || !subjectAutomaticallyAuthorized && !rolesAreSufficient) {
                    if (resultType == LoginResult.Type.CHALLENGE) {
                        Object[] data;
                        if (this.loggerEnabled()) {
                            this.log("Login module login succeeded but requires another challenge", new Object[0]);
                        }
                        if (!((data = loginResult.getLoginChallengeData()) != null && data.length != 0 || "Basic".equals(this.getBaseAuthScheme(realm.getChallengeScheme())))) {
                            if (this.loggerEnabled()) {
                                this.log("Login module login succeeded but requires another challenge, however no new challenge data was provided.", new Object[0]);
                            }
                            this.writeResponse(HttpStatus.CLIENT_FORBIDDEN, nextFilter, session, httpRequest);
                            return false;
                        }
                    }
                    if (realmIndex + 1 < realms.length && resultType == LoginResult.Type.SUCCESS) {
                        loginContexts[realmIndex] = loginContext;
                        httpRequest.setLoginContext(loginContext);
                        httpRequest.setSubject(loginContext == null || loginContext == LOGIN_CONTEXT_OK ? subject : loginContext.getSubject());
                        return true;
                    }
                    String challenge = this.sendChallengeResponse(nextFilter, session, httpRequest, loginResult, realms, realmIndex, loginContexts);
                    if (this.loggerEnabled()) {
                        if (resultType != LoginResult.Type.CHALLENGE) {
                            this.log(String.format("Login module login succeeded but subject missing required roles; Issued another challenge '%s'.", challenge), new Object[0]);
                        } else {
                            this.log(String.format("Login module login succeeded but login result requires a challenge; Issued another challenge '%s'.", challenge), new Object[0]);
                        }
                    }
                    return false;
                }
            }
            catch (Exception e) {
                loginOK = false;
                if (this.loggerEnabled()) {
                    this.log("Login failed.", e);
                }
                if ("Basic".equals(this.getBaseAuthScheme(realm.getChallengeScheme()))) {
                    String challenge = this.sendChallengeResponse(nextFilter, session, httpRequest, loginResult, realms, realmIndex, loginContexts);
                    if (this.loggerEnabled()) {
                        this.log(String.format("Login module login failed; Issued another challenge '%s'.", challenge), e);
                    }
                }
                this.writeResponse(HttpStatus.CLIENT_FORBIDDEN, nextFilter, session, httpRequest);
            }
        }
        if (loginOK && loginResult.hasLoginAuthorizationAttachment()) {
            this.writeSessionCookie(session, httpRequest, loginResult);
        }
        if (loginOK) {
            try {
                loginContexts[realmIndex] = loginContext;
                httpRequest.setLoginContext(loginContext);
                httpRequest.setSubject(loginContext == null || loginContext == LOGIN_CONTEXT_OK ? subject : loginContext.getSubject());
            }
            catch (Exception e) {
                if (this.loggerEnabled()) {
                    this.logger.trace("Login failed.", (Throwable)e);
                }
                loginOK = false;
            }
        }
        if (loginOK && this.loggerEnabled()) {
            this.log("Login succeeded; [%s].", authToken);
        }
        if (!loginOK && this.loggerEnabled()) {
            this.log("Login failed; [%s].", authToken);
        }
        return loginOK;
    }

    private String sendChallengeResponse(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest, DefaultLoginResult loginResult, HttpRealmInfo[] realms, int realmIndex, LoginContext[] loginContexts) {
        HttpRealmInfo realm = realms[realmIndex];
        Object[] challengeData = loginResult != null && loginResult.getType() == LoginResult.Type.CHALLENGE ? loginResult.getLoginChallengeData() : null;
        HttpResponseMessage httpResponse = this.challengeFactory.createChallenge(httpRequest, realm, challengeData);
        if (realmIndex > 0) {
            String challengeIdentity;
            do {
                challengeIdentity = HttpUtils.newSessionId();
                httpResponse.setHeader("Sec-Challenge-Identity", challengeIdentity);
            } while (this.expiringState != null && this.expiringState.putIfAbsent(challengeIdentity, (Object)loginContexts, 30L, TimeUnit.SECONDS) != null);
        }
        this.writeChallenge(httpResponse, nextFilter, session, realm.getChallengeScheme());
        return httpResponse.getHeader("WWW-Authenticate");
    }

    protected void setUnprotectedLoginContext(HttpRequestMessage request) {
        request.setLoginContext(LOGIN_CONTEXT_OK);
    }

    private void registerCallbacks(IoSession session, HttpRequestMessage httpRequest, AuthenticationToken authToken, TypedCallbackHandlerMap callbackHandlerMap) {
        if (callbackHandlerMap == null) {
            throw new NullPointerException("Null callbackHandlerMap passed in");
        }
        AuthenticationTokenCallbackHandler authenticationTokenCallbackHandler = new AuthenticationTokenCallbackHandler(authToken);
        callbackHandlerMap.put(AuthenticationTokenCallback.class, (CallbackHandler)authenticationTokenCallbackHandler);
        String forwarded = httpRequest.getHeader("Forwarded");
        if (forwarded != null) {
            Matcher matcher = PATTERN_HEADER_FORWARDED.matcher(forwarded.toLowerCase());
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("Invalid format: '%s'", forwarded));
            }
            String ipAddress = matcher.group(1);
            if (ipAddress.charAt(0) == '\"') {
                int length = ipAddress.length();
                assert (length > 2);
                if (ipAddress.charAt(length - 1) != '\"') {
                    throw new IllegalStateException(String.format("Invalid format: '%s'", forwarded));
                }
                ipAddress = ipAddress.substring(1, length - 2);
            }
            if (!ipAddress.equals(HEADER_FORWARDED_UNKNOWN_VALUE)) {
                URI uri = URI.create(String.format(FORWARDED_URI, ipAddress));
                this.populateRemoteAddress(callbackHandlerMap, uri);
            }
        } else {
            ResourceAddress resourceAddress = (ResourceAddress)BridgeSession.REMOTE_ADDRESS.get(session);
            ResourceAddress tcpResourceAddress = resourceAddress.findTransport("tcp");
            if (tcpResourceAddress != null) {
                URI resource = tcpResourceAddress.getResource();
                this.populateRemoteAddress(callbackHandlerMap, resource);
            }
        }
    }

    private void populateRemoteAddress(TypedCallbackHandlerMap callbackHandlerMap, URI resource) {
        InetAddress remoteAddr;
        String remoteIpAddress = resource.getHost();
        try {
            remoteAddr = InetAddress.getByName(remoteIpAddress);
        }
        catch (UnknownHostException e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(e.getMessage());
            }
            throw new IllegalStateException(e);
        }
        InetAddressCallbackHandler inetAddressCallbackHandler = new InetAddressCallbackHandler(remoteAddr);
        callbackHandlerMap.put(InetAddressCallback.class, (CallbackHandler)inetAddressCallbackHandler);
    }

    protected void writeSessionCookie(IoSession session, HttpRequestMessage httpRequest, DefaultLoginResult loginResult) {
    }

    protected LoginContext[] getLoginContexts(String challengeIdentity) {
        return this.expiringState != null && challengeIdentity != null ? (LoginContext[])this.expiringState.get(challengeIdentity) : null;
    }

    private boolean authTokenIsMissing(AuthenticationToken authToken) {
        return authToken == null || authToken.isEmpty();
    }

    private boolean isSubjectAutomaticallyAuthorized(Subject subject, Collection<String> requireRoles) {
        return requireRoles.contains("*") && subject != null;
    }

    private void log(String format, Object ... values) {
        this.logger.trace(String.format(format, values));
    }

    private void log(String msg, Throwable t) {
        this.logger.trace(msg, t);
    }

    static {
        try {
            LOGIN_CONTEXT_OK = new ResultAwareLoginContext("LOGIN_CONTEXT_OK", new Subject(), null, (Configuration)new SuccessConfiguration(), LOGIN_RESULT_OK);
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SuccessConfiguration
    extends Configuration {
        private SuccessConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{new AppConfigurationEntry(YesLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap())};
        }
    }
}

