/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.WsHandshakeValidator;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.gateway.util.ws.WebSocketWireProtocol;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.slf4j.Logger;

public class HttpMergeRequestFilter
extends HttpFilterAdapter<IoSessionEx> {
    public static final TypedAttributeKey<IoBufferEx> DRAFT76_KEY3_BUFFER_KEY = new TypedAttributeKey(HttpMergeRequestFilter.class, "draft76Key3Buffer");
    public static final String HEADER_X_WEBSOCKET_EXTENSIONS = "X-WebSocket-Extensions";
    public static final String HEADER_WEBSOCKET_EXTENSIONS = "WebSocket-Extensions";
    public static final String HEADER_SEC_WEBSOCKET_EXTENSIONS = "Sec-WebSocket-Extensions";
    private static final List<String> NATIVE_EXTENSION_HEADERS = Arrays.asList("Sec-WebSocket-Extensions", "WebSocket-Extensions");
    private static final String HEADER_WEBSOCKET_PROTOCOL = "WebSocket-Protocol";
    private static final String HEADER_SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    public static final String NAME = "http#mergeRequestFilter";
    public static final String EXTENDED_HANDSHAKE_PROTOCOL_NAME = "x-kaazing-handshake";
    private final Logger logger;
    public static final TypedAttributeKey<HttpRequestMessage> INITIAL_HTTP_REQUEST_KEY = new TypedAttributeKey(HttpMergeRequestFilter.class, "initialHttpRequest");

    public HttpMergeRequestFilter(Logger logger) {
        this.logger = logger;
    }

    public HttpMergeRequestFilter() {
        this.logger = null;
    }

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        HttpContentMessage httpContent;
        WebSocketWireProtocol protocol;
        HttpRequestMessage initialHttpRequest = (HttpRequestMessage)((Object)INITIAL_HTTP_REQUEST_KEY.get((IoSession)session));
        if (this.loggerEnabled()) {
            this.logger.trace(String.format("HttpMergeRequestFilter: Entering Request is '%s'.", this.toLogString(httpRequest)));
        }
        HttpContentMessage mergedDraft76Key3 = null;
        if (initialHttpRequest != null) {
            IoBufferEx key3;
            if (this.loggerEnabled()) {
                this.logger.trace(String.format("HttpMergeRequestFilter: Retrieved initial request '%s'.", this.toLogString(initialHttpRequest)));
            }
            if (!this.mergeRequests(initialHttpRequest, httpRequest)) {
                if (this.loggerEnabled()) {
                    this.logger.trace("The opening handshake ('" + initialHttpRequest.getRequestURI() + "') cannot be reconciled with the extended handshake '" + httpRequest.getRequestURI() + "'.");
                }
                WriteFuture f = this.writeHttpResponse(nextFilter, (IoSession)session, httpRequest, HttpStatus.CLIENT_BAD_REQUEST);
                f.addListener(IoFutureListener.CLOSE);
                return;
            }
            if (this.loggerEnabled()) {
                this.logger.trace(String.format("HttpMergeRequestFilter: Merged httpRequest is '%s'.", this.toLogString(httpRequest)));
            }
            if (this.loggerEnabled()) {
                this.logger.trace("HttpMergeRequestFilter: 'Extended request received'.");
            }
            if ((key3 = (IoBufferEx)DRAFT76_KEY3_BUFFER_KEY.get((IoSession)session)) != null) {
                mergedDraft76Key3 = new HttpContentMessage(key3, true);
            }
            if (this.loggerEnabled()) {
                this.logger.trace("EHS: Suspend reads until the extended request has been responded to.");
            }
        }
        if ((protocol = WsHandshakeValidator.guessWireProtocolVersion(httpRequest)) != null && initialHttpRequest == null && !protocol.areNativeExtensionsSupported() && HttpMergeRequestFilter.nativeExtensionsRequested(httpRequest)) {
            if (this.loggerEnabled()) {
                this.logger.trace("WebSocket Protocol " + protocol + " clients cannot negotiate extensions.");
            }
            WriteFuture f = this.writeHttpResponse(nextFilter, (IoSession)session, httpRequest, HttpStatus.CLIENT_BAD_REQUEST);
            f.addListener(IoFutureListener.CLOSE);
            return;
        }
        List<String> protocols = httpRequest.getHeaderValues(HEADER_WEBSOCKET_PROTOCOL, false);
        if (protocols == null || protocols.isEmpty()) {
            protocols = httpRequest.getHeaderValues(HEADER_SEC_WEBSOCKET_PROTOCOL, false);
        }
        if (protocols != null && protocols.contains(EXTENDED_HANDSHAKE_PROTOCOL_NAME) && initialHttpRequest == null) {
            if (this.loggerEnabled()) {
                this.logger.trace("x-kaazing-handshake detected.");
            }
            INITIAL_HTTP_REQUEST_KEY.set((IoSession)session, (Object)httpRequest);
        }
        if (mergedDraft76Key3 != null && ((httpContent = httpRequest.getContent()) == null || httpContent.isComplete() && httpContent.asBuffer().capacity() == 0)) {
            httpRequest.setContent(mergedDraft76Key3);
        }
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }

    public static boolean nativeExtensionsRequested(HttpRequestMessage httpRequest) {
        Set<String> headerNames;
        Map<String, List<String>> headers = httpRequest.getHeaders();
        Set<String> set = headerNames = headers == null ? null : headers.keySet();
        if (headerNames == null) {
            return false;
        }
        for (String h : NATIVE_EXTENSION_HEADERS) {
            if (!headerNames.contains(h)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void filterWriteHttpResponse(IoFilter.NextFilter nextFilter, final IoSessionEx session, WriteRequest writeRequest, final HttpResponseMessage httpResponse) throws Exception {
        if (session instanceof BridgeSession) {
            writeRequest.getFuture().addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                public void operationComplete(IoFuture future) {
                    if (httpResponse.getStatus() != HttpStatus.CLIENT_UNAUTHORIZED) {
                        DRAFT76_KEY3_BUFFER_KEY.remove((IoSession)session);
                        HttpMergeRequestFilter.this.removeFilter(session.getFilterChain(), (IoFilter)HttpMergeRequestFilter.this);
                        if (HttpMergeRequestFilter.this.loggerEnabled()) {
                            HttpMergeRequestFilter.this.logger.trace(String.format("HttpMergeRequestFilter: response complete; removed merge request filter from session '%s'.", session));
                        }
                    } else if (HttpMergeRequestFilter.this.loggerEnabled()) {
                        HttpMergeRequestFilter.this.logger.trace(String.format("HttpMergeRequestFilter: 401 response written to session '%s'.", session));
                    }
                }
            });
        }
        super.filterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
    }

    private Object toLogString(HttpRequestMessage httpRequest) {
        StringBuilder b = new StringBuilder();
        b.append(httpRequest.getRequestURI()).append('\n');
        Map<String, List<String>> headers = httpRequest.getHeaders();
        for (String h : headers.keySet()) {
            b.append(h).append(':').append(' ').append(headers.get(h)).append('\n');
        }
        return b.toString();
    }

    private WriteFuture writeHttpResponse(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest, HttpStatus httpStatus, String reason) {
        HttpResponseMessage httpResponse = new HttpResponseMessage();
        httpResponse.setVersion(httpRequest.getVersion());
        httpResponse.setStatus(httpStatus);
        if (reason != null) {
            httpResponse.setReason(reason);
        }
        DefaultWriteFutureEx future = new DefaultWriteFutureEx(session);
        nextFilter.filterWrite(session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)future));
        return future;
    }

    private WriteFuture writeHttpResponse(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest, HttpStatus httpStatus) {
        return this.writeHttpResponse(nextFilter, session, httpRequest, httpStatus, null);
    }

    private boolean mergeRequests(HttpRequestMessage from, HttpRequestMessage to) {
        if (from == null || to == null) {
            return false;
        }
        URI initialRequestURI = from.getRequestURI();
        URI extendedRequestURI = to.getRequestURI();
        boolean uriPathOk = initialRequestURI.getPath().equals(extendedRequestURI.getPath());
        if (!uriPathOk) {
            return false;
        }
        String[] allowances = new String[]{"Host", HEADER_SEC_WEBSOCKET_PROTOCOL, HEADER_SEC_WEBSOCKET_EXTENSIONS, "Connection"};
        if (HttpUtils.containsForbiddenHeaders(to, allowances)) {
            return false;
        }
        String[] restrictions = new String[]{"Authorization", "X-WebSocket-Protocol", HEADER_WEBSOCKET_PROTOCOL, HEADER_SEC_WEBSOCKET_PROTOCOL, HEADER_X_WEBSOCKET_EXTENSIONS, HEADER_WEBSOCKET_EXTENSIONS, HEADER_SEC_WEBSOCKET_EXTENSIONS};
        HttpUtils.restrictHeaders(to, restrictions);
        String[] ignoreHeaders = new String[]{HEADER_X_WEBSOCKET_EXTENSIONS, HEADER_WEBSOCKET_EXTENSIONS, HEADER_SEC_WEBSOCKET_EXTENSIONS};
        HttpUtils.mergeHeaders(from, to, ignoreHeaders);
        String[] protocolHeaders = new String[]{"X-WebSocket-Protocol", HEADER_WEBSOCKET_PROTOCOL, HEADER_SEC_WEBSOCKET_PROTOCOL};
        HttpUtils.removeValueFromHeaders(to, protocolHeaders, EXTENDED_HANDSHAKE_PROTOCOL_NAME);
        HttpUtils.mergeParameters(from, to);
        HttpUtils.mergeCookies(from, to);
        return true;
    }

    protected final void removeFilter(IoFilterChain filterChain, IoFilter filter) {
        if (filterChain.contains(filter)) {
            filterChain.remove(filter);
        }
    }

    protected boolean loggerEnabled() {
        return this.logger != null && this.logger.isTraceEnabled();
    }
}

