/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;

public abstract class HttpMessageDecoder
extends ProtocolDecoderAdapter {
    private static final AttributeKey DECODING_STATE = new AttributeKey(HttpMessageDecoder.class, "decodingState");

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecodingState decodingState = this.getDecodingState(session);
        if (decodingState.decode(in, out) == null) {
            session.removeAttribute((Object)DECODING_STATE);
        }
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        DecodingState decodingState = (DecodingState)session.removeAttribute((Object)DECODING_STATE);
        if (decodingState != null) {
            decodingState.finishDecode(out);
        }
    }

    protected abstract DecodingState initDecodingState(IoSession var1);

    private DecodingState getDecodingState(IoSession session) {
        DecodingState decodingState = (DecodingState)session.getAttribute((Object)DECODING_STATE);
        if (decodingState == null) {
            decodingState = this.initDecodingState(session);
            session.setAttribute((Object)DECODING_STATE, (Object)decodingState);
        }
        return decodingState;
    }
}

