/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.kaazing.gateway.transport.bridge.CachingMessageEncoder;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.gateway.transport.bridge.MessageEncoder;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpStartMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpChunkedEncoder;
import org.kaazing.gateway.transport.http.bridge.filter.HttpGzipEncoder;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;

abstract class HttpMessageEncoder<T extends HttpStartMessage>
extends ProtocolEncoderAdapter {
    protected static final byte[] HTTP_1_0_BYTES = "HTTP/1.0".getBytes();
    protected static final byte[] HTTP_1_1_BYTES = "HTTP/1.1".getBytes();
    protected static final byte[] ZERO_BYTES = "0".getBytes();
    protected static final byte[] EQUAL_BYTES = "=".getBytes();
    protected static final byte[] SEMI_BYTES = ";".getBytes();
    protected static final byte[] COLON_BYTES = ":".getBytes();
    protected static final byte[] SPACE_BYTES = " ".getBytes();
    protected static final byte[] CRLF_BYTES = "\r\n".getBytes();
    protected static final byte[] ZERO_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
    private static final String HEADER_BYTES_PATTERN = "%s: ";
    protected static final byte[] HEADER_CONTENT_LENGTH_BYTES = String.format("%s: ", "Content-Length").getBytes();
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    protected final CachingMessageEncoder cachingEncoder;
    protected final IoBufferAllocatorEx<?> allocator;
    protected final CharsetEncoder asciiEncoder;
    protected static final HttpChunkedEncoder chunkedEncoder = new HttpChunkedEncoder();
    protected static final HttpGzipEncoder gzipEncoder = new HttpGzipEncoder();

    protected HttpMessageEncoder(CachingMessageEncoder cachingEncoder, IoBufferAllocatorEx<?> allocator) {
        this.cachingEncoder = cachingEncoder;
        this.allocator = allocator;
        this.asciiEncoder = US_ASCII.newEncoder();
    }

    public final void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        IoSessionEx sessionEx = (IoSessionEx)session;
        HttpMessage httpMessage = (HttpMessage)((Object)message);
        this.asciiEncoder.reset();
        this.encode(sessionEx, httpMessage, out);
    }

    protected abstract void encode(IoSessionEx var1, HttpMessage var2, ProtocolEncoderOutput var3) throws Exception;

    protected final void encodeContent(IoSessionEx session, T httpStart, ProtocolEncoderOutput out) throws CharacterCodingException {
        HttpContentMessage httpContent = ((HttpStartMessage)((Object)httpStart)).getContent();
        if (httpContent != null) {
            this.encodeContent(session, httpContent, out);
        }
    }

    protected final void encodeContent(IoSessionEx session, HttpContentMessage httpContent, IoBufferEx buf) throws CharacterCodingException {
        boolean isChunked = httpContent.isChunked();
        boolean isGzipped = httpContent.isGzipped();
        this.encodeContent(session, httpContent, buf, isChunked, isGzipped);
    }

    protected final void encodeContent(IoSessionEx session, HttpContentMessage httpContent, ProtocolEncoderOutput out) throws CharacterCodingException {
        boolean isChunked = httpContent.isChunked();
        boolean isGzipped = httpContent.isGzipped();
        this.encodeContent(session, httpContent, out, isChunked, isGzipped);
    }

    protected final void encodeContent(IoSessionEx session, HttpContentMessage httpContent, IoBufferEx buf, boolean isChunked, boolean isGzipped) throws CharacterCodingException {
        if (!isGzipped && !isChunked) {
            IoBufferEx content = httpContent.asBuffer();
            if (content.hasRemaining()) {
                buf.put(content.buf().duplicate());
            }
        } else {
            HttpContentMessageEncoder contentMessageEncoder = isGzipped ? (isChunked ? HttpContentMessageEncoder.CHUNKED_GZIPPED : HttpContentMessageEncoder.GZIPPED) : HttpContentMessageEncoder.CHUNKED;
            IoBufferEx content = httpContent.hasCache() ? this.cachingEncoder.encode((MessageEncoder)contentMessageEncoder, (Message)httpContent, this.allocator, 0) : contentMessageEncoder.encode(this.allocator, httpContent, 0);
            if (content.hasRemaining()) {
                buf.put(content.buf().duplicate());
            }
            if (isChunked && httpContent.isComplete()) {
                buf.put(ByteBuffer.wrap(ZERO_CHUNK_BYTES));
            }
        }
    }

    protected final void encodeContent(IoSessionEx session, HttpContentMessage httpContent, ProtocolEncoderOutput out, boolean isChunked, boolean isGzipped) throws CharacterCodingException {
        if (!isGzipped && !isChunked) {
            IoBufferEx content = httpContent.asBuffer();
            if (content.hasRemaining()) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                IoBufferEx buf = allocator.wrap(content.buf(), content.flags());
                out.write((Object)buf);
            }
        } else {
            HttpContentMessageEncoder contentMessageEncoder = isGzipped ? (isChunked ? HttpContentMessageEncoder.CHUNKED_GZIPPED : HttpContentMessageEncoder.GZIPPED) : HttpContentMessageEncoder.CHUNKED;
            IoBufferEx content = httpContent.hasCache() ? this.cachingEncoder.encode((MessageEncoder)contentMessageEncoder, (Message)httpContent, this.allocator, 0) : contentMessageEncoder.encode(this.allocator, httpContent, 0);
            if (content.hasRemaining()) {
                out.write((Object)content);
            }
            if (isChunked && httpContent.isComplete()) {
                out.write((Object)this.allocator.wrap(ByteBuffer.wrap(ZERO_CHUNK_BYTES)));
            }
        }
    }

    protected final void encodeHeaders(IoSessionEx session, T httpStart, IoBufferEx buf) throws CharacterCodingException {
        for (Map.Entry<String, List<String>> entry : ((HttpStartMessage)((Object)httpStart)).getHeaders().entrySet()) {
            String headerName = entry.getKey();
            List<String> headerValues = entry.getValue();
            if (headerName == null || headerValues == null) continue;
            for (String headerValue : headerValues) {
                this.encodeHeader(buf, headerName, headerValue);
            }
        }
        this.encodeCookies(session, httpStart, buf);
        this.encodeContentLength(session, httpStart, buf);
        buf.put(CRLF_BYTES);
    }

    protected final void encodeHeader(IoBufferEx buf, String headerName, String headerValue) throws CharacterCodingException {
        buf.putString((CharSequence)headerName, this.asciiEncoder);
        buf.put(COLON_BYTES);
        buf.put(SPACE_BYTES);
        buf.putString((CharSequence)headerValue, this.asciiEncoder);
        buf.put(CRLF_BYTES);
    }

    protected void encodeContentLength(IoSessionEx session, T httpStart, IoBufferEx buf) throws CharacterCodingException {
        if (!((HttpStartMessage)((Object)httpStart)).isContentLengthImplicit()) {
            HttpContentMessage httpContent = ((HttpStartMessage)((Object)httpStart)).getContent();
            if (httpContent == null) {
                buf.put(HEADER_CONTENT_LENGTH_BYTES);
                buf.put(ZERO_BYTES);
                buf.put(CRLF_BYTES);
            } else if (httpContent.isComplete() && !httpContent.isGzipped() && !httpContent.isChunked()) {
                IoBufferEx data = httpContent.asBuffer();
                int contentLength = data.remaining();
                buf.put(HEADER_CONTENT_LENGTH_BYTES);
                buf.putString((CharSequence)Integer.toString(contentLength), this.asciiEncoder);
                buf.put(CRLF_BYTES);
            }
        }
    }

    protected abstract void encodeCookies(IoSessionEx var1, T var2, IoBufferEx var3) throws CharacterCodingException;

    static enum HttpContentMessageEncoder implements MessageEncoder<HttpContentMessage>
    {
        NO_ENCODING{

            public IoBufferEx encode(IoBufferAllocatorEx<?> allocator, HttpContentMessage message, int flags) {
                return message.asBuffer();
            }
        }
        ,
        GZIPPED{

            public IoBufferEx encode(IoBufferAllocatorEx<?> allocator, HttpContentMessage httpContent, int flags) {
                IoBufferEx content = httpContent.asBuffer();
                if (content.remaining() > 0) {
                    content = gzipEncoder.write(content, allocator);
                }
                return content;
            }
        }
        ,
        CHUNKED{

            public IoBufferEx encode(IoBufferAllocatorEx<?> allocator, HttpContentMessage httpContent, int flags) {
                IoBufferEx content = httpContent.asBuffer();
                if (content.hasRemaining()) {
                    content = chunkedEncoder.write(content, allocator);
                }
                return content;
            }
        }
        ,
        CHUNKED_GZIPPED{

            public IoBufferEx encode(IoBufferAllocatorEx<?> allocator, HttpContentMessage httpContent, int flags) {
                IoBufferEx content = httpContent.asBuffer();
                if (content.remaining() > 0) {
                    content = gzipEncoder.write(content, allocator);
                }
                if (content.hasRemaining()) {
                    content = chunkedEncoder.write(content, allocator);
                }
                return content;
            }
        };

    }
}

