/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.transport.Bindings;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.http.HttpBindings;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNextAddressFilter
extends HttpFilterAdapter<IoSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"transport.http");
    private ResourceAddressFactory addressFactory;
    private Bindings<HttpBindings.HttpBinding> bindings;

    public void setResourceAddressFactory(ResourceAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
    }

    public void setBindings(Bindings<HttpBindings.HttpBinding> bindings) {
        this.bindings = bindings;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (this.addressFactory == null) {
            throw new NullPointerException("addressFactory");
        }
        if (this.bindings == null) {
            throw new NullPointerException("pathMapsByAddress");
        }
    }

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest) throws Exception {
        ResourceAddress localAddress;
        ResourceAddress candidateAddress;
        httpRequest.removeParameter(".kn");
        String nextProtocol = httpRequest.getHeader("X-Next-Protocol");
        ResourceAddress nextProtocolCandidateAddress = candidateAddress = this.createCandidateAddress(session, httpRequest, nextProtocol);
        Bindings.Binding binding = this.bindings.getBinding(candidateAddress);
        if (binding == null) {
            candidateAddress = this.createCandidateAddress(session, httpRequest, null);
            binding = this.bindings.getBinding(candidateAddress);
        }
        ResourceAddress resourceAddress = localAddress = binding != null ? binding.bindAddress() : null;
        if (localAddress != null) {
            httpRequest.setExternalURI(candidateAddress.getExternalURI());
            httpRequest.setLocalAddress(localAddress);
            super.httpRequestReceived(nextFilter, session, httpRequest);
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("\n*** HttpNextAddressFilter FAILED to find local address\n*** via candidate1:\n" + nextProtocolCandidateAddress + "\n*** via candidate2:\n" + candidateAddress + "\n***with bindings [\n" + this.bindings + "]");
            }
            HttpResponseMessage httpResponse = new HttpResponseMessage();
            httpResponse.setVersion(HttpVersion.HTTP_1_1);
            httpResponse.setStatus(HttpStatus.CLIENT_NOT_FOUND);
            DefaultWriteFutureEx writeFuture = new DefaultWriteFutureEx(session);
            DefaultWriteRequestEx writeRequest = new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)writeFuture);
            nextFilter.filterWrite(session, (WriteRequest)writeRequest);
            writeRequest.getFuture().addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture future) {
                    IoSession session = future.getSession();
                    session.close(false);
                }
            });
        }
    }

    private ResourceAddress createCandidateAddress(IoSession session, HttpRequestMessage httpRequest, String nextProtocol) {
        String scheme;
        URI requestURI = httpRequest.getRequestURI();
        String authority = httpRequest.getHeader("Host");
        String string = scheme = httpRequest.isSecure() ? "https" : "http";
        if (authority == null) {
            return null;
        }
        URI candidateURI = URI.create(String.format("%s://%s/", scheme, authority)).resolve(requestURI);
        ResourceAddress transport = (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get(session);
        if (transport == null) {
            throw new NullPointerException("transport");
        }
        ResourceOptions options = ResourceOptions.FACTORY.newResourceOptions();
        options.setOption(ResourceAddress.NEXT_PROTOCOL, (Object)nextProtocol);
        options.setOption(ResourceAddress.TRANSPORT, (Object)transport);
        return this.addressFactory.newResourceAddress(URIUtils.uriToString((URI)candidateURI), options);
    }
}

