/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;

public class HttpNextProtocolHeaderFilter
extends HttpFilterAdapter<IoSession> {
    public static final String PROTOCOL_HTTPXE_1_1 = "httpxe/1.1";
    private static final String HEADER_X_NEXT_PROTOCOL = "X-Next-Protocol";
    private static final String QUERY_PARAM_NEXT_PROTOCOL = ".knp";
    private static final String WEB_SOCKET = "WebSocket";
    private static final String HEADER_WEBSOCKET_KEY = "Sec-WebSocket-Key";

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest) throws Exception {
        String nextProtocolHeader;
        String upgrade = httpRequest.getHeader("Upgrade");
        if (upgrade != null) {
            if (upgrade.equalsIgnoreCase(WEB_SOCKET)) {
                if (httpRequest.getHeader(HEADER_WEBSOCKET_KEY) != null) {
                    httpRequest.setHeader(HEADER_X_NEXT_PROTOCOL, "ws/rfc6455");
                } else {
                    httpRequest.setHeader(HEADER_X_NEXT_PROTOCOL, "ws/draft-7x");
                }
            }
        } else if (httpRequest.getHeader(HEADER_WEBSOCKET_KEY) != null) {
            httpRequest.setHeader(HEADER_X_NEXT_PROTOCOL, "ws/rfc6455");
        }
        if ((nextProtocolHeader = httpRequest.getHeader(HEADER_X_NEXT_PROTOCOL)) == null && (nextProtocolHeader = httpRequest.removeParameter(QUERY_PARAM_NEXT_PROTOCOL)) != null) {
            httpRequest.setHeader(HEADER_X_NEXT_PROTOCOL, nextProtocolHeader);
        }
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }
}

