/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOperationFilter
extends HttpFilterAdapter<IoSessionEx> {
    private static final String EXTENSION_API_PATH_PREFIX = "/;api/";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] EQUAL_BYTES = "=".getBytes(UTF_8);
    private static final byte[] CRLF_BYTES = "\r\n".getBytes(UTF_8);
    private static final Map<String, HttpOperation> OPERATIONS;
    private static final Logger logger;

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        URI requestURI = httpRequest.getRequestURI();
        String requestPath = requestURI.getPath();
        int apiAt = requestPath.indexOf(EXTENSION_API_PATH_PREFIX);
        if (apiAt != -1) {
            String operationName = requestPath.substring(apiAt + EXTENSION_API_PATH_PREFIX.length());
            HttpOperation operation = OPERATIONS.get(operationName);
            if (operation != null) {
                IoFilterChain filterChain = session.getFilterChain();
                IoFilterChain.Entry entry = filterChain.getEntry((IoFilter)this);
                entry.addAfter(entry.getName() + "#" + operationName, (IoFilter)operation);
                super.httpRequestReceived(nextFilter, session, httpRequest);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Rejected unrecognized operation \"%s\" for URI \"%s\" on session %s", operationName, requestURI, session));
                }
                HttpResponseMessage httpResponse = new HttpResponseMessage();
                httpResponse.setVersion(HttpVersion.HTTP_1_1);
                httpResponse.setStatus(HttpStatus.CLIENT_NOT_FOUND);
                this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
            }
        } else {
            super.httpRequestReceived(nextFilter, session, httpRequest);
        }
    }

    private static String discoverServiceDomain(HttpRequestMessage request) throws Exception {
        ResourceAddress address = request.getLocalAddress();
        return (String)address.getOption(HttpResourceAddress.SERVICE_DOMAIN);
    }

    static {
        logger = LoggerFactory.getLogger((String)"transport.http.accept");
        HashMap<String, HttpOperation> operations = new HashMap<String, HttpOperation>();
        operations.put("set-cookies", new HttpSetCookiesOperation());
        operations.put("get-cookies", new HttpGetCookiesOperation());
        operations.put("delete-cookies", new HttpDeleteCookiesOperation());
        OPERATIONS = operations;
    }

    static class HttpDeleteCookiesOperation
    extends HttpOperation {
        private static final TypedAttributeKey<IoBufferEx> BUFFER_KEY = new TypedAttributeKey(HttpDeleteCookiesOperation.class, "buffer");

        HttpDeleteCookiesOperation() {
        }

        @Override
        protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
            HttpContentMessage rewrittenContent;
            HttpContentMessage httpContent;
            super.httpRequestReceived(nextFilter, session, httpRequest);
            String contentType = httpRequest.getHeader("Content-Type");
            if (contentType == null || !contentType.startsWith("text/plain")) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Expecting request to have a text/plain content type; this request has: '" + contentType + "'.");
                }
                HttpResponseMessage httpResponse = this.createResponse(HttpStatus.CLIENT_BAD_REQUEST);
                this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
            }
            if ((httpContent = httpRequest.getContent()) == null) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                httpContent = new HttpContentMessage(allocator.wrap(allocator.allocate(0)), true);
            }
            if ((rewrittenContent = this.rewriteCookieContent(session, httpContent, HttpOperationFilter.discoverServiceDomain(httpRequest))) != null) {
                this.httpContentReceived(nextFilter, session, rewrittenContent);
            }
        }

        private HttpContentMessage rewriteCookieContent(IoSessionEx session, HttpContentMessage httpContent, String serviceDomain) throws CharacterCodingException {
            IoBufferEx buf = this.readContentChunk(session, httpContent);
            if (httpContent.isComplete()) {
                if (buf != null) {
                    BUFFER_KEY.remove((IoSession)session);
                    buf.flip();
                } else {
                    buf = httpContent.asBuffer();
                }
                String payload = buf.getString(UTF_8.newDecoder());
                String[] lines = payload.split("\r\n");
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line);
                    if (serviceDomain != null) {
                        sb.append("; Domain=").append(serviceDomain);
                    }
                    sb.append("\r\n");
                }
                if (sb.toString().endsWith("\r\n")) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.deleteCharAt(sb.length() - 1);
                }
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                ByteBuffer byteBuf = UTF_8.encode(sb.toString());
                IoBufferEx ioBuf = allocator.wrap(byteBuf);
                return new HttpContentMessage(ioBuf, true, httpContent.isChunked(), httpContent.isGzipped());
            }
            return null;
        }

        @Override
        protected void httpContentReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpContentMessage httpContent) throws Exception {
            IoBufferEx buf = httpContent.asBuffer();
            String payload = buf.getString(UTF_8.newDecoder());
            String[] lines = payload.split("\r\n");
            HttpResponseMessage httpResponse = this.createResponse(HttpStatus.SUCCESS_OK);
            for (String line : lines) {
                httpResponse.addHeader("Set-Cookie", line);
            }
            this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
            super.httpContentReceived(nextFilter, session, httpContent);
        }

        private IoBufferEx readContentChunk(IoSessionEx session, HttpContentMessage httpContent) {
            IoBufferEx buf = (IoBufferEx)BUFFER_KEY.get((IoSession)session);
            if (buf != null) {
                buf.put(httpContent.asBuffer());
            } else if (!httpContent.isComplete()) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                ByteBuffer nioBuf = allocator.allocate(4096);
                buf = allocator.wrap(nioBuf);
                buf.put(httpContent.asBuffer());
                BUFFER_KEY.set((IoSession)session, (Object)buf);
            }
            return buf;
        }
    }

    static class HttpGetCookiesOperation
    extends HttpOperation {
        HttpGetCookiesOperation() {
        }

        @Override
        protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
            super.httpRequestReceived(nextFilter, session, httpRequest);
            Set<HttpCookie> cookies = httpRequest.getCookies();
            HttpResponseMessage httpResponse = this.createResponse(HttpStatus.SUCCESS_OK);
            httpResponse.setHeader("Content-Type", "text/plain; charset=UTF-8");
            if (cookies != null && !cookies.isEmpty()) {
                int allocation = 2;
                for (HttpCookie cookie : cookies) {
                    String cookieName = cookie.getName();
                    String value = cookie.getValue();
                    allocation += cookieName.length() + value.length() + 2;
                }
                CharsetEncoder utf8Encoder = UTF_8.newEncoder();
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                IoBufferEx buf = allocator.wrap(allocator.allocate(allocation));
                for (HttpCookie cookie : cookies) {
                    String cookieName = cookie.getName();
                    String value = cookie.getValue();
                    buf.putString((CharSequence)cookieName, utf8Encoder);
                    buf.put(EQUAL_BYTES);
                    buf.putString((CharSequence)value, utf8Encoder);
                    buf.put(CRLF_BYTES);
                }
                buf.flip();
                httpResponse.setContent(new HttpContentMessage(buf, true));
            }
            this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
        }
    }

    static class HttpSetCookiesOperation
    extends HttpOperation {
        private static final TypedAttributeKey<IoBufferEx> BUFFER_KEY = new TypedAttributeKey(HttpSetCookiesOperation.class, "buffer");

        HttpSetCookiesOperation() {
        }

        @Override
        protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
            HttpContentMessage httpContent;
            super.httpRequestReceived(nextFilter, session, httpRequest);
            String contentType = httpRequest.getHeader("Content-Type");
            if (contentType == null || !contentType.startsWith("text/plain")) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Expecting request to have a text/plain content type; this request has: '" + contentType + "'.");
                }
                HttpResponseMessage httpResponse = this.createResponse(HttpStatus.CLIENT_BAD_REQUEST);
                this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
            }
            if ((httpContent = httpRequest.getContent()) == null) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                httpContent = new HttpContentMessage(allocator.wrap(allocator.allocate(0)), true);
            }
            this.httpContentReceived(nextFilter, session, httpContent);
        }

        @Override
        protected void httpContentReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpContentMessage httpContent) throws Exception {
            IoBufferEx buf = (IoBufferEx)BUFFER_KEY.get((IoSession)session);
            if (buf != null) {
                buf.put(httpContent.asBuffer());
            } else if (!httpContent.isComplete()) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                ByteBuffer nioBuf = allocator.allocate(4096);
                buf = allocator.wrap(nioBuf);
                buf.put(httpContent.asBuffer());
                BUFFER_KEY.set((IoSession)session, (Object)buf);
            }
            if (httpContent.isComplete()) {
                if (buf != null) {
                    BUFFER_KEY.remove((IoSession)session);
                    buf.flip();
                } else {
                    buf = httpContent.asBuffer();
                }
                String payload = buf.getString(UTF_8.newDecoder());
                String[] lines = payload.split("\r\n");
                HttpResponseMessage httpResponse = this.createResponse(HttpStatus.SUCCESS_OK);
                for (String line : lines) {
                    httpResponse.addHeader("Set-Cookie", line);
                }
                this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
            }
            super.httpContentReceived(nextFilter, session, httpContent);
        }
    }

    private static class HttpOperation
    extends HttpFilterAdapter<IoSessionEx> {
        private HttpOperation() {
        }

        @Override
        protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
            if (httpRequest.isComplete()) {
                IoFilterChain filterChain = session.getFilterChain();
                filterChain.remove((IoFilter)this);
            }
        }

        @Override
        protected void httpContentReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpContentMessage httpContent) throws Exception {
            IoFilterChain filterChain;
            if (httpContent.isComplete() && (filterChain = session.getFilterChain()).contains((IoFilter)this)) {
                filterChain.remove((IoFilter)this);
            }
        }

        protected final HttpResponseMessage createResponse(HttpStatus status) {
            HttpResponseMessage httpResponse = new HttpResponseMessage();
            httpResponse.setVersion(HttpVersion.HTTP_1_1);
            httpResponse.setStatus(status);
            return httpResponse;
        }
    }
}

