/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.transport.http.HttpAcceptor;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.session.IoSessionEx;

public class HttpOriginHeaderFilter
extends HttpFilterAdapter<IoSessionEx> {
    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        this.emulateOriginHeader(httpRequest, session);
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }

    private void emulateOriginHeader(HttpRequestMessage httpRequest, IoSessionEx session) {
        String candidateOrigin;
        String origin = httpRequest.getHeader("Origin");
        if (!httpRequest.hasHeader("X-Origin") && (candidateOrigin = httpRequest.removeParameter(".ko")) != null) {
            httpRequest.setHeader("X-Origin", candidateOrigin);
        }
        String emulatedOrigin = null;
        List<String> emulatedOrigins = httpRequest.getHeaderValues("X-Origin", false);
        if (emulatedOrigins != null && !emulatedOrigins.isEmpty()) {
            if (origin != null) {
                String candidateOrigin2 = emulatedOrigins.get(0);
                emulatedOrigin = this.getEmulatedOriginIfRequestMatchesOrigin(httpRequest, candidateOrigin2);
            } else {
                boolean httpxeSpecCompliant = (Boolean)HttpAcceptor.HTTPXE_SPEC_KEY.get((IoSession)session);
                emulatedOrigin = httpxeSpecCompliant ? this.getEmulatedOriginIfReferrerMatches(httpRequest, emulatedOrigins.get(0)) : emulatedOrigins.get(0);
            }
        }
        if (emulatedOrigin != null) {
            if ("null".equals(emulatedOrigin)) {
                httpRequest.setHeader("Origin", "null");
            } else {
                try {
                    String emulatedOriginLC = HttpUtils.getCanonicalURI(emulatedOrigin, false).toString();
                    httpRequest.setHeader("Origin", emulatedOriginLC);
                }
                catch (Exception e) {
                    httpRequest.setHeader("Origin", "null");
                }
            }
        }
    }

    private String getEmulatedOriginIfReferrerMatches(HttpRequestMessage httpRequest, String candidateOrigin) {
        String emulatedOrigin = null;
        String referer = httpRequest.getHeader("Referer");
        if (referer != null) {
            URI refererURI = URI.create(referer);
            boolean isSecure = httpRequest.isSecure();
            String scheme = isSecure ? "https" : "http";
            String authority = HttpUtils.getHostAndPort(httpRequest, isSecure);
            String refererAuthority = HttpUtils.getHostAndPort(refererURI.getAuthority(), isSecure);
            emulatedOrigin = refererURI.getScheme().equals(scheme) && refererAuthority.equals(authority) ? candidateOrigin : "null";
        }
        return emulatedOrigin;
    }

    private String getEmulatedOriginIfRequestMatchesOrigin(HttpRequestMessage httpRequest, String candidateOrigin) {
        String emulatedOrigin = null;
        String origin = httpRequest.getHeader("Origin");
        URI requestURI = HttpUtils.getCanonicalURI(httpRequest.getRequestURI(), false);
        if (origin != null && requestURI != null) {
            boolean isSecure;
            URI originURI = HttpUtils.getCanonicalURI(origin, false);
            String originScheme = originURI.getScheme();
            String originAuthority = originURI.getAuthority();
            if (originAuthority != null && originAuthority.indexOf(58) == -1) {
                int port = "https".equals(originScheme) ? 443 : 80;
                originAuthority = originAuthority + ":" + port;
            }
            String scheme = (isSecure = httpRequest.isSecure()) ? "https" : "http";
            String authority = HttpUtils.getHostAndPort(httpRequest, isSecure);
            if (scheme.equals(originScheme) && authority.equals(originAuthority)) {
                emulatedOrigin = candidateOrigin;
            }
        }
        return emulatedOrigin;
    }
}

