/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpOriginSecurity;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOriginSecurityFilter
extends HttpFilterAdapter<IoSessionEx> {
    private static final String PARAM_ACCESS_CONTROL = ".kac";
    private static final String PARAM_VALUE_ACCESS_CONTROL_EXPLICIT = "ex";
    private static final AttributeKey ACCESS_CONTROL_ALLOW_ORIGIN_KEY = new AttributeKey(HttpOriginSecurityFilter.class, "accessControlAllowOrigin");
    private final Logger logger = LoggerFactory.getLogger(HttpOriginSecurityFilter.class);

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        String wireOrigin;
        String crossOrigin;
        ResourceAddress localAddress;
        block20: {
            localAddress = httpRequest.getLocalAddress();
            if (localAddress == null) {
                throw new IllegalStateException("localAddress is null");
            }
            wireOrigin = crossOrigin = httpRequest.getHeader("Origin");
            if (crossOrigin != null && !"null".equals(crossOrigin)) {
                try {
                    URI originURI = new URI(crossOrigin);
                    String originScheme = originURI.getScheme();
                    String originAuthority = originURI.getAuthority();
                    originAuthority = HttpUtils.getHostAndPort(originAuthority, originScheme.equals("https"));
                    if (!originAuthority.equals(originURI.getAuthority())) {
                        crossOrigin = originScheme + "://" + originAuthority;
                    }
                    if (localAddress.getResource().getAuthority().equals(originAuthority)) {
                        crossOrigin = null;
                        break block20;
                    }
                    Collection balanceOrigins = (Collection)localAddress.getOption(HttpResourceAddress.BALANCE_ORIGINS);
                    if (balanceOrigins != null && !balanceOrigins.isEmpty()) {
                        for (String targetURI : balanceOrigins) {
                            boolean targetIsSecure = "https".equals(URIUtils.getScheme((String)targetURI));
                            String targetScheme = URIUtils.getScheme((String)targetURI);
                            String targetAuthority = HttpUtils.getHostAndPort(URIUtils.getAuthority((String)targetURI), targetIsSecure);
                            if (!"privileged".equals(originScheme) && (!targetScheme.equals(originScheme) || !targetAuthority.equals(originAuthority))) continue;
                            crossOrigin = null;
                            break block20;
                        }
                        break block20;
                    }
                    boolean targetIsSecure = httpRequest.isSecure();
                    String targetScheme = targetIsSecure ? "https" : "http";
                    String targetAuthority = HttpUtils.getHostAndPort(httpRequest, targetIsSecure);
                    if ("privileged".equals(originScheme) || targetScheme.equals(originScheme) && targetAuthority.equals(originAuthority)) {
                        crossOrigin = null;
                    }
                }
                catch (Exception e) {
                    crossOrigin = "null";
                }
            }
        }
        HttpOriginSecurity.HttpOriginConstraint crossSiteConstraint = null;
        HttpOriginSecurity crossOriginSecurity = (HttpOriginSecurity)localAddress.getOption(HttpResourceAddress.ORIGIN_SECURITY);
        if (crossOriginSecurity != null && (crossSiteConstraint = crossOriginSecurity.getConstraint(crossOrigin)) == null && crossOrigin != null) {
            crossSiteConstraint = crossOriginSecurity.getConstraint("*");
        }
        String allowOrigin = crossSiteConstraint != null ? crossSiteConstraint.getAllowOrigin() : null;
        boolean explicitAccessControl = PARAM_VALUE_ACCESS_CONTROL_EXPLICIT.equals(httpRequest.getParameter(PARAM_ACCESS_CONTROL));
        if (allowOrigin != null || explicitAccessControl) {
            allowOrigin = wireOrigin;
        }
        session.setAttribute((Object)ACCESS_CONTROL_ALLOW_ORIGIN_KEY, (Object)allowOrigin);
        HttpMethod httpMethod = httpRequest.getMethod();
        switch (httpMethod) {
            case OPTIONS: {
                String requestMethod = httpRequest.getHeader("Access-Control-Request-Method");
                String requestHeaders = httpRequest.getHeader("Access-Control-Request-Headers");
                if (crossOrigin == null || requestMethod == null && requestHeaders == null) break;
                HttpResponseMessage httpResponse = new HttpResponseMessage();
                httpResponse.setVersion(HttpVersion.HTTP_1_1);
                httpResponse.setStatus(HttpStatus.SUCCESS_OK);
                if (crossSiteConstraint != null) {
                    String allowMethods = crossSiteConstraint.getAllowMethods();
                    String allowHeaders = crossSiteConstraint.getAllowHeaders();
                    Integer maximumAge = crossSiteConstraint.getMaximumAge();
                    if (allowMethods != null) {
                        httpResponse.setHeader("Access-Control-Allow-Methods", allowMethods);
                    }
                    if (allowHeaders != null) {
                        httpResponse.setHeader("Access-Control-Allow-Headers", allowHeaders);
                    }
                    httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
                    if (maximumAge != null) {
                        httpResponse.setHeader("Access-Control-Max-Age", maximumAge.toString());
                        httpResponse.setHeader("Max-Age", maximumAge.toString());
                    }
                }
                this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
                return;
            }
        }
        if (!(crossOrigin == null || crossSiteConstraint != null && crossSiteConstraint.getAllowMethods().contains(httpMethod.toString()))) {
            HttpResponseMessage httpResponse = new HttpResponseMessage();
            httpResponse.setVersion(HttpVersion.HTTP_1_1);
            httpResponse.setStatus(HttpStatus.CLIENT_FORBIDDEN);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rejected cross-origin request for location \"{}\" from origin \"{}\"", new Object[]{localAddress.getExternalURI(), crossOrigin});
            }
            this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
            return;
        }
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }

    @Override
    protected Object doFilterWriteHttpResponse(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
        String allowOrigin = (String)session.removeAttribute((Object)ACCESS_CONTROL_ALLOW_ORIGIN_KEY);
        if (allowOrigin != null) {
            httpResponse.setHeader("Access-Control-Allow-Origin", allowOrigin);
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.getHeaderValues("Access-Control-Allow-Headers").addAll(Arrays.asList("content-type", "authorization", "x-websocket-extensions", "x-websocket-version", "x-websocket-protocol"));
        }
        return super.doFilterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
    }
}

