/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.util.Arrays;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;

public class HttpPathMatchingFilter
extends HttpFilterAdapter<IoSession> {
    private static final List<String> WSE_FULL_MATCHING_PATHS = Arrays.asList("/;e/ub", "/;e/db", "/;e/ut", "/;e/dt", "/;e/ute", "/;e/dte", "/;e/ubm", "/;e/dbm", "/;e/utm", "/;e/dtm", "/;e/utem", "/;e/dtem");

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest) throws Exception {
        ResourceAddress bindAddress = httpRequest.getLocalAddress();
        String nextProtocol = (String)bindAddress.getOption(ResourceAddress.NEXT_PROTOCOL);
        if (nextProtocol == null || !nextProtocol.equals("httpxe/1.1")) {
            super.httpRequestReceived(nextFilter, session, httpRequest);
            return;
        }
        String bindPath = bindAddress.getResource().getPath();
        String requestPath = httpRequest.getRequestURI().getPath();
        int index = requestPath.indexOf(38);
        if (index != -1) {
            requestPath = requestPath.substring(0, index);
        }
        boolean match = true;
        for (String wsePath : WSE_FULL_MATCHING_PATHS) {
            if (!requestPath.contains(wsePath)) continue;
            match = requestPath.equals(bindPath);
        }
        if (match) {
            super.httpRequestReceived(nextFilter, session, httpRequest);
        } else {
            HttpResponseMessage httpResponse = new HttpResponseMessage();
            httpResponse.setVersion(HttpVersion.HTTP_1_1);
            httpResponse.setStatus(HttpStatus.CLIENT_NOT_FOUND);
            DefaultWriteFutureEx writeFuture = new DefaultWriteFutureEx(session);
            DefaultWriteRequestEx writeRequest = new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)writeFuture);
            nextFilter.filterWrite(session, (WriteRequest)writeRequest);
            writeRequest.getFuture().addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture future) {
                    IoSession session = future.getSession();
                    session.close(false);
                }
            });
        }
    }
}

