/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.HttpStartMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPersistenceFilter
extends HttpFilterAdapter<IoSessionEx> {
    private static final String CONNECTION_CLOSE = "close";
    private static final String HEADER_CONNECTION = "Connection";
    private static final Pattern PATTERN_CONNECTION_CLOSE = Pattern.compile(".*\\s*[c|C][l|L][o|O][s|S][e|E]\\s*");
    private static final AttributeKey CONNECTION_CLOSE_KEY = new AttributeKey(HttpPersistenceFilter.class, "connectionClose");
    private static final TypedAttributeKey<Integer> SESSION_IDLE_TIMEOUT_KEY = new TypedAttributeKey(HttpPersistenceFilter.class, "sessionIdleTimeout");
    private static final Logger logger = LoggerFactory.getLogger(HttpPersistenceFilter.class);

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        if (status == IdleStatus.BOTH_IDLE && SESSION_IDLE_TIMEOUT_KEY.get(session) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Closing HTTP parent session %s because http.keepalive.timeout of %d secs is exceeded", session, SESSION_IDLE_TIMEOUT_KEY.get(session)));
            }
            session.close(false);
        }
        super.sessionIdle(nextFilter, session, status);
    }

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        Integer keepAliveTimeout;
        if (HttpPersistenceFilter.isClosing(httpRequest)) {
            session.setAttribute((Object)CONNECTION_CLOSE_KEY);
        }
        if ((keepAliveTimeout = (Integer)httpRequest.getLocalAddress().getOption(HttpResourceAddress.KEEP_ALIVE_TIMEOUT)) != null && keepAliveTimeout > 0) {
            SESSION_IDLE_TIMEOUT_KEY.set((IoSession)session, (Object)keepAliveTimeout);
        }
        if (session.containsAttribute(SESSION_IDLE_TIMEOUT_KEY)) {
            HttpPersistenceFilter.deactivateSessionIdleTimeout((IoSession)session);
        }
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }

    @Override
    protected Object doFilterWriteHttpResponse(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
        boolean isClosing = HttpPersistenceFilter.isClosing(httpResponse);
        if (isClosing) {
            session.setAttribute((Object)CONNECTION_CLOSE_KEY);
        }
        switch (httpResponse.getVersion()) {
            case HTTP_1_1: {
                if (!isClosing) break;
                httpResponse.setHeader(HEADER_CONNECTION, CONNECTION_CLOSE);
            }
        }
        if (httpResponse.isComplete()) {
            if (session.containsAttribute((Object)CONNECTION_CLOSE_KEY)) {
                writeRequest.getFuture().addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                    public void operationComplete(WriteFuture future) {
                        IoSession session = future.getSession();
                        session.close(false);
                    }
                });
            } else {
                switch (httpResponse.getStatus()) {
                    case INFO_SWITCHING_PROTOCOLS: {
                        break;
                    }
                    default: {
                        HttpPersistenceFilter.activateSessionIdleTimeout((IoSession)session);
                    }
                }
            }
        }
        return super.doFilterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
    }

    @Override
    protected Object doFilterWriteHttpContent(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest, HttpContentMessage httpContent) throws Exception {
        if (httpContent.isComplete()) {
            if (session.containsAttribute((Object)CONNECTION_CLOSE_KEY)) {
                writeRequest.getFuture().addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                    public void operationComplete(WriteFuture future) {
                        IoSession session = future.getSession();
                        if (logger.isTraceEnabled()) {
                            logger.trace(String.format("Closing session %s because of Connection: close header in HTTP request", session));
                        }
                        session.close(false);
                    }
                });
            } else {
                HttpPersistenceFilter.activateSessionIdleTimeout((IoSession)session);
            }
        }
        return super.doFilterWriteHttpContent(nextFilter, session, writeRequest, httpContent);
    }

    static boolean isClosing(HttpStartMessage httpStart) {
        switch (httpStart.getVersion()) {
            case HTTP_1_0: {
                return true;
            }
            case HTTP_1_1: {
                boolean isClosing = httpStart.isContentLengthImplicit();
                List<String> connectionValues = httpStart.getHeaderValues(HEADER_CONNECTION, false);
                if (connectionValues != null) {
                    for (String connectionValue : connectionValues) {
                        if (!PATTERN_CONNECTION_CLOSE.matcher(connectionValue).matches()) continue;
                        isClosing = true;
                        break;
                    }
                }
                return isClosing;
            }
        }
        throw new IllegalArgumentException("Unexpected HTTP version: " + (Object)((Object)httpStart.getVersion()));
    }

    private static void activateSessionIdleTimeout(IoSession session) {
        Integer keepaliveTimeout = (Integer)SESSION_IDLE_TIMEOUT_KEY.get(session);
        if (keepaliveTimeout != null) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Setting idle timeout %d on HTTP parent session %s ", keepaliveTimeout, session));
            }
            session.getConfig().setBothIdleTime(keepaliveTimeout.intValue());
        }
    }

    private static void deactivateSessionIdleTimeout(IoSession session) {
        session.getConfig().setBothIdleTime(0);
    }

    public static void cleanup(IoSession session) {
        SESSION_IDLE_TIMEOUT_KEY.remove(session);
        HttpPersistenceFilter.deactivateSessionIdleTimeout(session);
    }
}

