/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.IoFilterAdapter;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.HttpAcceptFilter;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProtocolCompatibilityFilter
extends HttpFilterAdapter<IoSessionEx> {
    public static final String PROTOCOL_HTTPXE_1_1 = "httpxe/1.1";
    private static final String CONTENT_TYPE_APPLICATION_X_MESSAGE_HTTP = "application/x-message-http";
    private static final String PROTOCOL_WSE_1_0 = "wse/1.0";
    private static final String HEADER_CREATE_ENCODING = "X-Create-Encoding";
    private static final String HEADER_X_HTTP_VERSION = "X-Http-Version";
    private static final String HEADER_VALUE_HTTPE_VERSION_1_0 = "httpe-1.0";
    public static final String PARAMETER_X_SEQUENCE_NO = ".ksn";
    private static final String QUERY_PARAM_METHOD = ".km";
    private static final String QUERY_PARAM_RESOURCE = ".kr";
    private static final String QUERY_PARAM_RANDOM_NUMBER = ".krn";
    private static final String RESOURCE_NAME_CLIENT_ACCESS_POLICY_XML = "clientaccesspolicy.xml";
    private static final String REQUEST_PATH_CLIENT_ACCESS_POLICY_XML = String.format("/%s", "clientaccesspolicy.xml");
    private static final String RESOURCE_NAME_PATTERN = "/;resource/%s";
    public static final String REVALIDATE_SUFFIX = "/;a";
    public static final String EMULATED_REVALIDATE_SUFFIX = "/;ae";
    public static final String RTMP_REVALIDATE_SUFFIX = "/;ar";
    private static final Collection<String> REVALIDATE_PATHS = Arrays.asList("/;a", "/;ae", "/;ar");
    private static final String EXTENSION_PATH = "/;e/";
    private static final int EXTENSION_PATH_LENGTH = "/;e/".length();
    private static final Collection<String> EXTENDED_PATHS = Arrays.asList("ct", "ut", "dt", "cte", "ute", "dte", "cb", "ub", "db", "ctm", "utm", "dtm", "ctem", "utem", "dtem", "cbm", "ubm", "dbm", "cr");
    private static final String AUTHORIZATION_PATH = "/;a";
    private static final Collection<String> AUTHORIZATION_KINDS = Arrays.asList("a", "ae", "ar");
    private static final String[] HTTPXE_ENVELOPE_HEADERS = new String[]{"Authorization", "Content-Length", "Content-Type"};
    private static final String PATH_ENCODED_METHOD_PREFIX = "/;";
    private static final int PATH_ENCODED_METHOD_PREFIX_LENGTH = "/;".length();
    public static final String API_PATH = "/;api";
    public static final AttributeKey EMPTY_PACKET_PRODUCER_FILTER = new AttributeKey(HttpProtocolCompatibilityFilter.class, "emptyPacketProducerFilter");
    private static final Collection<String> PATH_ENCODED_METHODS;
    private static final Map<String, String> CREATE_ENCODINGS;
    private static final Logger logger;

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        IoFilter emptyFilter = (IoFilter)session.getAttribute((Object)EMPTY_PACKET_PRODUCER_FILTER);
        if (emptyFilter != null) {
            session.removeAttribute((Object)EMPTY_PACKET_PRODUCER_FILTER);
            session.getFilterChain().addAfter(HttpAcceptFilter.CODEC.filterName(), "http#emptyPacketProducer", emptyFilter);
            nextFilter.sessionOpened(session);
            return;
        }
        if (HttpElevateEmulatedRequestFilter.elevateEmulatedRequestRequired(session)) {
            DefaultHttpSession httpSession = (DefaultHttpSession)session;
            nextFilter.sessionOpened(session);
            HttpRequestMessage httpxeRequest = HttpElevateEmulatedRequestFilter.asElevatedRequest(session);
            String contentLengthStr = httpSession.getReadHeader("Content-Length");
            if (contentLengthStr != null && !"0".equals(contentLengthStr)) {
                if (httpSession.getFilterChain().contains(HttpAcceptFilter.CODEC.filterName())) {
                    session.getFilterChain().addBefore(HttpAcceptFilter.CODEC.filterName(), HttpAcceptFilter.ELEVATE_EMULATED_REQUEST.filterName(), (IoFilter)new HttpElevateEmulatedRequestFilter(Long.valueOf(contentLengthStr)));
                } else {
                    session.getFilterChain().addFirst(HttpAcceptFilter.ELEVATE_EMULATED_REQUEST.filterName(), (IoFilter)new HttpElevateEmulatedRequestFilter(Long.valueOf(contentLengthStr)));
                }
            }
            this.httpRequestReceived(nextFilter, (IoSessionEx)session, httpxeRequest);
        }
    }

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        URI requestURI1;
        String requestPath1;
        String resourceName;
        String pathEncodedMethod;
        int nextForwardSlashAt;
        String requestPath;
        URI requestURI;
        List<String> emulatedOrigins;
        String httpVersion;
        List<String> httpVersions;
        String contentType;
        String candidateSequenceNo;
        if (!httpRequest.hasHeader("X-Sequence-No") && (candidateSequenceNo = httpRequest.removeParameter(PARAMETER_X_SEQUENCE_NO)) != null) {
            httpRequest.setHeader("X-Sequence-No", candidateSequenceNo);
        }
        if (this.deferOriginSecurityToHttpxe(session, httpRequest) && session.getFilterChain().contains(HttpAcceptFilter.ORIGIN_SECURITY.filterName())) {
            session.getFilterChain().remove(HttpAcceptFilter.ORIGIN_SECURITY.filterName());
        }
        if (HttpConditionalWrappedResponseFilter.conditionallyWrappedResponsesRequired(session)) {
            HttpAcceptSession httpSession = (HttpAcceptSession)session;
            httpSession.setMethod(HttpMethod.POST);
            if (!this.isWrappedResponseMandated(httpSession)) {
                session.getFilterChain().addBefore(HttpAcceptFilter.PROTOCOL_HTTPXE.filterName(), HttpAcceptFilter.CONDITIONAL_WRAPPED_RESPONSE.filterName(), HttpAcceptFilter.CONDITIONAL_WRAPPED_RESPONSE.filter());
            }
        }
        httpRequest.removeParameter(QUERY_PARAM_RANDOM_NUMBER);
        if (!httpRequest.hasHeader("X-Next-Protocol") && CONTENT_TYPE_APPLICATION_X_MESSAGE_HTTP.equals(contentType = httpRequest.getHeader("Content-Type"))) {
            httpRequest.setHeader("X-Next-Protocol", PROTOCOL_HTTPXE_1_1);
        }
        if (!(httpRequest.hasHeader("X-Next-Protocol") || (httpVersions = httpRequest.removeHeader(HEADER_X_HTTP_VERSION)) == null || httpVersions.isEmpty() || (httpVersion = httpVersions.get(0)).equals(HEADER_VALUE_HTTPE_VERSION_1_0))) {
            HttpResponseMessage httpResponse = new HttpResponseMessage();
            httpResponse.setVersion(httpRequest.getVersion());
            httpResponse.setStatus(HttpStatus.SERVER_NOT_IMPLEMENTED);
            httpResponse.setReason("Http-Version not supported");
            DefaultWriteFuture writeFuture = new DefaultWriteFuture((IoSession)session);
            nextFilter.filterWrite((IoSession)session, (WriteRequest)new DefaultWriteRequest((Object)httpResponse, (WriteFuture)writeFuture));
            nextFilter.filterClose((IoSession)session);
            return;
        }
        if (!httpRequest.hasHeader("X-Next-Protocol") && (emulatedOrigins = httpRequest.getHeaderValues("X-Origin", false)) != null && !emulatedOrigins.isEmpty() && session.getFilterChain().getEntry(WrappedHttpTextEventStreamFilter.getFilterName()) == null) {
            session.getFilterChain().addAfter(HttpAcceptFilter.CODEC.filterName(), WrappedHttpTextEventStreamFilter.getFilterName(), (IoFilter)new WrappedHttpTextEventStreamFilter());
        }
        if (!httpRequest.hasHeader("X-Next-Protocol")) {
            int authorizationAt;
            String nextProtocol;
            int nextSlashAt;
            requestURI = httpRequest.getRequestURI();
            String path = requestURI.getPath();
            int extensionAt = path.indexOf(EXTENSION_PATH);
            if (extensionAt != -1) {
                String extendedPath;
                int extendedPathAt = extensionAt + EXTENSION_PATH_LENGTH;
                nextSlashAt = path.indexOf(47, extendedPathAt + 1);
                String string = extendedPath = nextSlashAt != -1 ? path.substring(extendedPathAt, nextSlashAt) : path.substring(extendedPathAt);
                if (EXTENDED_PATHS.contains(extendedPath)) {
                    nextProtocol = this.getNextProtocol((IoSession)session);
                    if (PROTOCOL_HTTPXE_1_1.equals(nextProtocol)) {
                        switch (extendedPath.charAt(1)) {
                            case 'b': 
                            case 't': {
                                String sessionPath = ((ResourceAddress)BridgeSession.LOCAL_ADDRESS.get((IoSession)session)).getResource().getPath();
                                if (HttpProtocolCompatibilityFilter.isBalancerPath(sessionPath)) {
                                    httpRequest.removeHeader("X-Next-Protocol");
                                } else {
                                    httpRequest.setHeader("X-Next-Protocol", PROTOCOL_WSE_1_0);
                                }
                                if (extendedPath.charAt(0) != 'c') break;
                                String createEncoding = CREATE_ENCODINGS.get(extendedPath);
                                httpRequest.setHeader(HEADER_CREATE_ENCODING, createEncoding);
                            }
                        }
                        if (extendedPath.charAt(0) == 'c') {
                            // empty if block
                        }
                    } else if (!PROTOCOL_HTTPXE_1_1.equals(nextProtocol)) {
                        httpRequest.setHeader("X-Next-Protocol", PROTOCOL_HTTPXE_1_1);
                    }
                }
            }
            if ((authorizationAt = path.indexOf("/;a")) != -1) {
                String authorizationKind;
                nextSlashAt = path.indexOf(47, authorizationAt + 2);
                String string = authorizationKind = nextSlashAt != -1 ? path.substring(authorizationAt + 2, nextSlashAt) : path.substring(authorizationAt + 2);
                if (AUTHORIZATION_KINDS.contains(authorizationKind) && !PROTOCOL_HTTPXE_1_1.equals(nextProtocol = this.getNextProtocol((IoSession)session))) {
                    httpRequest.setHeader("X-Next-Protocol", PROTOCOL_HTTPXE_1_1);
                }
            }
            if (HttpProtocolCompatibilityFilter.isApiPath(path) && httpRequest.getHeader("X-Origin") != null) {
                session.getFilterChain().remove(HttpAcceptFilter.OPERATION.filter());
                httpRequest.setHeader("X-Next-Protocol", PROTOCOL_HTTPXE_1_1);
            }
        }
        if (!httpRequest.hasHeader("X-Next-Protocol")) {
            this.emulateMethod(httpRequest);
        }
        if ((requestPath = (requestURI = httpRequest.getRequestURI()).getPath()).startsWith(PATH_ENCODED_METHOD_PREFIX) && (nextForwardSlashAt = requestPath.indexOf(47, PATH_ENCODED_METHOD_PREFIX_LENGTH)) != -1 && PATH_ENCODED_METHODS.contains(pathEncodedMethod = requestPath.substring(PATH_ENCODED_METHOD_PREFIX_LENGTH, nextForwardSlashAt))) {
            String validatedOrigin;
            List<Object> validatedOrigins;
            HttpMethod method = httpRequest.getMethod();
            HttpMethod newMethod = HttpMethod.valueOf(pathEncodedMethod.toUpperCase());
            List<String> emulatedOrigins2 = httpRequest.getHeaderValues("X-Origin", false);
            String emulatedOrigin = null;
            if (emulatedOrigins2 != null && !emulatedOrigins2.isEmpty()) {
                emulatedOrigin = emulatedOrigins2.get(0);
            }
            if (emulatedOrigin != null) {
                String validatedOriginsHeader = "X-Origin-" + URLEncoder.encode(emulatedOrigin, "UTF-8");
                validatedOrigins = httpRequest.removeHeader(validatedOriginsHeader);
                if (validatedOrigins == null) {
                    validatedOrigins = Collections.emptyList();
                }
            } else {
                validatedOrigins = Collections.emptyList();
            }
            String string = validatedOrigin = !validatedOrigins.isEmpty() ? (String)validatedOrigins.get(0) : null;
            if ((newMethod.equals((Object)method) || method == HttpMethod.POST) && validatedOrigin != null && validatedOrigin.equals(emulatedOrigin)) {
                String requestScheme = requestURI.getScheme();
                String requestAuthority = requestURI.getAuthority();
                String newRequestPath = requestPath.substring(nextForwardSlashAt);
                String requestQuery = requestURI.getQuery();
                String requestFragment = requestURI.getFragment();
                URI newRequestURI = new URI(requestScheme, requestAuthority, newRequestPath, requestQuery, requestFragment);
                httpRequest.setMethod(newMethod);
                httpRequest.setRequestURI(newRequestURI);
                httpRequest.setHeader("Origin", validatedOrigin);
                if (!PROTOCOL_HTTPXE_1_1.equals(this.getNextProtocol((IoSession)session)) && HttpProtocolCompatibilityFilter.isEmulatedWebSocketPath(newRequestPath)) {
                    httpRequest.setHeader("X-Next-Protocol", PROTOCOL_HTTPXE_1_1);
                }
            } else {
                HttpResponseMessage httpResponse = new HttpResponseMessage();
                httpResponse.setVersion(HttpVersion.HTTP_1_1);
                httpResponse.setStatus(HttpStatus.CLIENT_FORBIDDEN);
                if (logger.isDebugEnabled()) {
                    if (method != HttpMethod.POST && !newMethod.equals((Object)method)) {
                        logger.debug(String.format("Rejected cross-origin %s request for URI \"%s\" due to mismatch with path-encoded method %s", new Object[]{method, requestURI, newMethod}));
                    } else if (validatedOrigin == null) {
                        logger.debug(String.format("Rejected cross-origin %s request for URI \"%s\" from emulated origin \"%s\" due to lack of validation (validated origins %s)", new Object[]{method, requestURI, emulatedOrigin, validatedOrigins}));
                    } else {
                        logger.debug(String.format("Rejected cross-origin %s request for URI \"%s\" from emulated origin \"%s\" mismatch with validated origin \"%s\"", new Object[]{method, requestURI, emulatedOrigin, validatedOrigin}));
                    }
                }
                this.filterWrite(nextFilter, (IoSession)session, (WriteRequest)new DefaultWriteRequestEx((Object)httpResponse, (WriteFutureEx)new DefaultWriteFutureEx((IoSession)session)));
                return;
            }
        }
        if ((resourceName = httpRequest.removeParameter(QUERY_PARAM_RESOURCE)) != null && !HttpProtocolCompatibilityFilter.isRevalidateWebSocketRequest(httpRequest)) {
            URI requestURI12 = httpRequest.getRequestURI();
            URI newRequestURI = requestURI12.resolve(String.format(RESOURCE_NAME_PATTERN, resourceName));
            httpRequest.setRequestURI(newRequestURI);
        }
        if (REQUEST_PATH_CLIENT_ACCESS_POLICY_XML.equals(requestPath1 = (requestURI1 = httpRequest.getRequestURI()).getPath())) {
            URI newRequestURI = requestURI.resolve(String.format(RESOURCE_NAME_PATTERN, RESOURCE_NAME_CLIENT_ACCESS_POLICY_XML));
            httpRequest.setRequestURI(newRequestURI);
        }
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }

    private boolean deferOriginSecurityToHttpxe(IoSessionEx session, HttpRequestMessage httpRequest) {
        ResourceAddress resourceAddress = (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get((IoSession)session);
        String nextProtocol = (String)resourceAddress.getOption(ResourceAddress.NEXT_PROTOCOL);
        return "http/1.1".equals(nextProtocol) && HttpProtocolCompatibilityFilter.isLegacyClient(httpRequest) && (HttpProtocolCompatibilityFilter.isEmulatedWebSocketRequest(httpRequest) || HttpProtocolCompatibilityFilter.isRevalidateWebSocketRequest(httpRequest));
    }

    private boolean isWrappedResponseMandated(HttpAcceptSession httpSession) {
        return null != httpSession.getReadHeader("X-Origin");
    }

    private String getNextProtocol(IoSession session) {
        if (session instanceof BridgeSession) {
            ResourceAddress localAddress = ((BridgeSession)session).getLocalAddress();
            return (String)localAddress.getOption(ResourceAddress.NEXT_PROTOCOL);
        }
        return null;
    }

    private void emulateMethod(HttpRequestMessage httpRequest) {
        String method;
        if (httpRequest.getMethod() == HttpMethod.POST && (method = httpRequest.getParameter(QUERY_PARAM_METHOD)) != null && method.length() == 1) {
            switch (method.charAt(0)) {
                case 'G': {
                    httpRequest.setMethod(HttpMethod.GET);
                    break;
                }
                case 'D': {
                    httpRequest.setMethod(HttpMethod.DELETE);
                    break;
                }
                case 'O': {
                    httpRequest.setMethod(HttpMethod.OPTIONS);
                    break;
                }
                case 'P': {
                    httpRequest.setMethod(HttpMethod.PUT);
                    break;
                }
                case 'T': {
                    httpRequest.setMethod(HttpMethod.TRACE);
                    break;
                }
                case 'H': {
                    httpRequest.setMethod(HttpMethod.HEAD);
                }
            }
        }
    }

    private static boolean isEmulatedWebSocketRequest(HttpRequestMessage message) {
        return HttpProtocolCompatibilityFilter.isEmulatedWebSocketPath(message.getRequestURI().getPath());
    }

    private static boolean isEmulatedWebSocketRequest(HttpAcceptSession session) {
        return HttpProtocolCompatibilityFilter.isEmulatedWebSocketPath(session.getRequestURI().getPath());
    }

    private static boolean isApiRequest(HttpAcceptSession session) {
        return HttpProtocolCompatibilityFilter.isApiPath(session.getRequestURI().getPath());
    }

    private static boolean isRevalidateWebSocketRequest(HttpRequestMessage message) {
        return HttpProtocolCompatibilityFilter.isRevalidateWebSocketPath(message.getRequestURI().getPath());
    }

    private static boolean isRevalidateWebSocketRequest(HttpAcceptSession session) {
        return HttpProtocolCompatibilityFilter.isRevalidateWebSocketPath(session.getRequestURI().getPath());
    }

    private static boolean isBalancerRequest(HttpAcceptSession session) {
        return HttpProtocolCompatibilityFilter.isBalancerPath(session.getRequestURI().getPath());
    }

    private static boolean isRevalidateWebSocketPath(String path) {
        int extensionAt;
        if (path != null && (extensionAt = path.indexOf("/;a")) != -1) {
            int nextSlashAt = path.indexOf(47, extensionAt + 1);
            String revalidatePath = nextSlashAt != -1 ? path.substring(extensionAt, nextSlashAt) : path.substring(extensionAt);
            return REVALIDATE_PATHS.contains(revalidatePath);
        }
        return false;
    }

    private static boolean isBalancerPath(String path) {
        return path != null && path.endsWith(";e");
    }

    private static boolean isEmulatedWebSocketPath(String path) {
        int extensionAt;
        if (path != null && (extensionAt = path.indexOf(EXTENSION_PATH)) != -1) {
            int extendedPathAt = extensionAt + EXTENSION_PATH_LENGTH;
            int nextSlashAt = path.indexOf(47, extendedPathAt + 1);
            String extendedPath = nextSlashAt != -1 ? path.substring(extendedPathAt, nextSlashAt) : path.substring(extendedPathAt);
            return EXTENDED_PATHS.contains(extendedPath);
        }
        return false;
    }

    private static boolean isApiPath(String path) {
        return path != null && path.contains(API_PATH);
    }

    private static boolean isExplicitEnvelopedContentType(HttpAcceptSession httpSession) {
        return CONTENT_TYPE_APPLICATION_X_MESSAGE_HTTP.equals(httpSession.getReadHeader("Content-Type"));
    }

    private static boolean isExplicitAccessControl(HttpAcceptSession httpSession) {
        return "ex".equals(httpSession.getParameter(".kac"));
    }

    private static boolean isLegacyClient(HttpAcceptSession httpSession) {
        boolean hasOld3xClientVersionParam = "10.05".equals(httpSession.getParameter(".kv"));
        boolean hasOld3xBalancerRequestParameter = httpSession.getParameter(".kl") != null;
        boolean hasNextProtocolDefined = null != httpSession.getReadHeader("X-Next-Protocol") || null != httpSession.getParameter(".knp");
        return hasOld3xClientVersionParam || hasOld3xBalancerRequestParameter || !hasNextProtocolDefined;
    }

    private static boolean isLegacyClient(HttpRequestMessage httpRequest) {
        boolean hasOld3xClientVersionParam = "10.05".equals(httpRequest.getParameter(".kv"));
        boolean hasOld3xBalancerRequestParameter = httpRequest.getParameter(".kl") != null;
        boolean hasNextProtocolDefined = null != httpRequest.getHeader("X-Next-Protocol") || null != httpRequest.getParameter(".knp");
        return hasOld3xClientVersionParam || hasOld3xBalancerRequestParameter || !hasNextProtocolDefined;
    }

    static {
        HashSet<String> pathEncodedMethods = new HashSet<String>();
        for (HttpMethod httpMethod : HttpMethod.values()) {
            pathEncodedMethods.add(httpMethod.name().toLowerCase());
        }
        PATH_ENCODED_METHODS = pathEncodedMethods;
        HashMap<String, String> createEncodings = new HashMap<String, String>();
        createEncodings.put("ct", "text");
        createEncodings.put("cte", "text-escaped");
        createEncodings.put("cb", "binary");
        createEncodings.put("ctm", "text/mixed");
        createEncodings.put("ctem", "text-escaped/mixed");
        createEncodings.put("cbm", "binary/mixed");
        CREATE_ENCODINGS = Collections.unmodifiableMap(createEncodings);
        logger = LoggerFactory.getLogger((String)"transport.http");
    }

    public static class WrappedHttpTextEventStreamFilter
    extends HttpFilterAdapter<IoSessionEx> {
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private static final CharsetEncoder UTF_8_ENCODER = UTF_8.newEncoder();
        private static final CharSequence WRAPPED_HTTP = "HTTP/1.1 200 OK\r\nContent-Type: text/event-stream\r\n\r\n";
        private static final String FILTER_NAME = "WrappedHttpTextEventStreamFilter";
        private static final int TO_ALLOCATE = WRAPPED_HTTP.length();

        @Override
        protected void filterWriteHttpResponse(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
            if (httpResponse.getStatus() == HttpStatus.SUCCESS_OK && "text/event-stream".equals(httpResponse.getHeader("Content-Type"))) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                allocator.allocate(TO_ALLOCATE);
                IoBufferEx buffer = httpResponse.getContent().asBuffer();
                buffer.expand(0, TO_ALLOCATE, allocator);
                buffer.putString(WRAPPED_HTTP, UTF_8_ENCODER);
                buffer.flip();
            }
            super.filterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
        }

        public static String getFilterName() {
            return FILTER_NAME;
        }
    }

    public static class HttpConditionalWrappedResponseFilter
    extends HttpFilterAdapter<IoSessionEx> {
        public static boolean conditionallyWrappedResponsesRequired(IoSessionEx session) {
            ResourceAddress resourceAddress = (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get((IoSession)session);
            String nextProtocol = (String)resourceAddress.getOption(ResourceAddress.NEXT_PROTOCOL);
            if (HttpProtocolCompatibilityFilter.PROTOCOL_HTTPXE_1_1.equals(nextProtocol)) {
                HttpAcceptSession httpSession = (HttpAcceptSession)session;
                return !HttpProtocolCompatibilityFilter.isExplicitAccessControl(httpSession) && HttpProtocolCompatibilityFilter.isLegacyClient(httpSession) && (httpSession.getMethod() == HttpMethod.GET || HttpProtocolCompatibilityFilter.isEmulatedWebSocketRequest(httpSession) || HttpProtocolCompatibilityFilter.isRevalidateWebSocketRequest(httpSession) || HttpProtocolCompatibilityFilter.isBalancerRequest(httpSession));
            }
            return false;
        }

        @Override
        protected void filterWriteHttpResponse(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
            DefaultHttpSession httpSession = (DefaultHttpSession)session;
            switch (httpResponse.getStatus()) {
                case CLIENT_UNAUTHORIZED: {
                    session.getFilterChain().remove((IoFilter)this);
                    break;
                }
                case REDIRECT_FOUND: 
                case CLIENT_BAD_REQUEST: 
                case SUCCESS_CREATED: {
                    boolean httpxeSpecCompliant = httpSession.isHttpxeSpecCompliant();
                    if (httpxeSpecCompliant) {
                        session.getFilterChain().remove((IoFilter)this);
                        break;
                    }
                }
                default: {
                    IoFilter filter;
                    IoFilterChain chain;
                    boolean bl;
                    httpSession.setStatus(httpResponse.getStatus());
                    httpSession.setVersion(httpResponse.getVersion());
                    Map<String, List<String>> remainingHttpxeLevelHeaders = httpResponse.getHeaders();
                    if (remainingHttpxeLevelHeaders != null) {
                        for (String string : remainingHttpxeLevelHeaders.keySet()) {
                            List<String> values = remainingHttpxeLevelHeaders.get(string);
                            if (values == null) continue;
                            for (String value : values) {
                                httpSession.addWriteHeader(string, value);
                            }
                        }
                        Map<String, List<String>> writeHeaders = httpSession.getWriteHeaders();
                        for (String headerName : writeHeaders.keySet()) {
                            List<String> possiblyDuplicateStrings = writeHeaders.get(headerName);
                            if (possiblyDuplicateStrings == null) continue;
                            ArrayList<String> values = new ArrayList<String>(new HashSet<String>(possiblyDuplicateStrings));
                            writeHeaders.put(headerName, values);
                        }
                    }
                    HashSet<HttpCookie> httpxeAndSessionCookies = new HashSet<HttpCookie>(httpSession.getWriteCookies());
                    httpxeAndSessionCookies.addAll(httpResponse.getCookies());
                    httpSession.setWriteCookies(httpxeAndSessionCookies);
                    httpSession.setReason(httpResponse.getReason());
                    boolean bl2 = bl = httpSession.getWriteHeader("Content-Length") != null;
                    if (bl && (chain = session.getFilterChain()).contains(filter = HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT.filter())) {
                        session.getFilterChain().remove(filter);
                    }
                    if (!httpResponse.hasCache()) {
                        httpResponse.initCache();
                    }
                    IoBufferAllocatorEx allocator = httpSession.getBufferAllocator();
                    IoBufferEx oldBuffer = httpResponse.getCache().putIfAbsent(HttpProtocolCompatibilityFilter.PROTOCOL_HTTPXE_1_1, allocator.wrap(allocator.allocate(0)));
                    if (oldBuffer == null || !logger.isDebugEnabled()) break;
                    String msgFormat = "Unexpected existing buffer associated with old websocket emulated create response: '%s'";
                    logger.warn(String.format(msgFormat, oldBuffer));
                }
            }
            super.filterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
        }
    }

    static class HttpElevateEmulatedRequestFilter
    extends IoFilterAdapter<DefaultHttpSession> {
        long contentLength;

        public HttpElevateEmulatedRequestFilter(long contentLength) {
            this.contentLength = contentLength;
        }

        public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
            super.onPreRemove(parent, name, nextFilter);
        }

        protected void doMessageReceived(IoFilter.NextFilter nextFilter, DefaultHttpSession session, Object message) throws Exception {
            IoBufferEx buffer = (IoBufferEx)message;
            long bytesRead = session.getReadBytes();
            if (bytesRead > this.contentLength) {
                String format = String.format("httpxe/1.1 expecting %d content bytes, but we have read %d bytes", this.contentLength, bytesRead);
                throw new RuntimeException(format);
            }
            HttpContentMessage httpContentMessage = new HttpContentMessage(buffer, bytesRead == this.contentLength);
            nextFilter.messageReceived((IoSession)session, (Object)httpContentMessage);
        }

        static boolean elevateEmulatedRequestRequired(IoSession session) {
            if (HttpProtocolCompatibilityFilter.PROTOCOL_HTTPXE_1_1.equals(((ResourceAddress)BridgeSession.LOCAL_ADDRESS.get(session)).getOption(ResourceAddress.NEXT_PROTOCOL))) {
                DefaultHttpSession httpSession = (DefaultHttpSession)session;
                return !HttpProtocolCompatibilityFilter.isExplicitEnvelopedContentType(httpSession) && HttpProtocolCompatibilityFilter.isLegacyClient(httpSession) && (HttpProtocolCompatibilityFilter.isEmulatedWebSocketRequest(httpSession) || HttpProtocolCompatibilityFilter.isRevalidateWebSocketRequest(httpSession) || HttpProtocolCompatibilityFilter.isApiRequest(httpSession));
            }
            return false;
        }

        static HttpRequestMessage asElevatedRequest(IoSession ioSession) throws Exception {
            DefaultHttpSession session = (DefaultHttpSession)ioSession;
            HttpRequestMessage req = new HttpRequestMessage();
            req.setVersion(session.getVersion());
            req.setMethod(session.getMethod());
            req.setParameters(session.getParameters());
            req.setRequestURI(session.getRequestURI());
            req.setSecure(session.isSecure());
            req.setCookies(session.getReadCookies());
            String contentLengthStr = session.getReadHeader("Content-Length");
            if (contentLengthStr != null && !"0".equals(contentLengthStr)) {
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                HttpContentMessage httpContent = new HttpContentMessage(allocator.wrap(allocator.allocate(0)), false);
                req.setContent(httpContent);
            }
            HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>(session.getReadHeaders());
            req.setHeaders(requestHeaders);
            HttpUtils.restrictHeaders(req, HTTPXE_ENVELOPE_HEADERS);
            req.setSubject(session.getSubject());
            req.setLoginContext(session.getLoginContext());
            DefaultHttpSession httpSession = session;
            HashMap<String, List<String>> sessionHeaders = new HashMap<String, List<String>>(httpSession.getReadHeaders());
            sessionHeaders.put("Content-Type", Collections.singletonList(HttpProtocolCompatibilityFilter.CONTENT_TYPE_APPLICATION_X_MESSAGE_HTTP));
            httpSession.setReadHeaders(sessionHeaders);
            return req;
        }
    }
}

