/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.util.Set;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.http.HttpInjectableHeader;
import org.kaazing.gateway.transport.http.HttpAcceptProcessor;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;

public class HttpProtocolFilter
extends HttpFilterAdapter {
    public static final String PROTOCOL_HTTP_1_1 = "http/1.1";

    protected void filterWriteHttpResponse(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
        Set<HttpInjectableHeader> injectableHeaders = httpResponse.getInjectableHeaders();
        if (injectableHeaders.contains(HttpInjectableHeader.SERVER)) {
            HttpAcceptProcessor.setServerHeader(session, httpResponse);
        }
        if (injectableHeaders.contains(HttpInjectableHeader.DATE) && !httpResponse.hasHeader("Date")) {
            httpResponse.setHeader("Date", HttpUtils.formatDateHeader(System.currentTimeMillis()));
        }
        super.filterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
    }
}

