/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.CrLfDecodingState;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.kaazing.gateway.transport.DecodingStateMachine;
import org.kaazing.gateway.transport.http.DefaultHttpCookie;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpChunkDecodingState;
import org.kaazing.gateway.transport.http.bridge.filter.HttpHeaderDecodingState;
import org.kaazing.gateway.transport.http.bridge.filter.HttpPersistenceFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpRequestLineDecodingState;
import org.kaazing.gateway.transport.http.bridge.filter.MaximumLengthDecodingState;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.filter.codec.statemachine.FixedLengthDecodingState;

public class HttpRequestDecodingState
extends DecodingStateMachine {
    private static final int MAXIMUM_NON_STREAMING_CONTENT_LENGTH = 4096;
    private static final String HEADER_WEBSOCKET_KEY1 = "Sec-WebSocket-Key1";
    private static final String HEADER_HOST = "Host";
    private static final String HEADER_ORIGIN = "Origin";
    private static final String HEADER_REFERER = "Referer";
    private static final String QUERY_PARAM_DEFAULT_CONTENT_TYPE = ".kct";
    private final List<String> NULL_ORIGIN;
    private final DecodingState SKIP_EMPTY_LINES = new CrLfDecodingState(){

        protected DecodingState finishDecode(boolean foundCRLF, ProtocolDecoderOutput out) throws Exception {
            if (foundCRLF) {
                return this;
            }
            return HttpRequestDecodingState.this.READ_REQUEST_MESSAGE;
        }
    };
    protected final DecodingState FLUSH_MESSAGES = new DecodingState(){

        public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            return HttpRequestDecodingState.this.SKIP_EMPTY_LINES;
        }

        public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
            return HttpRequestDecodingState.this.SKIP_EMPTY_LINES;
        }
    };
    private static final DecodingState READ_CONTENT = new DecodingState(){

        public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            HttpContentMessage content = new HttpContentMessage((IoBufferEx)in.duplicate(), false);
            out.write((Object)content);
            in.position(in.limit());
            return this;
        }

        public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
            return null;
        }
    };
    private final DecodingState READ_REQUEST_MESSAGE = new DecodingStateMachine(this.allocator){

        protected DecodingState init() throws Exception {
            return HttpRequestDecodingState.this.READ_REQUEST_LINE;
        }

        protected void destroy() throws Exception {
        }

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            if (childProducts.size() < 5) {
                return this;
            }
            HttpMethod method = (HttpMethod)((Object)childProducts.get(0));
            URI requestURI = (URI)childProducts.get(1);
            HttpVersion version = (HttpVersion)((Object)childProducts.get(2));
            Map headers = (Map)childProducts.get(3);
            Set cookies = (Set)childProducts.get(4);
            ArrayList<String> hostHeaderValues = (ArrayList<String>)headers.get(HttpRequestDecodingState.HEADER_HOST);
            if (requestURI.isAbsolute()) {
                if (hostHeaderValues != null) {
                    hostHeaderValues.clear();
                } else {
                    hostHeaderValues = new ArrayList<String>(1);
                }
                hostHeaderValues.add(requestURI.getHost() + (requestURI.getPort() == -1 ? "" : ":" + requestURI.getPort()));
                headers.put(HttpRequestDecodingState.HEADER_HOST, hostHeaderValues);
                String query = requestURI.getQuery();
                URI uRI = requestURI = query == null ? URI.create(requestURI.getPath()) : URI.create(requestURI.getPath() + "?" + query);
            }
            if (hostHeaderValues != null) {
                int size = hostHeaderValues.size();
                for (int i = 0; i < size; ++i) {
                    String hostPort = (String)hostHeaderValues.get(i);
                    String hostPortLC = hostPort.toLowerCase();
                    if (hostPortLC.equals(hostPort)) continue;
                    hostHeaderValues.set(i, hostPortLC);
                    headers.put(HttpRequestDecodingState.HEADER_HOST, hostHeaderValues);
                }
            }
            try {
                HttpRequestDecodingState.this.canonicalizeURIHeaders(headers, new String[]{HttpRequestDecodingState.HEADER_ORIGIN});
            }
            catch (IllegalArgumentException iae) {
                headers.put(HttpRequestDecodingState.HEADER_ORIGIN, HttpRequestDecodingState.this.NULL_ORIGIN);
            }
            HttpRequestDecodingState.this.canonicalizeURIHeaders(headers, new String[]{HttpRequestDecodingState.HEADER_REFERER});
            final HttpRequestMessage httpRequest = new HttpRequestMessage();
            httpRequest.setSecure(HttpRequestDecodingState.this.secure);
            httpRequest.setMethod(method);
            httpRequest.setRequestURI(requestURI);
            httpRequest.setVersion(version);
            httpRequest.setHeaders(headers);
            httpRequest.setCookies(cookies);
            String contentTypeHeader = httpRequest.getHeader("Content-Type");
            String contentTypeParam = httpRequest.removeParameter(HttpRequestDecodingState.QUERY_PARAM_DEFAULT_CONTENT_TYPE);
            if (contentTypeHeader == null && contentTypeParam != null) {
                httpRequest.setHeader("Content-Type", contentTypeParam);
            }
            if (version == HttpVersion.HTTP_1_1 && this.isChunked(httpRequest)) {
                httpRequest.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), false));
                out.write((Object)httpRequest);
                return HttpRequestDecodingState.this.READ_CHUNK;
            }
            long length = this.getContentLength(httpRequest);
            String lengthValue = httpRequest.getHeader("Content-Length");
            if (length > 0L) {
                if (length < 4096L) {
                    return new FixedLengthDecodingState(this.allocator, (int)length){

                        protected DecodingState finishDecode(IoBuffer product, ProtocolDecoderOutput out) throws Exception {
                            HttpContentMessage content = new HttpContentMessage((IoBufferEx)product, true);
                            httpRequest.setContent(content);
                            out.write((Object)httpRequest);
                            return null;
                        }
                    };
                }
                httpRequest.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), false));
                out.write((Object)httpRequest);
                return new MaximumLengthDecodingState(length);
            }
            if (lengthValue == null && HttpPersistenceFilter.isClosing(httpRequest)) {
                httpRequest.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), false));
                out.write((Object)httpRequest);
                return READ_CONTENT;
            }
            out.write((Object)httpRequest);
            return null;
        }

        private long getContentLength(HttpRequestMessage httpRequest) throws ProtocolDecoderException {
            String lengthValue = httpRequest.getHeader("Content-Length");
            if (lengthValue != null) {
                return this.parseContentLength(lengthValue);
            }
            if (httpRequest.hasHeader(HttpRequestDecodingState.HEADER_WEBSOCKET_KEY1)) {
                return 8L;
            }
            return 0L;
        }

        private long parseContentLength(String lengthValue) throws ProtocolDecoderException {
            try {
                return Long.parseLong(lengthValue);
            }
            catch (NumberFormatException e) {
                throw new ProtocolDecoderException("Invalid content length: " + lengthValue);
            }
        }

        private boolean isChunked(HttpRequestMessage httpRequest) throws ProtocolDecoderException {
            String transferEncoding = httpRequest.getHeader("Transfer-Encoding");
            if (transferEncoding != null) {
                int semicolonAt = transferEncoding.indexOf(59);
                if (semicolonAt != -1) {
                    transferEncoding = transferEncoding.substring(0, semicolonAt);
                }
                if ("chunked".equalsIgnoreCase(transferEncoding)) {
                    return true;
                }
                throw new ProtocolDecoderException("Unexpected transfer coding: " + transferEncoding);
            }
            return false;
        }
    };
    private final DecodingState READ_REQUEST_LINE = new HttpRequestLineDecodingState(this.allocator){

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            if (childProducts.isEmpty()) {
                return this;
            }
            HttpMethod httpMethod = (HttpMethod)((Object)childProducts.get(0));
            URI requestURI = (URI)childProducts.get(1);
            String path = requestURI.getPath();
            if (path == null || path.equals("")) {
                requestURI = new URI(requestURI.getScheme(), requestURI.getUserInfo(), requestURI.getHost(), requestURI.getPort(), "/".concat(path), requestURI.getQuery(), requestURI.getFragment());
            }
            HttpVersion httpVersion = (HttpVersion)((Object)childProducts.get(2));
            out.write((Object)httpMethod);
            out.write((Object)requestURI);
            out.write((Object)httpVersion);
            return HttpRequestDecodingState.this.READ_HEADERS;
        }
    };
    private final DecodingState READ_HEADERS = new HttpHeaderDecodingState(this.allocator){

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            if (childProducts.isEmpty()) {
                return this;
            }
            Map headers = (Map)childProducts.get(0);
            List cookieHeaderValues = (List)headers.get("Cookie");
            Set cookies = HttpRequestDecodingState.this.parseCookies(cookieHeaderValues);
            out.write((Object)headers);
            out.write((Object)cookies);
            return null;
        }
    };
    private final DecodingState READ_CHUNK = new HttpChunkDecodingState(this.allocator){

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            if (childProducts.isEmpty()) {
                throw new ProtocolDecoderException("Expected a chunk");
            }
            IoBufferEx data = (IoBufferEx)childProducts.get(0);
            boolean terminator = !data.hasRemaining();
            HttpContentMessage content = new HttpContentMessage(data, terminator);
            out.write((Object)content);
            return terminator ? null : HttpRequestDecodingState.this.READ_CHUNK;
        }
    };
    private final boolean secure;

    public HttpRequestDecodingState(IoBufferAllocatorEx<?> allocator, boolean secure) {
        super(allocator);
        this.NULL_ORIGIN = new ArrayList<String>(1);
        this.NULL_ORIGIN.add("null");
        this.secure = secure;
    }

    protected DecodingState init() throws Exception {
        return this.READ_REQUEST_MESSAGE;
    }

    protected void destroy() throws Exception {
    }

    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecodingState decodingState = super.decode(in, out);
        this.flush(this.childProducts, out);
        return decodingState;
    }

    protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
        this.flush(childProducts, out);
        return null;
    }

    private void canonicalizeURIHeaders(Map<String, List<String>> headers, String ... headerNames) {
        for (String headerName : headerNames) {
            List<String> headerValues = headers.get(headerName);
            if (headerValues == null) continue;
            int size = headerValues.size();
            for (int i = 0; i < size; ++i) {
                String valueLC;
                String value = headerValues.get(i);
                if (value.isEmpty() || (valueLC = HttpUtils.getCanonicalURI(value, false).toString()).equals(value)) continue;
                headerValues.set(i, valueLC);
                headers.put(headerName, headerValues);
            }
        }
    }

    private void flush(List<Object> childProducts, ProtocolDecoderOutput out) {
        Iterator<Object> i = childProducts.iterator();
        while (i.hasNext()) {
            Object product = i.next();
            i.remove();
            out.write(product);
        }
    }

    private Set<HttpCookie> parseCookies(List<String> cookieHeaderValues) {
        HashSet<HttpCookie> cookies = new HashSet<HttpCookie>();
        if (cookieHeaderValues != null && !cookieHeaderValues.isEmpty()) {
            String cookieHeaderValue = cookieHeaderValues.get(0);
            DefaultHttpCookie currentCookie = null;
            int version = -1;
            int fieldIdx = 0;
            StringTokenizer tk = new StringTokenizer(cookieHeaderValue, ";,");
            while (tk.hasMoreTokens()) {
                String value;
                String key;
                String pair = tk.nextToken();
                int equalsPos = pair.indexOf(61);
                if (equalsPos >= 0) {
                    key = pair.substring(0, equalsPos).trim();
                    value = pair.substring(equalsPos + 1).trim();
                } else {
                    key = pair.trim();
                    value = "";
                }
                if (version < 0) {
                    if (!key.equalsIgnoreCase("$Version")) {
                        version = 0;
                    } else {
                        version = Integer.parseInt(value);
                        if (version != 0 && version != 1) {
                            throw new IllegalArgumentException("Invalid version: " + version + " (" + cookieHeaderValue + ")");
                        }
                    }
                }
                if (version < 0) continue;
                try {
                    switch (fieldIdx) {
                        case 1: {
                            if (key.equalsIgnoreCase("$Path")) {
                                currentCookie.setPath(value);
                                ++fieldIdx;
                                break;
                            }
                            fieldIdx = 0;
                            break;
                        }
                        case 2: {
                            if (key.equalsIgnoreCase("$Domain")) {
                                currentCookie.setDomain(value);
                                ++fieldIdx;
                                break;
                            }
                            fieldIdx = 0;
                        }
                    }
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("Cookie key-value pair not found (" + cookieHeaderValue + ")");
                }
                if (fieldIdx != 0) continue;
                currentCookie = new DefaultHttpCookie(key);
                currentCookie.setVersion(version);
                currentCookie.setValue(value);
                cookies.add(currentCookie);
                ++fieldIdx;
            }
        }
        return cookies;
    }
}

