/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Pattern;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.CrLfDecodingState;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.apache.mina.filter.codec.statemachine.LinearWhitespaceSkippingState;
import org.kaazing.gateway.transport.DecodingStateMachine;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.filter.HttpProtocolDecoderException;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.filter.codec.statemachine.ConsumeToDynamicTerminatorDecodingState;
import org.kaazing.mina.filter.codec.statemachine.ConsumeToLinearWhitespaceDecodingState;

public abstract class HttpRequestLineDecodingState
extends DecodingStateMachine {
    private static final Pattern MULTIPLE_LEADING_SLASHES = Pattern.compile("^/[/]+");
    private static final Pattern MULTIPLE_SLASHES = Pattern.compile("/[/]+");
    private static final String SINGLE_SLASH = "/";
    private static final int MAX_HTTP_URI_LENGTH_ALLOWED = 8192;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final CharsetDecoder US_ASCII_DECODER = US_ASCII.newDecoder();
    private final Charset UTF_8 = Charset.forName("UTF-8");
    private final CharsetDecoder UTF_8_DECODER = this.UTF_8.newDecoder();
    private static final byte[] INITIAL_METHOD_BYTES;
    private final DecodingState VALIDATE_METHOD_START = new DecodingState(){

        public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            if (in.hasRemaining()) {
                byte initialByte = in.get(in.position());
                for (byte initialMethodByte : INITIAL_METHOD_BYTES) {
                    if (initialByte != initialMethodByte) continue;
                    return HttpRequestLineDecodingState.this.READ_METHOD;
                }
                throw new ProtocolDecoderException("Unexpected start of HTTP request: " + in.getHexDump());
            }
            return this;
        }

        public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
            return null;
        }
    };
    private final DecodingState READ_METHOD = new ConsumeToLinearWhitespaceDecodingState(this.allocator){

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            HttpMethod method;
            if (!buffer.hasRemaining()) {
                return this;
            }
            String httpMethod = buffer.getString(US_ASCII_DECODER);
            try {
                method = HttpMethod.valueOf(httpMethod);
            }
            catch (IllegalArgumentException e) {
                throw new HttpProtocolDecoderException(HttpStatus.SERVER_NOT_IMPLEMENTED);
            }
            out.write((Object)method);
            return HttpRequestLineDecodingState.this.AFTER_READ_METHOD;
        }
    };
    private final DecodingState AFTER_READ_METHOD = new LinearWhitespaceSkippingState(){

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            return HttpRequestLineDecodingState.this.READ_REQUEST_URI;
        }
    };
    private final DecodingState READ_REQUEST_URI = new ConsumeToLinearWhitespaceDecodingState(this.allocator){

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            String canonicalPath;
            String request = buffer.getString(HttpRequestLineDecodingState.this.UTF_8_DECODER);
            if (request.length() > 8192) {
                throw new HttpProtocolDecoderException(HttpStatus.CLIENT_REQUEST_URI_TOO_LONG);
            }
            request = MULTIPLE_LEADING_SLASHES.matcher(request).replaceAll(HttpRequestLineDecodingState.SINGLE_SLASH);
            URI requestURI = new URI(request);
            String path = requestURI.getPath();
            if (!path.equals(canonicalPath = MULTIPLE_SLASHES.matcher(path).replaceAll(HttpRequestLineDecodingState.SINGLE_SLASH))) {
                String scheme = requestURI.getScheme();
                String authority = requestURI.getAuthority();
                String query = requestURI.getQuery();
                String fragment = requestURI.getFragment();
                requestURI = new URI(scheme, authority, canonicalPath, query, fragment);
            }
            out.write((Object)requestURI);
            return HttpRequestLineDecodingState.this.AFTER_READ_URI;
        }
    };
    private final DecodingState AFTER_READ_URI = new LinearWhitespaceSkippingState(){

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            return HttpRequestLineDecodingState.this.READ_VERSION;
        }
    };
    private final DecodingState READ_VERSION = new ConsumeToDynamicTerminatorDecodingState(this.allocator){

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            HttpVersion version;
            String httpVersion = buffer.getString(US_ASCII_DECODER);
            try {
                version = HttpVersion.valueOf(httpVersion.replaceAll("\\/|\\.", "_"));
            }
            catch (IllegalArgumentException e) {
                throw new HttpProtocolDecoderException(HttpStatus.CLIENT_BAD_REQUEST);
            }
            out.write((Object)version);
            return HttpRequestLineDecodingState.this.AFTER_READ_VERSION;
        }

        protected boolean isTerminator(byte b) {
            return Character.isWhitespace(b);
        }
    };
    private final DecodingState AFTER_READ_VERSION = new LinearWhitespaceSkippingState(){

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            return HttpRequestLineDecodingState.this.READ_END_OF_LINE;
        }
    };
    private final DecodingState READ_END_OF_LINE = new CrLfDecodingState(){

        protected DecodingState finishDecode(boolean foundCRLF, ProtocolDecoderOutput out) throws Exception {
            if (!foundCRLF) {
                throw new ProtocolDecoderException("Expected CRLF at end of line");
            }
            return null;
        }
    };

    public HttpRequestLineDecodingState(IoBufferAllocatorEx<?> allocator) {
        super(allocator);
    }

    protected DecodingState init() throws Exception {
        return this.VALIDATE_METHOD_START;
    }

    protected void destroy() throws Exception {
    }

    static {
        HttpMethod[] httpMethods = HttpMethod.values();
        byte[] initialMethodBytes = new byte[httpMethods.length];
        for (int i = 0; i < initialMethodBytes.length; ++i) {
            initialMethodBytes[i] = (byte)httpMethods[i].name().charAt(0);
        }
        INITIAL_METHOD_BYTES = initialMethodBytes;
    }
}

