/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.CrLfDecodingState;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.kaazing.gateway.transport.DecodingStateMachine;
import org.kaazing.gateway.transport.http.DefaultHttpCookie;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpChunkDecodingState;
import org.kaazing.gateway.transport.http.bridge.filter.HttpHeaderDecodingState;
import org.kaazing.gateway.transport.http.bridge.filter.HttpPersistenceFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpResponseLineDecodingState;
import org.kaazing.gateway.transport.http.bridge.filter.MaximumLengthDecodingState;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.filter.codec.statemachine.FixedLengthDecodingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseDecodingState
extends DecodingStateMachine {
    private static final int MAXIMUM_NON_STREAMING_CONTENT_LENGTH = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseDecodingState.class);
    private final HttpSession httpSession;
    private final DecodingState SKIP_EMPTY_LINES = new CrLfDecodingState(){

        protected DecodingState finishDecode(boolean foundCRLF, ProtocolDecoderOutput out) throws Exception {
            if (foundCRLF) {
                return this;
            }
            return HttpResponseDecodingState.this.READ_RESPONSE_MESSAGE;
        }
    };
    protected final DecodingState FLUSH_MESSAGES = new DecodingState(){

        public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            return HttpResponseDecodingState.this.SKIP_EMPTY_LINES;
        }

        public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
            return HttpResponseDecodingState.this.SKIP_EMPTY_LINES;
        }
    };
    private final DecodingState READ_RESPONSE_MESSAGE = new DecodingStateMachine(this.allocator){

        protected DecodingState init() throws Exception {
            return HttpResponseDecodingState.this.READ_RESPONSE_LINE;
        }

        protected void destroy() throws Exception {
        }

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            if (childProducts.isEmpty()) {
                return this;
            }
            HttpVersion version = (HttpVersion)((Object)childProducts.get(0));
            HttpStatus status = (HttpStatus)((Object)childProducts.get(1));
            String reason = (String)childProducts.get(2);
            Map headers = (Map)childProducts.get(3);
            Set cookies = (Set)childProducts.get(4);
            final HttpResponseMessage httpResponse = new HttpResponseMessage();
            httpResponse.setVersion(version);
            httpResponse.setStatus(status);
            httpResponse.setReason(reason);
            httpResponse.setHeaders(headers);
            httpResponse.setCookies(cookies);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\"" + (Object)((Object)status) + " " + httpResponse.getReason() + " " + (Object)((Object)version) + "\"");
            }
            if (status == HttpStatus.REDIRECT_NOT_MODIFIED) {
                httpResponse.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), true));
                out.write((Object)httpResponse);
                return null;
            }
            if (HttpResponseDecodingState.this.httpSession != null && HttpResponseDecodingState.this.httpSession.getMethod() == HttpMethod.HEAD) {
                httpResponse.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), true));
                out.write((Object)httpResponse);
                return null;
            }
            if (version == HttpVersion.HTTP_1_1 && this.isChunked(httpResponse)) {
                httpResponse.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), false));
                out.write((Object)httpResponse);
                return HttpResponseDecodingState.this.READ_CHUNK;
            }
            String lengthValue = httpResponse.getHeader("Content-Length");
            if (lengthValue != null) {
                int length = this.parseContentLength(lengthValue);
                if (length > 0) {
                    if (length < 4096) {
                        return new FixedLengthDecodingState(this.allocator, length){

                            protected DecodingState finishDecode(IoBuffer readData, ProtocolDecoderOutput out) throws Exception {
                                HttpContentMessage content = new HttpContentMessage((IoBufferEx)readData, true);
                                httpResponse.setContent(content);
                                out.write((Object)httpResponse);
                                return HttpResponseDecodingState.this.FLUSH_MESSAGES;
                            }
                        };
                    }
                    httpResponse.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), false));
                    out.write((Object)httpResponse);
                    return new MaximumLengthDecodingState(length);
                }
                out.write((Object)httpResponse);
                return null;
            }
            if (HttpPersistenceFilter.isClosing(httpResponse)) {
                httpResponse.setContent(new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), false));
                out.write((Object)httpResponse);
                return READ_CONTENT;
            }
            out.write((Object)httpResponse);
            if (status == HttpStatus.INFO_SWITCHING_PROTOCOLS) {
                return HttpResponseDecodingState.this.AFTER_UPGRADE;
            }
            return null;
        }

        private int parseContentLength(String lengthValue) throws ProtocolDecoderException {
            try {
                return Integer.parseInt(lengthValue);
            }
            catch (NumberFormatException e) {
                throw new ProtocolDecoderException("Invalid content length: " + lengthValue);
            }
        }

        private boolean isChunked(HttpResponseMessage httpResponse) throws ProtocolDecoderException {
            String transferEncoding = httpResponse.getHeader("Transfer-Encoding");
            if (transferEncoding != null) {
                int semicolonAt = transferEncoding.indexOf(59);
                if (semicolonAt != -1) {
                    transferEncoding = transferEncoding.substring(0, semicolonAt);
                }
                if ("chunked".equalsIgnoreCase(transferEncoding)) {
                    return true;
                }
                throw new ProtocolDecoderException("Unexpected transfer coding: " + transferEncoding);
            }
            return false;
        }
    };
    private final DecodingState READ_RESPONSE_LINE = new HttpResponseLineDecodingState(this.allocator){

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            if (childProducts.isEmpty()) {
                return this;
            }
            HttpVersion httpVersion = (HttpVersion)((Object)childProducts.get(0));
            HttpStatus httpStatus = (HttpStatus)((Object)childProducts.get(1));
            String httpReason = (String)childProducts.get(2);
            out.write((Object)httpVersion);
            out.write((Object)httpStatus);
            out.write((Object)httpReason);
            return HttpResponseDecodingState.this.READ_HEADERS;
        }
    };
    private final DecodingState READ_HEADERS = new HttpHeaderDecodingState(this.allocator){

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            Map headers = (Map)childProducts.get(0);
            HashSet<DefaultHttpCookie> cookies = new HashSet<DefaultHttpCookie>();
            List cookieHeaderValues = (List)headers.get("Set-Cookie");
            if (cookieHeaderValues != null && !cookieHeaderValues.isEmpty()) {
                String[] cookieValues;
                String cookieHeaderValue = (String)cookieHeaderValues.get(0);
                for (String cookieValue : cookieValues = cookieHeaderValue.split(",")) {
                    String[] nvPairs = cookieValue.split(";");
                    int nvPairCount = nvPairs.length;
                    if (nvPairCount <= 0) continue;
                    String[] nvPair = nvPairs[0].split("=");
                    DefaultHttpCookie cookie = new DefaultHttpCookie(nvPair[0].trim());
                    if (nvPair.length > 1) {
                        cookie.setValue(nvPair[1].trim());
                    }
                    block9: for (int i = 1; i < nvPairCount; ++i) {
                        nvPair = nvPairs[i].split("=");
                        boolean hasValue = nvPair.length > 1;
                        String avName = nvPair[0].trim();
                        if (avName.length() <= 0) continue;
                        switch (avName.charAt(0)) {
                            case 'C': 
                            case 'c': {
                                if (!"Comment".equalsIgnoreCase(avName) || !hasValue) continue block9;
                                cookie.setComment(nvPair[1].trim());
                                continue block9;
                            }
                            case 'D': 
                            case 'd': {
                                if (!"Domain".equalsIgnoreCase(avName) || !hasValue) continue block9;
                                cookie.setDomain(nvPair[1].trim());
                                continue block9;
                            }
                            case 'M': 
                            case 'm': {
                                if (!"Max-Age".equalsIgnoreCase(avName) || !hasValue) continue block9;
                                cookie.setMaxAge(Integer.parseInt(nvPair[1].trim()));
                                continue block9;
                            }
                            case 'P': 
                            case 'p': {
                                if (!"Path".equalsIgnoreCase(avName) || !hasValue) continue block9;
                                cookie.setPath(nvPair[1].trim());
                                continue block9;
                            }
                            case 'S': 
                            case 's': {
                                if (!"Secure".equalsIgnoreCase(avName)) continue block9;
                                cookie.setSecure(true);
                                continue block9;
                            }
                            case 'V': 
                            case 'v': {
                                if (!"Version".equalsIgnoreCase(avName) || !hasValue) continue block9;
                                cookie.setVersion(Integer.parseInt(nvPair[1].trim()));
                            }
                        }
                    }
                    cookies.add(cookie);
                }
            }
            out.write((Object)headers);
            out.write(cookies);
            return null;
        }
    };
    private final DecodingState READ_CHUNK = new HttpChunkDecodingState(this.allocator){

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            if (childProducts.isEmpty()) {
                throw new ProtocolDecoderException("Expected a chunk");
            }
            IoBufferEx data = (IoBufferEx)childProducts.get(0);
            if (data.hasRemaining()) {
                out.write((Object)new HttpContentMessage(data, false));
                return HttpResponseDecodingState.this.READ_CHUNK;
            }
            out.write((Object)new HttpContentMessage(this.allocator.wrap(this.allocator.allocate(0)), true));
            return null;
        }
    };
    private static final DecodingState READ_CONTENT = new DecodingState(){

        public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            HttpContentMessage content = new HttpContentMessage((IoBufferEx)in.duplicate(), false);
            out.write((Object)content);
            in.position(in.limit());
            return this;
        }

        public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
            return null;
        }
    };
    private final DecodingState AFTER_UPGRADE = new DecodingState(){

        public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            out.write((Object)in.duplicate());
            in.position(in.limit());
            return this;
        }

        public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
            return null;
        }
    };

    public HttpResponseDecodingState(IoBufferAllocatorEx<?> allocator, HttpSession httpSession) {
        super(allocator);
        this.httpSession = httpSession;
    }

    protected DecodingState init() throws Exception {
        return this.SKIP_EMPTY_LINES;
    }

    protected void destroy() throws Exception {
    }

    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecodingState decodingState = super.decode(in, out);
        this.flush(this.childProducts, out);
        return decodingState;
    }

    protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
        this.flush(childProducts, out);
        return null;
    }

    private void flush(List<Object> childProducts, ProtocolDecoderOutput out) {
        Iterator<Object> i = childProducts.iterator();
        while (i.hasNext()) {
            Object product = i.next();
            i.remove();
            out.write(product);
        }
    }
}

