/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.kaazing.gateway.transport.bridge.CachingMessageEncoder;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpGzipEncoder;
import org.kaazing.gateway.transport.http.bridge.filter.HttpMessageEncoder;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;

public final class HttpResponseEncoder
extends HttpMessageEncoder<HttpResponseMessage> {
    private static final byte[] COOKIE_HEADER_BYTES = "Set-Cookie: ".getBytes();
    private static final byte[] COOKIE_COMMENT_BYTES = "; Comment=".getBytes();
    private static final byte[] COOKIE_DOMAIN_BYTES = "; Domain=".getBytes();
    private static final byte[] COOKIE_MAX_AGE_BYTES = "; Max-Age=".getBytes();
    private static final byte[] COOKIE_PATH_BYTES = "; Path=".getBytes();
    private static final byte[] COOKIE_SECURE_BYTES = "; Secure".getBytes();
    private static final byte[] COOKIE_VERSION_BYTES = "; Version=".getBytes();

    public HttpResponseEncoder(IoBufferAllocatorEx<?> allocator) {
        this(CachingMessageEncoder.IO_MESSAGE_ENCODER, allocator);
    }

    public HttpResponseEncoder(CachingMessageEncoder cachingEncoder, IoBufferAllocatorEx<?> allocator) {
        super(cachingEncoder, allocator);
    }

    @Override
    protected void encode(IoSessionEx session, HttpMessage httpMessage, ProtocolEncoderOutput out) throws Exception {
        switch (httpMessage.getKind()) {
            case CONTENT: {
                HttpContentMessage httpContent = (HttpContentMessage)httpMessage;
                this.encodeContent(session, httpContent, out);
                break;
            }
            case RESPONSE: {
                HttpResponseMessage httpResponse = (HttpResponseMessage)httpMessage;
                this.encodeResponse(session, httpResponse, out);
                break;
            }
            default: {
                throw new ProtocolEncoderException("Unexpected HTTP message kind: " + (Object)((Object)httpMessage.getKind()));
            }
        }
    }

    private void encodeResponse(IoSessionEx session, HttpResponseMessage httpResponse, ProtocolEncoderOutput out) throws Exception {
        HttpContentMessage httpContent;
        boolean isGzipped = HttpUtils.isGzipped(httpResponse);
        boolean isChunked = HttpUtils.isChunked(httpResponse);
        ByteBuffer nioBuf = this.allocator.allocate(1024);
        IoBufferEx buf = this.allocator.wrap(nioBuf).setAutoExpander(this.allocator);
        int allocatedPos = buf.position();
        this.encodeResponseLine(httpResponse.getVersion(), httpResponse.getStatus(), httpResponse.getReason(), buf);
        this.encodeHeaders(session, httpResponse, buf);
        if (isGzipped) {
            buf.put(HttpGzipEncoder.GZIP_START_OF_FRAME_BYTES);
        }
        if ((httpContent = httpResponse.getContent()) != null) {
            this.encodeContent(session, httpContent, buf, isChunked, isGzipped);
        }
        buf.flip();
        buf.position(allocatedPos);
        out.write((Object)buf);
    }

    private void encodeResponseLine(HttpVersion version, HttpStatus status, String reason, IoBufferEx buf) throws CharacterCodingException {
        assert (version != null) : "version required in response";
        assert (status != null) : "status required in response";
        switch (version) {
            case HTTP_1_0: {
                buf.put(HTTP_1_0_BYTES);
                break;
            }
            case HTTP_1_1: {
                buf.put(HTTP_1_1_BYTES);
            }
        }
        buf.put(SPACE_BYTES);
        buf.putString((CharSequence)Integer.toString(status.code()), this.asciiEncoder);
        if (reason == null) {
            reason = status.reason();
        }
        buf.put(SPACE_BYTES);
        buf.putString((CharSequence)reason, this.asciiEncoder);
        buf.put(CRLF_BYTES);
    }

    @Override
    protected void encodeContentLength(IoSessionEx session, HttpResponseMessage httpResponse, IoBufferEx buf) throws CharacterCodingException {
        switch (httpResponse.getStatus()) {
            case INFO_SWITCHING_PROTOCOLS: 
            case REDIRECT_NOT_MODIFIED: {
                break;
            }
            default: {
                if (httpResponse.getHeader("Content-Length") != null || httpResponse.getHeader("Transfer-Encoding") != null) break;
                super.encodeContentLength(session, httpResponse, buf);
            }
        }
    }

    @Override
    protected void encodeCookies(IoSessionEx session, HttpResponseMessage httpResponse, IoBufferEx buf) throws CharacterCodingException {
        for (HttpCookie cookie : httpResponse.getCookies()) {
            String name = cookie.getName();
            String comment = cookie.getComment();
            String domain = cookie.getDomain();
            long maxAge = cookie.getMaxAge();
            String path = cookie.getPath();
            boolean secure = cookie.isSecure();
            String value = cookie.getValue();
            int version = cookie.getVersion();
            buf.put(COOKIE_HEADER_BYTES);
            buf.putString((CharSequence)name, this.asciiEncoder);
            buf.put(EQUAL_BYTES);
            buf.putString((CharSequence)value, this.asciiEncoder);
            if (comment != null) {
                buf.put(COOKIE_COMMENT_BYTES);
                buf.putString((CharSequence)comment, this.asciiEncoder);
            }
            if (domain != null) {
                buf.put(COOKIE_DOMAIN_BYTES);
                buf.putString((CharSequence)domain, this.asciiEncoder);
            }
            if (maxAge > 0L) {
                buf.put(COOKIE_MAX_AGE_BYTES);
                buf.putString((CharSequence)Long.toString(maxAge), this.asciiEncoder);
            }
            if (path != null) {
                buf.put(COOKIE_PATH_BYTES);
                buf.putString((CharSequence)path, this.asciiEncoder);
            }
            if (secure) {
                buf.put(COOKIE_SECURE_BYTES);
            }
            if (version > 0) {
                buf.put(COOKIE_VERSION_BYTES);
                buf.putString((CharSequence)Integer.toString(version), this.asciiEncoder);
            }
            buf.put(SEMI_BYTES);
            buf.put(CRLF_BYTES);
        }
    }
}

