/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.apache.mina.filter.codec.statemachine.LinearWhitespaceSkippingState;
import org.kaazing.gateway.transport.DecodingStateMachine;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.filter.codec.statemachine.ConsumeToCrLfDecodingState;
import org.kaazing.mina.filter.codec.statemachine.ConsumeToLinearWhitespaceDecodingState;

public abstract class HttpResponseLineDecodingState
extends DecodingStateMachine {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final CharsetDecoder US_ASCII_DECODER = US_ASCII.newDecoder();
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final CharsetDecoder UTF_8_DECODER = UTF_8.newDecoder();
    private final DecodingState READ_VERSION = new ConsumeToLinearWhitespaceDecodingState(this.allocator){
        boolean verifiedVersion;

        public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            if (!this.verifiedVersion && in.hasRemaining()) {
                this.verifiedVersion = true;
                byte ch = in.get(in.position());
                if (ch != 72) {
                    throw new ProtocolDecoderException("Invalid HTTP version, starting with char = " + ch);
                }
            }
            return super.decode(in, out);
        }

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            if (!buffer.hasRemaining()) {
                return this;
            }
            String httpVersion = buffer.getString(HttpResponseLineDecodingState.this.US_ASCII_DECODER);
            out.write((Object)HttpVersion.valueOf(httpVersion.replaceAll("\\/|\\.", "_")));
            return HttpResponseLineDecodingState.this.AFTER_READ_VERSION;
        }
    };
    private final DecodingState AFTER_READ_VERSION = new LinearWhitespaceSkippingState(){

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            return HttpResponseLineDecodingState.this.READ_STATUS;
        }
    };
    private final DecodingState READ_STATUS = new ConsumeToLinearWhitespaceDecodingState(this.allocator){

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            String statusCode = buffer.getString(HttpResponseLineDecodingState.this.UTF_8_DECODER);
            out.write((Object)HttpStatus.getHttpStatus(statusCode));
            return HttpResponseLineDecodingState.this.AFTER_READ_STATUS;
        }
    };
    private final DecodingState AFTER_READ_STATUS = new LinearWhitespaceSkippingState(){

        protected DecodingState finishDecode(int skippedBytes) throws Exception {
            return HttpResponseLineDecodingState.this.READ_REASON;
        }
    };
    private final DecodingState READ_REASON = new ConsumeToCrLfDecodingState(this.allocator){

        protected DecodingState finishDecode(IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
            String httpReason = buffer.getString(HttpResponseLineDecodingState.this.US_ASCII_DECODER);
            out.write((Object)httpReason);
            return null;
        }
    };

    public HttpResponseLineDecodingState(IoBufferAllocatorEx<?> allocator) {
        super(allocator);
    }

    protected DecodingState init() throws Exception {
        return this.READ_VERSION;
    }

    protected void destroy() throws Exception {
    }
}

