/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSerializeRequestsFilter
extends HttpFilterAdapter<IoSessionEx> {
    private final Queue<Object> messageQueue = new ConcurrentLinkedQueue<Object>();
    private final Logger logger;
    private final AtomicInteger requestsCompleted = new AtomicInteger();
    private final AtomicInteger responsesCompleted = new AtomicInteger();
    private boolean lastHttpResponseComplete;

    public HttpSerializeRequestsFilter() {
        this(LoggerFactory.getLogger(HttpSerializeRequestsFilter.class));
    }

    public HttpSerializeRequestsFilter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (this.requestsCompleted.get() == this.responsesCompleted.get()) {
            super.messageReceived(nextFilter, session, message);
        } else {
            if (this.messageQueue.isEmpty()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("[%s#%s] Suspending reads for HTTP pipelined request", "http", session.getId()));
                }
                session.suspendRead();
            }
            this.messageQueue.add(message);
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        super.filterWrite(nextFilter, session, writeRequest);
        while (!this.messageQueue.isEmpty() && this.requestsCompleted.get() == this.responsesCompleted.get()) {
            Object message = this.messageQueue.poll();
            if (message == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("[%s#%s] Resuming reads for HTTP pipelined request", "http", session.getId()));
                }
                session.resumeRead();
                break;
            }
            super.messageReceived(nextFilter, session, message);
        }
    }

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpRequestMessage httpRequest) throws Exception {
        if (httpRequest.isComplete()) {
            this.requestsCompleted.incrementAndGet();
        }
        super.httpRequestReceived(nextFilter, session, httpRequest);
    }

    @Override
    protected void httpContentReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, HttpContentMessage httpContent) throws Exception {
        if (httpContent.isComplete()) {
            this.requestsCompleted.incrementAndGet();
        }
        super.httpContentReceived(nextFilter, session, httpContent);
    }

    @Override
    protected Object doFilterWriteHttpResponse(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
        this.lastHttpResponseComplete = httpResponse.isComplete();
        if (httpResponse.isComplete()) {
            this.responsesCompleted.incrementAndGet();
        }
        return super.doFilterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
    }

    @Override
    protected Object doFilterWriteHttpContent(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest, HttpContentMessage httpContent) throws Exception {
        if (httpContent.isComplete() && !this.lastHttpResponseComplete) {
            this.responsesCompleted.incrementAndGet();
        }
        return super.doFilterWriteHttpContent(nextFilter, session, writeRequest, httpContent);
    }
}

