/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpRealmInfo;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.security.TypedCallbackHandlerMap;
import org.kaazing.gateway.security.auth.DefaultLoginResult;
import org.kaazing.gateway.security.auth.NamedSubjectCallbackHandler;
import org.kaazing.gateway.security.auth.context.ResultAwareLoginContext;
import org.kaazing.gateway.security.auth.token.DefaultAuthenticationToken;
import org.kaazing.gateway.server.ExpiringState;
import org.kaazing.gateway.server.spi.security.AuthenticationToken;
import org.kaazing.gateway.server.spi.security.NamedSubjectCallback;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.bridge.HttpMessage;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpLoginSecurityFilter;
import org.kaazing.gateway.transport.http.security.auth.token.DefaultAuthenticationTokenExtractor;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;

public class HttpSubjectSecurityFilter
extends HttpLoginSecurityFilter {
    public static final String AUTH_SCHEME_APPLICATION_PREFIX = "Application ";
    public static final String AUTH_SCHEME_BASIC = "Basic";
    public static final String AUTH_SCHEME_NEGOTIATE = "Negotiate";
    static final AttributeKey NEW_SESSION_COOKIE_KEY = new AttributeKey(HttpSubjectSecurityFilter.class, "sessionCookie");
    private final AuthorizationMap authorizationMap = new AuthorizationMap();
    private ScheduledExecutorService scheduler;

    public HttpSubjectSecurityFilter() {
        this(null, null);
    }

    public HttpSubjectSecurityFilter(Logger logger) {
        this(logger, null);
    }

    public HttpSubjectSecurityFilter(Logger logger, ExpiringState expiringState) {
        super(logger, expiringState);
    }

    public void setSchedulerProvider(SchedulerProvider provider) {
        this.scheduler = provider.getScheduler("loginmodule", false);
    }

    public void doMessageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        ResourceAddress httpAddress;
        HttpRealmInfo[] realms;
        if (!this.httpRequestMessageReceived(nextFilter, session, message)) {
            return;
        }
        HttpRequestMessage httpRequest = (HttpRequestMessage)((Object)message);
        if (httpRequest.getSubject() == null) {
            httpRequest.setSubject(((IoSessionEx)session).getSubject());
        }
        if ((realms = (HttpRealmInfo[])(httpAddress = httpRequest.getLocalAddress()).getOption(HttpResourceAddress.REALMS)).length == 0) {
            boolean loggerIsEnabled;
            ResultAwareLoginContext loginContext = null;
            if (session instanceof DefaultHttpSession) {
                loginContext = ((DefaultHttpSession)session).getLoginContext();
            }
            if (loginContext != null) {
                httpRequest.setLoginContext(loginContext);
            } else {
                this.setUnprotectedLoginContext(httpRequest);
            }
            boolean bl = loggerIsEnabled = this.logger != null && this.logger.isTraceEnabled();
            if (loggerIsEnabled) {
                this.logger.trace("HttpSubjectSecurityFilter skipped because no realm is configured.");
            }
            super.doMessageReceived(nextFilter, session, message);
            return;
        }
        this.securityMessageReceived(nextFilter, session, (Object)httpRequest);
    }

    @Override
    protected void writeSessionCookie(IoSession session, HttpRequestMessage httpRequest, DefaultLoginResult loginResult) {
        HttpCookie newSessionCookie = (HttpCookie)loginResult.getLoginAuthorizationAttachment();
        httpRequest.addCookie(newSessionCookie);
        session.setAttribute((Object)NEW_SESSION_COOKIE_KEY, (Object)newSessionCookie);
        if (this.loggerEnabled()) {
            this.logger.trace("Sending session cookie {}", (Object)newSessionCookie);
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        HttpMessage httpMessage = (HttpMessage)((Object)message);
        switch (httpMessage.getKind()) {
            case RESPONSE: {
                HttpResponseMessage httpResponse = (HttpResponseMessage)httpMessage;
                HttpCookie sessionCookie = (HttpCookie)session.removeAttribute((Object)NEW_SESSION_COOKIE_KEY);
                if (sessionCookie == null) break;
                httpResponse.addCookie(sessionCookie);
                break;
            }
        }
        super.filterWrite(nextFilter, session, writeRequest);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        if (this.loggerEnabled()) {
            this.logger.trace("Caught exception.", cause);
        }
        super.exceptionCaught(nextFilter, session, cause);
    }

    public void destroy() throws Exception {
        super.destroy();
    }

    AuthorizationMap getAuthorizationMap() {
        return this.authorizationMap;
    }

    void securityMessageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        boolean loggerIsEnabled;
        boolean bl = loggerIsEnabled = this.logger != null && this.logger.isTraceEnabled();
        if (!this.httpRequestMessageReceived(nextFilter, session, message)) {
            return;
        }
        HttpRequestMessage httpRequest = (HttpRequestMessage)((Object)message);
        ResourceAddress httpAddress = httpRequest.getLocalAddress();
        if (this.alreadyLoggedIn(httpRequest)) {
            if (httpRequest.getLoginContext() == null) {
                this.setUnprotectedLoginContext(httpRequest);
            }
            if (loggerIsEnabled) {
                this.logger.trace("HttpSubjectSecurityFilter skipped because we are already allowed or logged in.");
            }
            super.doMessageReceived(nextFilter, session, message);
            return;
        }
        HttpRealmInfo[] realms = (HttpRealmInfo[])httpAddress.getOption(HttpResourceAddress.REALMS);
        if (realms.length == 0) {
            this.setUnprotectedLoginContext(httpRequest);
            if (loggerIsEnabled) {
                this.logger.trace("HttpSecurityStandardFilter skipped because no realm is configured.");
            }
            super.doMessageReceived(nextFilter, session, message);
            return;
        }
        String challengeIdentity = httpRequest.getHeader("Sec-Challenge-Identity");
        LoginContext[] loginContexts = this.getLoginContexts(challengeIdentity);
        int realmIndex = HttpSubjectSecurityFilter.findCurrentRealm(loginContexts);
        HttpRealmInfo realm = realms[realmIndex];
        DefaultAuthenticationTokenExtractor tokenExtractor = DefaultAuthenticationTokenExtractor.INSTANCE;
        DefaultAuthenticationToken authToken = (DefaultAuthenticationToken)tokenExtractor.extract(httpRequest, realm);
        String clientChallengeScheme = authToken.getScheme();
        String expectedChallengeScheme = this.getBaseAuthScheme(realm.getChallengeScheme());
        if (clientChallengeScheme != null && !clientChallengeScheme.equals(expectedChallengeScheme)) {
            if (this.loggerEnabled()) {
                this.logger.trace(String.format("A websocket request used the '%s' challenge scheme when we expected the '%s' challenge scheme", clientChallengeScheme, expectedChallengeScheme));
            }
            String reason = String.format("Expected challenge scheme '%s' not found", expectedChallengeScheme);
            this.writeResponse(HttpStatus.CLIENT_BAD_REQUEST, reason, nextFilter, session, httpRequest);
            return;
        }
        authToken.setScheme(expectedChallengeScheme);
        this.suspendIncoming(session);
        TypedCallbackHandlerMap additionalCallbacks = null;
        if (realmIndex > 0) {
            additionalCallbacks = new TypedCallbackHandlerMap();
            Function<String, Subject> subjects = name -> this.findNamedSubject((String)name, realms, realmIndex, loginContexts);
            NamedSubjectCallbackHandler callbackHandler = new NamedSubjectCallbackHandler(subjects);
            additionalCallbacks.put(NamedSubjectCallback.class, (CallbackHandler)callbackHandler);
        }
        LoginContextTask loginContextTask = new LoginContextTask(nextFilter, session, httpRequest, authToken, additionalCallbacks, realms, realmIndex, loginContexts);
        this.scheduler.execute(loginContextTask);
    }

    private Subject findNamedSubject(String name, HttpRealmInfo[] realms, int realmIndex, LoginContext[] loginContexts) {
        for (int i = realmIndex - 1; i >= 0; --i) {
            if (!realms[i].getName().equals(name)) continue;
            return loginContexts[i].getSubject();
        }
        return null;
    }

    protected static int findCurrentRealm(LoginContext[] loginContexts) {
        if (loginContexts == null || loginContexts.length == 0) {
            return 0;
        }
        for (int i = 0; i < loginContexts.length; ++i) {
            if (loginContexts[i] != null) continue;
            return i;
        }
        return 0;
    }

    private final class LoginContextTask
    implements Runnable {
        private final IoFilter.NextFilter nextFilter;
        private final IoSession session;
        private final HttpRequestMessage httpRequest;
        private final DefaultAuthenticationToken authToken;
        private final TypedCallbackHandlerMap additionalCallbacks;
        private final long createdTime;
        private final HttpRealmInfo[] realms;
        private final int realmStartAt;
        private final LoginContext[] loginContexts;

        LoginContextTask(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest, DefaultAuthenticationToken authToken, TypedCallbackHandlerMap additionalCallbacks, HttpRealmInfo[] realms, int realmIndex, LoginContext[] loginContexts) {
            this.nextFilter = nextFilter;
            this.session = session;
            this.httpRequest = httpRequest;
            this.authToken = authToken;
            this.additionalCallbacks = additionalCallbacks;
            this.createdTime = System.currentTimeMillis();
            this.realms = realms;
            this.realmStartAt = realmIndex;
            this.loginContexts = loginContexts != null ? loginContexts : new LoginContext[realms.length];
        }

        @Override
        public void run() {
            if (HttpSubjectSecurityFilter.this.loggerEnabled()) {
                HttpSubjectSecurityFilter.this.logger.trace("Executing login task %d ms after scheduling for session %s", (Object)(System.currentTimeMillis() - this.createdTime), (Object)this.session);
            }
            boolean succeeded = true;
            for (int realmIndex = this.realmStartAt; succeeded && realmIndex < this.realms.length; succeeded &= HttpSubjectSecurityFilter.this.login(this.nextFilter, this.session, this.httpRequest, (AuthenticationToken)this.authToken, this.additionalCallbacks, this.realms, realmIndex, this.loginContexts), ++realmIndex) {
            }
            try {
                if (succeeded) {
                    HttpSubjectSecurityFilter.super.doMessageReceived(this.nextFilter, this.session, (Object)this.httpRequest);
                }
                HttpSubjectSecurityFilter.super.resumeIncoming(this.session);
            }
            catch (Exception e) {
                this.session.getFilterChain().fireExceptionCaught((Throwable)e);
            }
            if (HttpSubjectSecurityFilter.this.loggerEnabled()) {
                HttpSubjectSecurityFilter.this.logger.trace("Finished login task after %d ms for session %s", (Object)(System.currentTimeMillis() - this.createdTime), (Object)this.session);
            }
        }
    }

    public static class AuthorizationMap {
        private Map<String, TimedCredential> keyToTimedCredentialMap = new ConcurrentHashMap<String, TimedCredential>();
        private Map<Subject, String> subjectToKeyMap = new ConcurrentHashMap<Subject, String>();

        TimedCredential get(String key) {
            return this.keyToTimedCredentialMap.get(key);
        }

        public TimedCredential get(String realmName, String key) {
            return this.keyToTimedCredentialMap.get(realmName + key);
        }

        public synchronized void put(String realmName, String key, TimedCredential value) {
            this.keyToTimedCredentialMap.put(realmName + key, value);
            this.subjectToKeyMap.put(value.subject, realmName + key);
        }

        public synchronized TimedCredential removeByKey(String realmName, String key) {
            TimedCredential removedValue = this.keyToTimedCredentialMap.remove(realmName + key);
            if (removedValue != null && removedValue.subject != null) {
                this.subjectToKeyMap.remove(removedValue.subject);
            }
            return removedValue;
        }

        public synchronized String removeBySubject(Subject subject) {
            String removedKey = this.subjectToKeyMap.remove(subject);
            if (removedKey != null) {
                this.keyToTimedCredentialMap.remove(removedKey);
            }
            return removedKey;
        }

        public boolean containsKey(String key) {
            return this.keyToTimedCredentialMap.containsKey(key);
        }

        public boolean containsSubject(Subject subject) {
            return this.subjectToKeyMap.containsKey(subject);
        }

        public String getKey(Subject subject) {
            return this.subjectToKeyMap.get(subject);
        }

        public int size() {
            return this.keyToTimedCredentialMap.size();
        }
    }

    public static class TimedCredential {
        private Subject subject;
        private Long expirationTimestamp;

        public TimedCredential(Subject subject, Long expirationTimestamp) {
            if (subject == null) {
                throw new IllegalArgumentException("subject was null");
            }
            this.subject = subject;
            this.expirationTimestamp = expirationTimestamp;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public boolean hasExpirationTimestamp() {
            return this.expirationTimestamp != null;
        }

        public Long getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        public void setExpirationTimestamp(Long expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[TimedCredential: Subject(");
            for (Principal p : this.subject.getPrincipals()) {
                sb.append(p.getName()).append('/');
            }
            if (this.subject.getPrincipals().size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(") ");
            if (this.expirationTimestamp != null) {
                String expires = new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date(this.expirationTimestamp * 1000L));
                sb.append("; expires on ").append(expires);
            }
            sb.append(" ]");
            return sb.toString();
        }
    }
}

